package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageLayerBuilder extends io.fabric8.openshift.api.model.ImageLayerFluentImpl<io.fabric8.openshift.api.model.ImageLayerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageLayer,io.fabric8.openshift.api.model.ImageLayerBuilder> {

    io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageLayerBuilder() {
        this(true);
    }

    public ImageLayerBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,io.fabric8.openshift.api.model.ImageLayer instance) {
        this(fluent, instance, true);
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayerFluent<?> fluent,io.fabric8.openshift.api.model.ImageLayer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMediaType(instance.getMediaType()); 
        fluent.withName(instance.getName()); 
        fluent.withSize(instance.getSize()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayer instance) {
        this(instance,true);
    }

    public ImageLayerBuilder(io.fabric8.openshift.api.model.ImageLayer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMediaType(instance.getMediaType()); 
        this.withName(instance.getName()); 
        this.withSize(instance.getSize()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ImageLayer build() {
        ImageLayer buildable = new ImageLayer(fluent.getMediaType(),fluent.getName(),fluent.getSize());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageLayerBuilder that = (ImageLayerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
