package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageListBuilder extends io.fabric8.openshift.api.model.ImageListFluentImpl<io.fabric8.openshift.api.model.ImageListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageList,io.fabric8.openshift.api.model.ImageListBuilder> {

    io.fabric8.openshift.api.model.ImageListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageListBuilder() {
        this(true);
    }

    public ImageListBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageList(), validationEnabled);
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageList(), validationEnabled);
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,io.fabric8.openshift.api.model.ImageList instance) {
        this(fluent, instance, true);
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,io.fabric8.openshift.api.model.ImageList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageList instance) {
        this(instance,true);
    }

    public ImageListBuilder(io.fabric8.openshift.api.model.ImageList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.ImageList build() {
        ImageList buildable = new ImageList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageListBuilder that = (ImageListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
