package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

public class ImageSourceFluentImpl<A extends io.fabric8.openshift.api.model.ImageSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageSourceFluent<A> {

    private java.util.List<java.lang.String> as = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder from;
    private java.util.List<io.fabric8.openshift.api.model.ImageSourcePathBuilder> paths =  new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>();
    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder pullSecret;

    public ImageSourceFluentImpl() {
    }

    public ImageSourceFluentImpl(io.fabric8.openshift.api.model.ImageSource instance) {
        this.withAs(instance.getAs()); 
        this.withFrom(instance.getFrom()); 
        this.withPaths(instance.getPaths()); 
        this.withPullSecret(instance.getPullSecret()); 
    }

    public A addToAs(int index,java.lang.String item) {
        if (this.as == null) {this.as = new java.util.ArrayList<java.lang.String>();}
        this.as.add(index, item);
        return (A)this;
    }

    public A setToAs(int index,java.lang.String item) {
        if (this.as == null) {this.as = new java.util.ArrayList<java.lang.String>();}
        this.as.set(index, item); return (A)this;
    }

    public A addToAs(java.lang.String... items) {
        if (this.as == null) {this.as = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.as.add(item);} return (A)this;
    }

    public A addAllToAs(java.util.Collection<java.lang.String> items) {
        if (this.as == null) {this.as = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.as.add(item);} return (A)this;
    }

    public A removeFromAs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.as!= null){ this.as.remove(item);}} return (A)this;
    }

    public A removeAllFromAs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.as!= null){ this.as.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAs() {
        return this.as;
    }

    public java.lang.String getA(int index) {
        return this.as.get(index);
    }

    public java.lang.String getFirstA() {
        return this.as.get(0);
    }

    public java.lang.String getLastA() {
        return this.as.get(as.size() - 1);
    }

    public java.lang.String getMatchingA(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: as) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingA(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: as) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAs(java.util.List<java.lang.String> as) {
        if (this.as != null) { _visitables.get("as").removeAll(this.as);}
        if (as != null) {this.as = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : as){this.addToAs(item);}} else { this.as = null;} return (A) this;
    }

    public A withAs(java.lang.String... as) {
        if (this.as != null) {this.as.clear();}
        if (as != null) {for (java.lang.String item :as){ this.addToAs(item);}} return (A) this;
    }

    public java.lang.Boolean hasAs() {
        return as != null && !as.isEmpty();
    }

    public A addNewA(java.lang.String arg0) {
        return (A)addToAs(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFrom instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
        return this.from!=null?this.from.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
        return this.from!=null?this.from.build():null;
    }

    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
        _visitables.get("from").remove(this.from);
        if (from!=null){ this.from= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
    }

    public java.lang.Boolean hasFrom() {
        return this.from != null;
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> withNewFrom() {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.FromNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.FromNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editFrom() {
        return withNewFromLike(getFrom());
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editOrNewFrom() {
        return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
        return withNewFromLike(getFrom() != null ? getFrom(): item);
    }

    public A addToPaths(int index,io.fabric8.openshift.api.model.ImageSourcePath item) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>();}
        io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);_visitables.get("paths").add(index >= 0 ? index : _visitables.get("paths").size(), builder);this.paths.add(index >= 0 ? index : paths.size(), builder); return (A)this;
    }

    public A setToPaths(int index,io.fabric8.openshift.api.model.ImageSourcePath item) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>();}
        io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);
        if (index < 0 || index >= _visitables.get("paths").size()) { _visitables.get("paths").add(builder); } else { _visitables.get("paths").set(index, builder);}
        if (index < 0 || index >= paths.size()) { paths.add(builder); } else { paths.set(index, builder);}
         return (A)this;
    }

    public A addToPaths(io.fabric8.openshift.api.model.ImageSourcePath... items) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>();}
        for (io.fabric8.openshift.api.model.ImageSourcePath item : items) {io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
    }

    public A addAllToPaths(java.util.Collection<io.fabric8.openshift.api.model.ImageSourcePath> items) {
        if (this.paths == null) {this.paths = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>();}
        for (io.fabric8.openshift.api.model.ImageSourcePath item : items) {io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
    }

    public A removeFromPaths(io.fabric8.openshift.api.model.ImageSourcePath... items) {
        for (io.fabric8.openshift.api.model.ImageSourcePath item : items) {io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);_visitables.get("paths").remove(builder);if (this.paths != null) {this.paths.remove(builder);}} return (A)this;
    }

    public A removeAllFromPaths(java.util.Collection<io.fabric8.openshift.api.model.ImageSourcePath> items) {
        for (io.fabric8.openshift.api.model.ImageSourcePath item : items) {io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(item);_visitables.get("paths").remove(builder);if (this.paths != null) {this.paths.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPaths(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourcePathBuilder> predicate) {
        if (paths == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.ImageSourcePathBuilder> each = paths.iterator();
        final List visitables = _visitables.get("paths");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.ImageSourcePathBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPaths instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.ImageSourcePath> getPaths() {
        return build(paths);
    }

    public java.util.List<io.fabric8.openshift.api.model.ImageSourcePath> buildPaths() {
        return build(paths);
    }

    public io.fabric8.openshift.api.model.ImageSourcePath buildPath(int index) {
        return this.paths.get(index).build();
    }

    public io.fabric8.openshift.api.model.ImageSourcePath buildFirstPath() {
        return this.paths.get(0).build();
    }

    public io.fabric8.openshift.api.model.ImageSourcePath buildLastPath() {
        return this.paths.get(paths.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.ImageSourcePath buildMatchingPath(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourcePathBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ImageSourcePathBuilder item: paths) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingPath(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourcePathBuilder> predicate) {
        for (io.fabric8.openshift.api.model.ImageSourcePathBuilder item: paths) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPaths(java.util.List<io.fabric8.openshift.api.model.ImageSourcePath> paths) {
        if (this.paths != null) { _visitables.get("paths").removeAll(this.paths);}
        if (paths != null) {this.paths = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageSourcePathBuilder>(); for (io.fabric8.openshift.api.model.ImageSourcePath item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
    }

    public A withPaths(io.fabric8.openshift.api.model.ImageSourcePath... paths) {
        if (this.paths != null) {this.paths.clear();}
        if (paths != null) {for (io.fabric8.openshift.api.model.ImageSourcePath item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public java.lang.Boolean hasPaths() {
        return paths != null && !paths.isEmpty();
    }

    public A addNewPath(java.lang.String destinationDir,java.lang.String sourcePath) {
        return (A)addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> addNewPath() {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.PathsNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> addNewPathLike(io.fabric8.openshift.api.model.ImageSourcePath item) {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.PathsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> setNewPathLike(int index,io.fabric8.openshift.api.model.ImageSourcePath item) {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.PathsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editPath(int index) {
        if (paths.size() <= index) throw new RuntimeException("Can't edit paths. Index exceeds size.");
        return setNewPathLike(index, buildPath(index));
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editFirstPath() {
        if (paths.size() == 0) throw new RuntimeException("Can't edit first paths. The list is empty.");
        return setNewPathLike(0, buildPath(0));
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editLastPath() {
        int index = paths.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last paths. The list is empty.");
        return setNewPathLike(index, buildPath(index));
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<A> editMatchingPath(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSourcePathBuilder> predicate) {
        int index = -1;
        for (int i=0;i<paths.size();i++) { 
        if (predicate.test(paths.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching paths. No match found.");
        return setNewPathLike(index, buildPath(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPullSecret instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildPullSecret() {
        return this.pullSecret!=null?this.pullSecret.build():null;
    }

    public A withPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
        _visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
    }

    public java.lang.Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public A withNewPullSecret(java.lang.String name) {
        return (A)withPullSecret(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> withNewPullSecret() {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.PullSecretNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.openshift.api.model.ImageSourceFluentImpl.PullSecretNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editPullSecret() {
        return withNewPullSecretLike(getPullSecret());
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret() {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageSourceFluentImpl that = (ImageSourceFluentImpl) o;
        if (as != null ? !as.equals(that.as) :that.as != null) return false;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
        if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(as,  from,  paths,  pullSecret,  super.hashCode());
    }

    public class FromNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<N>> implements io.fabric8.openshift.api.model.ImageSourceFluent.FromNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;

            FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
                        
            }

            FromNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ImageSourceFluentImpl.this.withFrom(builder.build());
            }

            public N endFrom() {
                return and();
            }
    }


    public class PathsNestedImpl<N> extends io.fabric8.openshift.api.model.ImageSourcePathFluentImpl<io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<N>> implements io.fabric8.openshift.api.model.ImageSourceFluent.PathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ImageSourcePathBuilder builder;
        private final int index;

            PathsNestedImpl(int index,io.fabric8.openshift.api.model.ImageSourcePath item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(this, item);
                        
            }

            PathsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.ImageSourcePathBuilder(this);
                        
            }

            public N and() {
                return (N) ImageSourceFluentImpl.this.setToPaths(index,builder.build());
            }

            public N endPath() {
                return and();
            }
    }


    public class PullSecretNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.ImageSourceFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            PullSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            PullSecretNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ImageSourceFluentImpl.this.withPullSecret(builder.build());
            }

            public N endPullSecret() {
                return and();
            }
    }


}
