package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class ImageStreamSpecFluentImpl<A extends io.fabric8.openshift.api.model.ImageStreamSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ImageStreamSpecFluent<A> {

    private java.lang.String dockerImageRepository;
    private io.fabric8.openshift.api.model.ImageLookupPolicyBuilder lookupPolicy;
    private java.util.List<io.fabric8.openshift.api.model.TagReferenceBuilder> tags =  new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>();

    public ImageStreamSpecFluentImpl() {
    }

    public ImageStreamSpecFluentImpl(io.fabric8.openshift.api.model.ImageStreamSpec instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository()); 
        this.withLookupPolicy(instance.getLookupPolicy()); 
        this.withTags(instance.getTags()); 
    }

    public java.lang.String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    public A withDockerImageRepository(java.lang.String dockerImageRepository) {
        this.dockerImageRepository=dockerImageRepository; return (A) this;
    }

    public java.lang.Boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDockerImageRepository instead.
     */
        public A withNewDockerImageRepository(java.lang.String arg0) {
        return (A)withDockerImageRepository(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLookupPolicy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ImageLookupPolicy getLookupPolicy() {
        return this.lookupPolicy!=null?this.lookupPolicy.build():null;
    }

    public io.fabric8.openshift.api.model.ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy!=null?this.lookupPolicy.build():null;
    }

    public A withLookupPolicy(io.fabric8.openshift.api.model.ImageLookupPolicy lookupPolicy) {
        _visitables.get("lookupPolicy").remove(this.lookupPolicy);
        if (lookupPolicy!=null){ this.lookupPolicy= new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder(lookupPolicy); _visitables.get("lookupPolicy").add(this.lookupPolicy);} return (A) this;
    }

    public java.lang.Boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    public A withNewLookupPolicy(java.lang.Boolean local) {
        return (A)withLookupPolicy(new ImageLookupPolicy(local));
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicy() {
        return new io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl.LookupPolicyNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicyLike(io.fabric8.openshift.api.model.ImageLookupPolicy item) {
        return new io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl.LookupPolicyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<A> editLookupPolicy() {
        return withNewLookupPolicyLike(getLookupPolicy());
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicy() {
        return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(io.fabric8.openshift.api.model.ImageLookupPolicy item) {
        return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): item);
    }

    public A addToTags(int index,io.fabric8.openshift.api.model.TagReference item) {
        if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>();}
        io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);_visitables.get("tags").add(index >= 0 ? index : _visitables.get("tags").size(), builder);this.tags.add(index >= 0 ? index : tags.size(), builder); return (A)this;
    }

    public A setToTags(int index,io.fabric8.openshift.api.model.TagReference item) {
        if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>();}
        io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("tags").size()) { _visitables.get("tags").add(builder); } else { _visitables.get("tags").set(index, builder);}
        if (index < 0 || index >= tags.size()) { tags.add(builder); } else { tags.set(index, builder);}
         return (A)this;
    }

    public A addToTags(io.fabric8.openshift.api.model.TagReference... items) {
        if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>();}
        for (io.fabric8.openshift.api.model.TagReference item : items) {io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
    }

    public A addAllToTags(java.util.Collection<io.fabric8.openshift.api.model.TagReference> items) {
        if (this.tags == null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>();}
        for (io.fabric8.openshift.api.model.TagReference item : items) {io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
    }

    public A removeFromTags(io.fabric8.openshift.api.model.TagReference... items) {
        for (io.fabric8.openshift.api.model.TagReference item : items) {io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
    }

    public A removeAllFromTags(java.util.Collection<io.fabric8.openshift.api.model.TagReference> items) {
        for (io.fabric8.openshift.api.model.TagReference item : items) {io.fabric8.openshift.api.model.TagReferenceBuilder builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTags(java.util.function.Predicate<io.fabric8.openshift.api.model.TagReferenceBuilder> predicate) {
        if (tags == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.TagReferenceBuilder> each = tags.iterator();
        final List visitables = _visitables.get("tags");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.TagReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTags instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.TagReference> getTags() {
        return build(tags);
    }

    public java.util.List<io.fabric8.openshift.api.model.TagReference> buildTags() {
        return build(tags);
    }

    public io.fabric8.openshift.api.model.TagReference buildTag(int index) {
        return this.tags.get(index).build();
    }

    public io.fabric8.openshift.api.model.TagReference buildFirstTag() {
        return this.tags.get(0).build();
    }

    public io.fabric8.openshift.api.model.TagReference buildLastTag() {
        return this.tags.get(tags.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.TagReference buildMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.TagReferenceBuilder> predicate) {
        for (io.fabric8.openshift.api.model.TagReferenceBuilder item: tags) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.TagReferenceBuilder> predicate) {
        for (io.fabric8.openshift.api.model.TagReferenceBuilder item: tags) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTags(java.util.List<io.fabric8.openshift.api.model.TagReference> tags) {
        if (this.tags != null) { _visitables.get("tags").removeAll(this.tags);}
        if (tags != null) {this.tags = new java.util.ArrayList<io.fabric8.openshift.api.model.TagReferenceBuilder>(); for (io.fabric8.openshift.api.model.TagReference item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
    }

    public A withTags(io.fabric8.openshift.api.model.TagReference... tags) {
        if (this.tags != null) {this.tags.clear();}
        if (tags != null) {for (io.fabric8.openshift.api.model.TagReference item :tags){ this.addToTags(item);}} return (A) this;
    }

    public java.lang.Boolean hasTags() {
        return tags != null && !tags.isEmpty();
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> addNewTag() {
        return new io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl.TagsNestedImpl();
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> addNewTagLike(io.fabric8.openshift.api.model.TagReference item) {
        return new io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl.TagsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> setNewTagLike(int index,io.fabric8.openshift.api.model.TagReference item) {
        return new io.fabric8.openshift.api.model.ImageStreamSpecFluentImpl.TagsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> editTag(int index) {
        if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
        return setNewTagLike(index, buildTag(index));
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> editFirstTag() {
        if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
        return setNewTagLike(0, buildTag(0));
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> editLastTag() {
        int index = tags.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
        return setNewTagLike(index, buildTag(index));
    }

    public io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<A> editMatchingTag(java.util.function.Predicate<io.fabric8.openshift.api.model.TagReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tags.size();i++) { 
        if (predicate.test(tags.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
        return setNewTagLike(index, buildTag(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl) o;
        if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
        if (lookupPolicy != null ? !lookupPolicy.equals(that.lookupPolicy) :that.lookupPolicy != null) return false;
        if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(dockerImageRepository,  lookupPolicy,  tags,  super.hashCode());
    }

    public class LookupPolicyNestedImpl<N> extends io.fabric8.openshift.api.model.ImageLookupPolicyFluentImpl<io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<N>> implements io.fabric8.openshift.api.model.ImageStreamSpecFluent.LookupPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ImageLookupPolicyBuilder builder;

            LookupPolicyNestedImpl(io.fabric8.openshift.api.model.ImageLookupPolicy item) {
                this.builder = new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder(this, item);
                        
            }

            LookupPolicyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ImageStreamSpecFluentImpl.this.withLookupPolicy(builder.build());
            }

            public N endLookupPolicy() {
                return and();
            }
    }


    public class TagsNestedImpl<N> extends io.fabric8.openshift.api.model.TagReferenceFluentImpl<io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<N>> implements io.fabric8.openshift.api.model.ImageStreamSpecFluent.TagsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TagReferenceBuilder builder;
        private final int index;

            TagsNestedImpl(int index,io.fabric8.openshift.api.model.TagReference item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(this, item);
                        
            }

            TagsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ImageStreamSpecFluentImpl.this.setToTags(index,builder.build());
            }

            public N endTag() {
                return and();
            }
    }


}
