package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NetNamespaceFluentImpl<A extends io.fabric8.openshift.api.model.NetNamespaceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.NetNamespaceFluent<A> {

    private java.lang.String apiVersion;
    private java.util.List<java.lang.String> egressIPs = new java.util.ArrayList<java.lang.String>();
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.lang.Integer netid;
    private java.lang.String netname;

    public NetNamespaceFluentImpl() {
    }

    public NetNamespaceFluentImpl(io.fabric8.openshift.api.model.NetNamespace instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withEgressIPs(instance.getEgressIPs()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withNetid(instance.getNetid()); 
        this.withNetname(instance.getNetname()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public A addToEgressIPs(int index,java.lang.String item) {
        if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
        this.egressIPs.add(index, item);
        return (A)this;
    }

    public A setToEgressIPs(int index,java.lang.String item) {
        if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
        this.egressIPs.set(index, item); return (A)this;
    }

    public A addToEgressIPs(java.lang.String... items) {
        if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
    }

    public A addAllToEgressIPs(java.util.Collection<java.lang.String> items) {
        if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
    }

    public A removeFromEgressIPs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
    }

    public A removeAllFromEgressIPs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getEgressIPs() {
        return this.egressIPs;
    }

    public java.lang.String getEgressIP(int index) {
        return this.egressIPs.get(index);
    }

    public java.lang.String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    public java.lang.String getLastEgressIP() {
        return this.egressIPs.get(egressIPs.size() - 1);
    }

    public java.lang.String getMatchingEgressIP(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingEgressIP(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEgressIPs(java.util.List<java.lang.String> egressIPs) {
        if (this.egressIPs != null) { _visitables.get("egressIPs").removeAll(this.egressIPs);}
        if (egressIPs != null) {this.egressIPs = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : egressIPs){this.addToEgressIPs(item);}} else { this.egressIPs = null;} return (A) this;
    }

    public A withEgressIPs(java.lang.String... egressIPs) {
        if (this.egressIPs != null) {this.egressIPs.clear();}
        if (egressIPs != null) {for (java.lang.String item :egressIPs){ this.addToEgressIPs(item);}} return (A) this;
    }

    public java.lang.Boolean hasEgressIPs() {
        return egressIPs != null && !egressIPs.isEmpty();
    }

    public A addNewEgressIP(java.lang.String arg0) {
        return (A)addToEgressIPs(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.NetNamespaceFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.NetNamespaceFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.Integer getNetid() {
        return this.netid;
    }

    public A withNetid(java.lang.Integer netid) {
        this.netid=netid; return (A) this;
    }

    public java.lang.Boolean hasNetid() {
        return this.netid != null;
    }

    public java.lang.String getNetname() {
        return this.netname;
    }

    public A withNetname(java.lang.String netname) {
        this.netname=netname; return (A) this;
    }

    public java.lang.Boolean hasNetname() {
        return this.netname != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNetname instead.
     */
        public A withNewNetname(java.lang.String arg0) {
        return (A)withNetname(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetNamespaceFluentImpl that = (NetNamespaceFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (egressIPs != null ? !egressIPs.equals(that.egressIPs) :that.egressIPs != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (netid != null ? !netid.equals(that.netid) :that.netid != null) return false;
        if (netname != null ? !netname.equals(that.netname) :that.netname != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  egressIPs,  kind,  metadata,  netid,  netname,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) NetNamespaceFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
