package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PlatformStatusBuilder extends io.fabric8.openshift.api.model.PlatformStatusFluentImpl<io.fabric8.openshift.api.model.PlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.PlatformStatus,io.fabric8.openshift.api.model.PlatformStatusBuilder> {

    io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PlatformStatusBuilder() {
        this(true);
    }

    public PlatformStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new PlatformStatus(), validationEnabled);
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PlatformStatus(), validationEnabled);
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PlatformStatus instance) {
        this(fluent, instance, true);
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAws(instance.getAws()); 
        fluent.withAzure(instance.getAzure()); 
        fluent.withBaremetal(instance.getBaremetal()); 
        fluent.withGcp(instance.getGcp()); 
        fluent.withIbmcloud(instance.getIbmcloud()); 
        fluent.withOpenstack(instance.getOpenstack()); 
        fluent.withOvirt(instance.getOvirt()); 
        fluent.withType(instance.getType()); 
        fluent.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatus instance) {
        this(instance,true);
    }

    public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAws(instance.getAws()); 
        this.withAzure(instance.getAzure()); 
        this.withBaremetal(instance.getBaremetal()); 
        this.withGcp(instance.getGcp()); 
        this.withIbmcloud(instance.getIbmcloud()); 
        this.withOpenstack(instance.getOpenstack()); 
        this.withOvirt(instance.getOvirt()); 
        this.withType(instance.getType()); 
        this.withVsphere(instance.getVsphere()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.PlatformStatus build() {
        PlatformStatus buildable = new PlatformStatus(fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getType(),fluent.getVsphere());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PlatformStatusBuilder that = (PlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
