package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteListBuilder extends io.fabric8.openshift.api.model.RouteListFluentImpl<io.fabric8.openshift.api.model.RouteListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.RouteList,io.fabric8.openshift.api.model.RouteListBuilder> {

    io.fabric8.openshift.api.model.RouteListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RouteListBuilder() {
        this(true);
    }

    public RouteListBuilder(java.lang.Boolean validationEnabled) {
        this(new RouteList(), validationEnabled);
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent) {
        this(fluent, true);
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RouteList(), validationEnabled);
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,io.fabric8.openshift.api.model.RouteList instance) {
        this(fluent, instance, true);
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,io.fabric8.openshift.api.model.RouteList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteList instance) {
        this(instance,true);
    }

    public RouteListBuilder(io.fabric8.openshift.api.model.RouteList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.RouteList build() {
        RouteList buildable = new RouteList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteListBuilder that = (RouteListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
