package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretNameReferenceBuilder extends io.fabric8.openshift.api.model.SecretNameReferenceFluentImpl<io.fabric8.openshift.api.model.SecretNameReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.SecretNameReference,io.fabric8.openshift.api.model.SecretNameReferenceBuilder> {

    io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SecretNameReferenceBuilder() {
        this(true);
    }

    public SecretNameReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new SecretNameReference(), validationEnabled);
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SecretNameReference(), validationEnabled);
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretNameReference instance) {
        this(fluent, instance, true);
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretNameReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReference instance) {
        this(instance,true);
    }

    public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.SecretNameReference build() {
        SecretNameReference buildable = new SecretNameReference(fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretNameReferenceBuilder that = (SecretNameReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
