package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class SecurityContextConstraintsFluentImpl<A extends io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent<A> {

    private java.lang.Boolean allowHostDirVolumePlugin;
    private java.lang.Boolean allowHostIPC;
    private java.lang.Boolean allowHostNetwork;
    private java.lang.Boolean allowHostPID;
    private java.lang.Boolean allowHostPorts;
    private java.lang.Boolean allowPrivilegeEscalation;
    private java.lang.Boolean allowPrivilegedContainer;
    private java.util.List<java.lang.String> allowedCapabilities = new java.util.ArrayList<java.lang.String>();
    private java.util.List<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> allowedFlexVolumes =  new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>();
    private java.util.List<java.lang.String> allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();
    private java.lang.String apiVersion;
    private java.util.List<java.lang.String> defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();
    private java.lang.Boolean defaultAllowPrivilegeEscalation;
    private java.util.List<java.lang.String> forbiddenSysctls = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder fsGroup;
    private java.util.List<java.lang.String> groups = new java.util.ArrayList<java.lang.String>();
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.lang.Integer priority;
    private java.lang.Boolean readOnlyRootFilesystem;
    private java.util.List<java.lang.String> requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder runAsUser;
    private io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder seLinuxContext;
    private java.util.List<java.lang.String> seccompProfiles = new java.util.ArrayList<java.lang.String>();
    private io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private java.util.List<java.lang.String> users = new java.util.ArrayList<java.lang.String>();
    private java.util.List<java.lang.String> volumes = new java.util.ArrayList<java.lang.String>();

    public SecurityContextConstraintsFluentImpl() {
    }

    public SecurityContextConstraintsFluentImpl(io.fabric8.openshift.api.model.SecurityContextConstraints instance) {
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
        this.withAllowHostIPC(instance.getAllowHostIPC()); 
        this.withAllowHostNetwork(instance.getAllowHostNetwork()); 
        this.withAllowHostPID(instance.getAllowHostPID()); 
        this.withAllowHostPorts(instance.getAllowHostPorts()); 
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
        this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
        this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
        this.withFsGroup(instance.getFsGroup()); 
        this.withGroups(instance.getGroups()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPriority(instance.getPriority()); 
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
        this.withRunAsUser(instance.getRunAsUser()); 
        this.withSeLinuxContext(instance.getSeLinuxContext()); 
        this.withSeccompProfiles(instance.getSeccompProfiles()); 
        this.withSupplementalGroups(instance.getSupplementalGroups()); 
        this.withUsers(instance.getUsers()); 
        this.withVolumes(instance.getVolumes()); 
    }

    public java.lang.Boolean getAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    public A withAllowHostDirVolumePlugin(java.lang.Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin=allowHostDirVolumePlugin; return (A) this;
    }

    public java.lang.Boolean hasAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin != null;
    }

    public java.lang.Boolean getAllowHostIPC() {
        return this.allowHostIPC;
    }

    public A withAllowHostIPC(java.lang.Boolean allowHostIPC) {
        this.allowHostIPC=allowHostIPC; return (A) this;
    }

    public java.lang.Boolean hasAllowHostIPC() {
        return this.allowHostIPC != null;
    }

    public java.lang.Boolean getAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    public A withAllowHostNetwork(java.lang.Boolean allowHostNetwork) {
        this.allowHostNetwork=allowHostNetwork; return (A) this;
    }

    public java.lang.Boolean hasAllowHostNetwork() {
        return this.allowHostNetwork != null;
    }

    public java.lang.Boolean getAllowHostPID() {
        return this.allowHostPID;
    }

    public A withAllowHostPID(java.lang.Boolean allowHostPID) {
        this.allowHostPID=allowHostPID; return (A) this;
    }

    public java.lang.Boolean hasAllowHostPID() {
        return this.allowHostPID != null;
    }

    public java.lang.Boolean getAllowHostPorts() {
        return this.allowHostPorts;
    }

    public A withAllowHostPorts(java.lang.Boolean allowHostPorts) {
        this.allowHostPorts=allowHostPorts; return (A) this;
    }

    public java.lang.Boolean hasAllowHostPorts() {
        return this.allowHostPorts != null;
    }

    public java.lang.Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(java.lang.Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
    }

    public java.lang.Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public java.lang.Boolean getAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    public A withAllowPrivilegedContainer(java.lang.Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer=allowPrivilegedContainer; return (A) this;
    }

    public java.lang.Boolean hasAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer != null;
    }

    public A addToAllowedCapabilities(int index,java.lang.String item) {
        if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    public A setToAllowedCapabilities(int index,java.lang.String item) {
        if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.allowedCapabilities.set(index, item); return (A)this;
    }

    public A addToAllowedCapabilities(java.lang.String... items) {
        if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A addAllToAllowedCapabilities(java.util.Collection<java.lang.String> items) {
        if (this.allowedCapabilities == null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A removeFromAllowedCapabilities(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedCapabilities(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public java.lang.String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    public java.lang.String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    public java.lang.String getLastAllowedCapability() {
        return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
    }

    public java.lang.String getMatchingAllowedCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedCapabilities) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedCapabilities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedCapabilities(java.util.List<java.lang.String> allowedCapabilities) {
        if (this.allowedCapabilities != null) { _visitables.get("allowedCapabilities").removeAll(this.allowedCapabilities);}
        if (allowedCapabilities != null) {this.allowedCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} else { this.allowedCapabilities = null;} return (A) this;
    }

    public A withAllowedCapabilities(java.lang.String... allowedCapabilities) {
        if (this.allowedCapabilities != null) {this.allowedCapabilities.clear();}
        if (allowedCapabilities != null) {for (java.lang.String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedCapabilities() {
        return allowedCapabilities != null && !allowedCapabilities.isEmpty();
    }

    public A addNewAllowedCapability(java.lang.String arg0) {
        return (A)addToAllowedCapabilities(new String(arg0));
    }

    public A addToAllowedFlexVolumes(int index,io.fabric8.openshift.api.model.AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>();}
        io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(index >= 0 ? index : _visitables.get("allowedFlexVolumes").size(), builder);this.allowedFlexVolumes.add(index >= 0 ? index : allowedFlexVolumes.size(), builder); return (A)this;
    }

    public A setToAllowedFlexVolumes(int index,io.fabric8.openshift.api.model.AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>();}
        io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("allowedFlexVolumes").size()) { _visitables.get("allowedFlexVolumes").add(builder); } else { _visitables.get("allowedFlexVolumes").set(index, builder);}
        if (index < 0 || index >= allowedFlexVolumes.size()) { allowedFlexVolumes.add(builder); } else { allowedFlexVolumes.set(index, builder);}
         return (A)this;
    }

    public A addToAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items) {
        if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>();}
        for (io.fabric8.openshift.api.model.AllowedFlexVolume item : items) {io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
    }

    public A addAllToAllowedFlexVolumes(java.util.Collection<io.fabric8.openshift.api.model.AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>();}
        for (io.fabric8.openshift.api.model.AllowedFlexVolume item : items) {io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
    }

    public A removeFromAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items) {
        for (io.fabric8.openshift.api.model.AllowedFlexVolume item : items) {io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromAllowedFlexVolumes(java.util.Collection<io.fabric8.openshift.api.model.AllowedFlexVolume> items) {
        for (io.fabric8.openshift.api.model.AllowedFlexVolume item : items) {io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAllowedFlexVolumes(java.util.function.Predicate<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> predicate) {
        if (allowedFlexVolumes == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> each = allowedFlexVolumes.iterator();
        final List visitables = _visitables.get("allowedFlexVolumes");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.AllowedFlexVolume> getAllowedFlexVolumes() {
        return build(allowedFlexVolumes);
    }

    public java.util.List<io.fabric8.openshift.api.model.AllowedFlexVolume> buildAllowedFlexVolumes() {
        return build(allowedFlexVolumes);
    }

    public io.fabric8.openshift.api.model.AllowedFlexVolume buildAllowedFlexVolume(int index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    public io.fabric8.openshift.api.model.AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    public io.fabric8.openshift.api.model.AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(allowedFlexVolumes.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.AllowedFlexVolume buildMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> predicate) {
        for (io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> predicate) {
        for (io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedFlexVolumes(java.util.List<io.fabric8.openshift.api.model.AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) { _visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);}
        if (allowedFlexVolumes != null) {this.allowedFlexVolumes = new java.util.ArrayList<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder>(); for (io.fabric8.openshift.api.model.AllowedFlexVolume item : allowedFlexVolumes){this.addToAllowedFlexVolumes(item);}} else { this.allowedFlexVolumes = null;} return (A) this;
    }

    public A withAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.clear();}
        if (allowedFlexVolumes != null) {for (io.fabric8.openshift.api.model.AllowedFlexVolume item :allowedFlexVolumes){ this.addToAllowedFlexVolumes(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedFlexVolumes() {
        return allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty();
    }

    public A addNewAllowedFlexVolume(java.lang.String driver) {
        return (A)addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(io.fabric8.openshift.api.model.AllowedFlexVolume item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,io.fabric8.openshift.api.model.AllowedFlexVolume item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index) {
        if (allowedFlexVolumes.size() <= index) throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (allowedFlexVolumes.size() == 0) throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        return setNewAllowedFlexVolumeLike(0, buildAllowedFlexVolume(0));
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = allowedFlexVolumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<allowedFlexVolumes.size();i++) { 
        if (predicate.test(allowedFlexVolumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
    }

    public A addToAllowedUnsafeSysctls(int index,java.lang.String item) {
        if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
        this.allowedUnsafeSysctls.add(index, item);
        return (A)this;
    }

    public A setToAllowedUnsafeSysctls(int index,java.lang.String item) {
        if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
        this.allowedUnsafeSysctls.set(index, item); return (A)this;
    }

    public A addToAllowedUnsafeSysctls(java.lang.String... items) {
        if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
    }

    public A addAllToAllowedUnsafeSysctls(java.util.Collection<java.lang.String> items) {
        if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
    }

    public A removeFromAllowedUnsafeSysctls(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedUnsafeSysctls(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    public java.lang.String getAllowedUnsafeSysctl(int index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    public java.lang.String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    public java.lang.String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(allowedUnsafeSysctls.size() - 1);
    }

    public java.lang.String getMatchingAllowedUnsafeSysctl(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAllowedUnsafeSysctl(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAllowedUnsafeSysctls(java.util.List<java.lang.String> allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) { _visitables.get("allowedUnsafeSysctls").removeAll(this.allowedUnsafeSysctls);}
        if (allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : allowedUnsafeSysctls){this.addToAllowedUnsafeSysctls(item);}} else { this.allowedUnsafeSysctls = null;} return (A) this;
    }

    public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls.clear();}
        if (allowedUnsafeSysctls != null) {for (java.lang.String item :allowedUnsafeSysctls){ this.addToAllowedUnsafeSysctls(item);}} return (A) this;
    }

    public java.lang.Boolean hasAllowedUnsafeSysctls() {
        return allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty();
    }

    public A addNewAllowedUnsafeSysctl(java.lang.String arg0) {
        return (A)addToAllowedUnsafeSysctls(new String(arg0));
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public A addToDefaultAddCapabilities(int index,java.lang.String item) {
        if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    public A setToDefaultAddCapabilities(int index,java.lang.String item) {
        if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.defaultAddCapabilities.set(index, item); return (A)this;
    }

    public A addToDefaultAddCapabilities(java.lang.String... items) {
        if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A addAllToDefaultAddCapabilities(java.util.Collection<java.lang.String> items) {
        if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A removeFromDefaultAddCapabilities(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultAddCapabilities(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    public java.lang.String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    public java.lang.String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    public java.lang.String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
    }

    public java.lang.String getMatchingDefaultAddCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: defaultAddCapabilities) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDefaultAddCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: defaultAddCapabilities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDefaultAddCapabilities(java.util.List<java.lang.String> defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) { _visitables.get("defaultAddCapabilities").removeAll(this.defaultAddCapabilities);}
        if (defaultAddCapabilities != null) {this.defaultAddCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} else { this.defaultAddCapabilities = null;} return (A) this;
    }

    public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {this.defaultAddCapabilities.clear();}
        if (defaultAddCapabilities != null) {for (java.lang.String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
    }

    public java.lang.Boolean hasDefaultAddCapabilities() {
        return defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty();
    }

    public A addNewDefaultAddCapability(java.lang.String arg0) {
        return (A)addToDefaultAddCapabilities(new String(arg0));
    }

    public java.lang.Boolean getDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    public A withDefaultAllowPrivilegeEscalation(java.lang.Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation=defaultAllowPrivilegeEscalation; return (A) this;
    }

    public java.lang.Boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    public A addToForbiddenSysctls(int index,java.lang.String item) {
        if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
        this.forbiddenSysctls.add(index, item);
        return (A)this;
    }

    public A setToForbiddenSysctls(int index,java.lang.String item) {
        if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
        this.forbiddenSysctls.set(index, item); return (A)this;
    }

    public A addToForbiddenSysctls(java.lang.String... items) {
        if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
    }

    public A addAllToForbiddenSysctls(java.util.Collection<java.lang.String> items) {
        if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
    }

    public A removeFromForbiddenSysctls(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
    }

    public A removeAllFromForbiddenSysctls(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    public java.lang.String getForbiddenSysctl(int index) {
        return this.forbiddenSysctls.get(index);
    }

    public java.lang.String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    public java.lang.String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(forbiddenSysctls.size() - 1);
    }

    public java.lang.String getMatchingForbiddenSysctl(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: forbiddenSysctls) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingForbiddenSysctl(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: forbiddenSysctls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withForbiddenSysctls(java.util.List<java.lang.String> forbiddenSysctls) {
        if (this.forbiddenSysctls != null) { _visitables.get("forbiddenSysctls").removeAll(this.forbiddenSysctls);}
        if (forbiddenSysctls != null) {this.forbiddenSysctls = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : forbiddenSysctls){this.addToForbiddenSysctls(item);}} else { this.forbiddenSysctls = null;} return (A) this;
    }

    public A withForbiddenSysctls(java.lang.String... forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {this.forbiddenSysctls.clear();}
        if (forbiddenSysctls != null) {for (java.lang.String item :forbiddenSysctls){ this.addToForbiddenSysctls(item);}} return (A) this;
    }

    public java.lang.Boolean hasForbiddenSysctls() {
        return forbiddenSysctls != null && !forbiddenSysctls.isEmpty();
    }

    public A addNewForbiddenSysctl(java.lang.String arg0) {
        return (A)addToForbiddenSysctls(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildFsGroup instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public io.fabric8.openshift.api.model.FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public A withFsGroup(io.fabric8.openshift.api.model.FSGroupStrategyOptions fsGroup) {
        _visitables.get("fsGroup").remove(this.fsGroup);
        if (fsGroup!=null){ this.fsGroup= new io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder(fsGroup); _visitables.get("fsGroup").add(this.fsGroup);} return (A) this;
    }

    public java.lang.Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.FsGroupNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(io.fabric8.openshift.api.model.FSGroupStrategyOptions item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.FsGroupNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup() {
        return withNewFsGroupLike(getFsGroup());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup() {
        return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(io.fabric8.openshift.api.model.FSGroupStrategyOptions item) {
        return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
    }

    public A addToGroups(int index,java.lang.String item) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index,java.lang.String item) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(java.lang.String... items) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(java.util.Collection<java.lang.String> items) {
        if (this.groups == null) {this.groups = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getGroups() {
        return this.groups;
    }

    public java.lang.String getGroup(int index) {
        return this.groups.get(index);
    }

    public java.lang.String getFirstGroup() {
        return this.groups.get(0);
    }

    public java.lang.String getLastGroup() {
        return this.groups.get(groups.size() - 1);
    }

    public java.lang.String getMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: groups) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingGroup(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(java.util.List<java.lang.String> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(java.lang.String... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (java.lang.String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public java.lang.Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(java.lang.String arg0) {
        return (A)addToGroups(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.Integer getPriority() {
        return this.priority;
    }

    public A withPriority(java.lang.Integer priority) {
        this.priority=priority; return (A) this;
    }

    public java.lang.Boolean hasPriority() {
        return this.priority != null;
    }

    public java.lang.Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(java.lang.Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public java.lang.Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    public A addToRequiredDropCapabilities(int index,java.lang.String item) {
        if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    public A setToRequiredDropCapabilities(int index,java.lang.String item) {
        if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
        this.requiredDropCapabilities.set(index, item); return (A)this;
    }

    public A addToRequiredDropCapabilities(java.lang.String... items) {
        if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A addAllToRequiredDropCapabilities(java.util.Collection<java.lang.String> items) {
        if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A removeFromRequiredDropCapabilities(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
    }

    public A removeAllFromRequiredDropCapabilities(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    public java.lang.String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    public java.lang.String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    public java.lang.String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
    }

    public java.lang.String getMatchingRequiredDropCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: requiredDropCapabilities) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingRequiredDropCapability(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: requiredDropCapabilities) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRequiredDropCapabilities(java.util.List<java.lang.String> requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) { _visitables.get("requiredDropCapabilities").removeAll(this.requiredDropCapabilities);}
        if (requiredDropCapabilities != null) {this.requiredDropCapabilities = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} else { this.requiredDropCapabilities = null;} return (A) this;
    }

    public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {this.requiredDropCapabilities.clear();}
        if (requiredDropCapabilities != null) {for (java.lang.String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
    }

    public java.lang.Boolean hasRequiredDropCapabilities() {
        return requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty();
    }

    public A addNewRequiredDropCapability(java.lang.String arg0) {
        return (A)addToRequiredDropCapabilities(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRunAsUser instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public io.fabric8.openshift.api.model.RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public A withRunAsUser(io.fabric8.openshift.api.model.RunAsUserStrategyOptions runAsUser) {
        _visitables.get("runAsUser").remove(this.runAsUser);
        if (runAsUser!=null){ this.runAsUser= new io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.get("runAsUser").add(this.runAsUser);} return (A) this;
    }

    public java.lang.Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public A withNewRunAsUser(java.lang.String type,java.lang.Long uid,java.lang.Long uidRangeMax,java.lang.Long uidRangeMin) {
        return (A)withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.RunAsUserNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(io.fabric8.openshift.api.model.RunAsUserStrategyOptions item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.RunAsUserNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser() {
        return withNewRunAsUserLike(getRunAsUser());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(io.fabric8.openshift.api.model.RunAsUserStrategyOptions item) {
        return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSeLinuxContext instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext!=null?this.seLinuxContext.build():null;
    }

    public io.fabric8.openshift.api.model.SELinuxContextStrategyOptions buildSeLinuxContext() {
        return this.seLinuxContext!=null?this.seLinuxContext.build():null;
    }

    public A withSeLinuxContext(io.fabric8.openshift.api.model.SELinuxContextStrategyOptions seLinuxContext) {
        _visitables.get("seLinuxContext").remove(this.seLinuxContext);
        if (seLinuxContext!=null){ this.seLinuxContext= new io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder(seLinuxContext); _visitables.get("seLinuxContext").add(this.seLinuxContext);} return (A) this;
    }

    public java.lang.Boolean hasSeLinuxContext() {
        return this.seLinuxContext != null;
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.SeLinuxContextNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(io.fabric8.openshift.api.model.SELinuxContextStrategyOptions item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.SeLinuxContextNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext() {
        return withNewSeLinuxContextLike(getSeLinuxContext());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext() {
        return withNewSeLinuxContextLike(getSeLinuxContext() != null ? getSeLinuxContext(): new io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(io.fabric8.openshift.api.model.SELinuxContextStrategyOptions item) {
        return withNewSeLinuxContextLike(getSeLinuxContext() != null ? getSeLinuxContext(): item);
    }

    public A addToSeccompProfiles(int index,java.lang.String item) {
        if (this.seccompProfiles == null) {this.seccompProfiles = new java.util.ArrayList<java.lang.String>();}
        this.seccompProfiles.add(index, item);
        return (A)this;
    }

    public A setToSeccompProfiles(int index,java.lang.String item) {
        if (this.seccompProfiles == null) {this.seccompProfiles = new java.util.ArrayList<java.lang.String>();}
        this.seccompProfiles.set(index, item); return (A)this;
    }

    public A addToSeccompProfiles(java.lang.String... items) {
        if (this.seccompProfiles == null) {this.seccompProfiles = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.seccompProfiles.add(item);} return (A)this;
    }

    public A addAllToSeccompProfiles(java.util.Collection<java.lang.String> items) {
        if (this.seccompProfiles == null) {this.seccompProfiles = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.seccompProfiles.add(item);} return (A)this;
    }

    public A removeFromSeccompProfiles(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.seccompProfiles!= null){ this.seccompProfiles.remove(item);}} return (A)this;
    }

    public A removeAllFromSeccompProfiles(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.seccompProfiles!= null){ this.seccompProfiles.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSeccompProfiles() {
        return this.seccompProfiles;
    }

    public java.lang.String getSeccompProfile(int index) {
        return this.seccompProfiles.get(index);
    }

    public java.lang.String getFirstSeccompProfile() {
        return this.seccompProfiles.get(0);
    }

    public java.lang.String getLastSeccompProfile() {
        return this.seccompProfiles.get(seccompProfiles.size() - 1);
    }

    public java.lang.String getMatchingSeccompProfile(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: seccompProfiles) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSeccompProfile(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: seccompProfiles) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSeccompProfiles(java.util.List<java.lang.String> seccompProfiles) {
        if (this.seccompProfiles != null) { _visitables.get("seccompProfiles").removeAll(this.seccompProfiles);}
        if (seccompProfiles != null) {this.seccompProfiles = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : seccompProfiles){this.addToSeccompProfiles(item);}} else { this.seccompProfiles = null;} return (A) this;
    }

    public A withSeccompProfiles(java.lang.String... seccompProfiles) {
        if (this.seccompProfiles != null) {this.seccompProfiles.clear();}
        if (seccompProfiles != null) {for (java.lang.String item :seccompProfiles){ this.addToSeccompProfiles(item);}} return (A) this;
    }

    public java.lang.Boolean hasSeccompProfiles() {
        return seccompProfiles != null && !seccompProfiles.isEmpty();
    }

    public A addNewSeccompProfile(java.lang.String arg0) {
        return (A)addToSeccompProfiles(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSupplementalGroups instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public A withSupplementalGroups(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions supplementalGroups) {
        _visitables.get("supplementalGroups").remove(this.supplementalGroups);
        if (supplementalGroups!=null){ this.supplementalGroups= new io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.get("supplementalGroups").add(this.supplementalGroups);} return (A) this;
    }

    public java.lang.Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.SupplementalGroupsNestedImpl();
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions item) {
        return new io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl.SupplementalGroupsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return withNewSupplementalGroupsLike(getSupplementalGroups());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder().build());
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions item) {
        return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
    }

    public A addToUsers(int index,java.lang.String item) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        this.users.add(index, item);
        return (A)this;
    }

    public A setToUsers(int index,java.lang.String item) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        this.users.set(index, item); return (A)this;
    }

    public A addToUsers(java.lang.String... items) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.users.add(item);} return (A)this;
    }

    public A addAllToUsers(java.util.Collection<java.lang.String> items) {
        if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.users.add(item);} return (A)this;
    }

    public A removeFromUsers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public A removeAllFromUsers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getUsers() {
        return this.users;
    }

    public java.lang.String getUser(int index) {
        return this.users.get(index);
    }

    public java.lang.String getFirstUser() {
        return this.users.get(0);
    }

    public java.lang.String getLastUser() {
        return this.users.get(users.size() - 1);
    }

    public java.lang.String getMatchingUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: users) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingUser(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: users) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUsers(java.util.List<java.lang.String> users) {
        if (this.users != null) { _visitables.get("users").removeAll(this.users);}
        if (users != null) {this.users = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
    }

    public A withUsers(java.lang.String... users) {
        if (this.users != null) {this.users.clear();}
        if (users != null) {for (java.lang.String item :users){ this.addToUsers(item);}} return (A) this;
    }

    public java.lang.Boolean hasUsers() {
        return users != null && !users.isEmpty();
    }

    public A addNewUser(java.lang.String arg0) {
        return (A)addToUsers(new String(arg0));
    }

    public A addToVolumes(int index,java.lang.String item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,java.lang.String item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(java.lang.String... items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(java.util.Collection<java.lang.String> items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getVolumes() {
        return this.volumes;
    }

    public java.lang.String getVolume(int index) {
        return this.volumes.get(index);
    }

    public java.lang.String getFirstVolume() {
        return this.volumes.get(0);
    }

    public java.lang.String getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public java.lang.String getMatchingVolume(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: volumes) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(java.util.List<java.lang.String> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(java.lang.String... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (java.lang.String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public A addNewVolume(java.lang.String arg0) {
        return (A)addToVolumes(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl) o;
        if (allowHostDirVolumePlugin != null ? !allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) :that.allowHostDirVolumePlugin != null) return false;
        if (allowHostIPC != null ? !allowHostIPC.equals(that.allowHostIPC) :that.allowHostIPC != null) return false;
        if (allowHostNetwork != null ? !allowHostNetwork.equals(that.allowHostNetwork) :that.allowHostNetwork != null) return false;
        if (allowHostPID != null ? !allowHostPID.equals(that.allowHostPID) :that.allowHostPID != null) return false;
        if (allowHostPorts != null ? !allowHostPorts.equals(that.allowHostPorts) :that.allowHostPorts != null) return false;
        if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
        if (allowPrivilegedContainer != null ? !allowPrivilegedContainer.equals(that.allowPrivilegedContainer) :that.allowPrivilegedContainer != null) return false;
        if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
        if (allowedFlexVolumes != null ? !allowedFlexVolumes.equals(that.allowedFlexVolumes) :that.allowedFlexVolumes != null) return false;
        if (allowedUnsafeSysctls != null ? !allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) :that.allowedUnsafeSysctls != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
        if (defaultAllowPrivilegeEscalation != null ? !defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) :that.defaultAllowPrivilegeEscalation != null) return false;
        if (forbiddenSysctls != null ? !forbiddenSysctls.equals(that.forbiddenSysctls) :that.forbiddenSysctls != null) return false;
        if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
        if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
        if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
        if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
        if (seLinuxContext != null ? !seLinuxContext.equals(that.seLinuxContext) :that.seLinuxContext != null) return false;
        if (seccompProfiles != null ? !seccompProfiles.equals(that.seccompProfiles) :that.seccompProfiles != null) return false;
        if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
        if (users != null ? !users.equals(that.users) :that.users != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowHostDirVolumePlugin,  allowHostIPC,  allowHostNetwork,  allowHostPID,  allowHostPorts,  allowPrivilegeEscalation,  allowPrivilegedContainer,  allowedCapabilities,  allowedFlexVolumes,  allowedUnsafeSysctls,  apiVersion,  defaultAddCapabilities,  defaultAllowPrivilegeEscalation,  forbiddenSysctls,  fsGroup,  groups,  kind,  metadata,  priority,  readOnlyRootFilesystem,  requiredDropCapabilities,  runAsUser,  seLinuxContext,  seccompProfiles,  supplementalGroups,  users,  volumes,  super.hashCode());
    }

    public class AllowedFlexVolumesNestedImpl<N> extends io.fabric8.openshift.api.model.AllowedFlexVolumeFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder builder;
        private final int index;

            AllowedFlexVolumesNestedImpl(int index,io.fabric8.openshift.api.model.AllowedFlexVolume item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(this, item);
                        
            }

            AllowedFlexVolumesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.AllowedFlexVolumeBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.setToAllowedFlexVolumes(index,builder.build());
            }

            public N endAllowedFlexVolume() {
                return and();
            }
    }


    public class FsGroupNestedImpl<N> extends io.fabric8.openshift.api.model.FSGroupStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.FsGroupNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder builder;

            FsGroupNestedImpl(io.fabric8.openshift.api.model.FSGroupStrategyOptions item) {
                this.builder = new io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder(this, item);
                        
            }

            FsGroupNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.FSGroupStrategyOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.withFsGroup(builder.build());
            }

            public N endFsGroup() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class RunAsUserNestedImpl<N> extends io.fabric8.openshift.api.model.RunAsUserStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.RunAsUserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder builder;

            RunAsUserNestedImpl(io.fabric8.openshift.api.model.RunAsUserStrategyOptions item) {
                this.builder = new io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder(this, item);
                        
            }

            RunAsUserNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.RunAsUserStrategyOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.withRunAsUser(builder.build());
            }

            public N endRunAsUser() {
                return and();
            }
    }


    public class SeLinuxContextNestedImpl<N> extends io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SeLinuxContextNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder builder;

            SeLinuxContextNestedImpl(io.fabric8.openshift.api.model.SELinuxContextStrategyOptions item) {
                this.builder = new io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder(this, item);
                        
            }

            SeLinuxContextNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.SELinuxContextStrategyOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(builder.build());
            }

            public N endSeLinuxContext() {
                return and();
            }
    }


    public class SupplementalGroupsNestedImpl<N> extends io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<N>> implements io.fabric8.openshift.api.model.SecurityContextConstraintsFluent.SupplementalGroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder builder;

            SupplementalGroupsNestedImpl(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions item) {
                this.builder = new io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder(this, item);
                        
            }

            SupplementalGroupsNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(builder.build());
            }

            public N endSupplementalGroups() {
                return and();
            }
    }


}
