package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecurityContextConstraintsListBuilder extends io.fabric8.openshift.api.model.SecurityContextConstraintsListFluentImpl<io.fabric8.openshift.api.model.SecurityContextConstraintsListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.SecurityContextConstraintsList,io.fabric8.openshift.api.model.SecurityContextConstraintsListBuilder> {

    io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SecurityContextConstraintsListBuilder() {
        this(true);
    }

    public SecurityContextConstraintsListBuilder(java.lang.Boolean validationEnabled) {
        this(new SecurityContextConstraintsList(), validationEnabled);
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent) {
        this(fluent, true);
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SecurityContextConstraintsList(), validationEnabled);
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraintsList instance) {
        this(fluent, instance, true);
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraintsList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsList instance) {
        this(instance,true);
    }

    public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.SecurityContextConstraintsList build() {
        SecurityContextConstraintsList buildable = new SecurityContextConstraintsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecurityContextConstraintsListBuilder that = (SecurityContextConstraintsListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
