package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TagReferenceBuilder extends io.fabric8.openshift.api.model.TagReferenceFluentImpl<io.fabric8.openshift.api.model.TagReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.TagReference,io.fabric8.openshift.api.model.TagReferenceBuilder> {

    io.fabric8.openshift.api.model.TagReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TagReferenceBuilder() {
        this(true);
    }

    public TagReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new TagReference(), validationEnabled);
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TagReference(), validationEnabled);
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.TagReference instance) {
        this(fluent, instance, true);
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.TagReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withFrom(instance.getFrom()); 
        fluent.withGeneration(instance.getGeneration()); 
        fluent.withImportPolicy(instance.getImportPolicy()); 
        fluent.withName(instance.getName()); 
        fluent.withReference(instance.getReference()); 
        fluent.withReferencePolicy(instance.getReferencePolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReference instance) {
        this(instance,true);
    }

    public TagReferenceBuilder(io.fabric8.openshift.api.model.TagReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withFrom(instance.getFrom()); 
        this.withGeneration(instance.getGeneration()); 
        this.withImportPolicy(instance.getImportPolicy()); 
        this.withName(instance.getName()); 
        this.withReference(instance.getReference()); 
        this.withReferencePolicy(instance.getReferencePolicy()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.TagReference build() {
        TagReference buildable = new TagReference(fluent.getAnnotations(),fluent.getFrom(),fluent.getGeneration(),fluent.getImportPolicy(),fluent.getName(),fluent.getReference(),fluent.getReferencePolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TagReferenceBuilder that = (TagReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
