package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VSpherePlatformStatusBuilder extends io.fabric8.openshift.api.model.VSpherePlatformStatusFluentImpl<io.fabric8.openshift.api.model.VSpherePlatformStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.VSpherePlatformStatus,io.fabric8.openshift.api.model.VSpherePlatformStatusBuilder> {

    io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public VSpherePlatformStatusBuilder() {
        this(true);
    }

    public VSpherePlatformStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new VSpherePlatformStatus(), validationEnabled);
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new VSpherePlatformStatus(), validationEnabled);
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.VSpherePlatformStatus instance) {
        this(fluent, instance, true);
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.VSpherePlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatus instance) {
        this(instance,true);
    }

    public VSpherePlatformStatusBuilder(io.fabric8.openshift.api.model.VSpherePlatformStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.VSpherePlatformStatus build() {
        VSpherePlatformStatus buildable = new VSpherePlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VSpherePlatformStatusBuilder that = (VSpherePlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
