package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class BuildStatusFluentImpl<A extends io.fabric8.openshift.api.model.BuildStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.BuildStatusFluent<A>{
  public BuildStatusFluentImpl() {
  }
  public BuildStatusFluentImpl(io.fabric8.openshift.api.model.BuildStatus instance) {
    this.withCancelled(instance.getCancelled()); 
    this.withCompletionTimestamp(instance.getCompletionTimestamp()); 
    this.withConditions(instance.getConditions()); 
    this.withConfig(instance.getConfig()); 
    this.withDuration(instance.getDuration()); 
    this.withLogSnippet(instance.getLogSnippet()); 
    this.withMessage(instance.getMessage()); 
    this.withOutput(instance.getOutput()); 
    this.withOutputDockerImageReference(instance.getOutputDockerImageReference()); 
    this.withPhase(instance.getPhase()); 
    this.withReason(instance.getReason()); 
    this.withStages(instance.getStages()); 
    this.withStartTimestamp(instance.getStartTimestamp()); 
  }
  private java.lang.Boolean cancelled;
  private java.lang.String completionTimestamp;
  private java.util.List<io.fabric8.openshift.api.model.BuildConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>();
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder config;
  private java.lang.Long duration;
  private java.lang.String logSnippet;
  private java.lang.String message;
  private io.fabric8.openshift.api.model.BuildStatusOutputBuilder output;
  private java.lang.String outputDockerImageReference;
  private java.lang.String phase;
  private java.lang.String reason;
  private java.util.List<io.fabric8.openshift.api.model.StageInfoBuilder> stages =  new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>();
  private java.lang.String startTimestamp;
  public java.lang.Boolean getCancelled() {
    return this.cancelled;
  }
  public A withCancelled(java.lang.Boolean cancelled) {
    this.cancelled=cancelled; return (A) this;
  }
  public java.lang.Boolean hasCancelled() {
    return this.cancelled != null;
  }
  public java.lang.String getCompletionTimestamp() {
    return this.completionTimestamp;
  }
  public A withCompletionTimestamp(java.lang.String completionTimestamp) {
    this.completionTimestamp=completionTimestamp; return (A) this;
  }
  public java.lang.Boolean hasCompletionTimestamp() {
    return this.completionTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withCompletionTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewCompletionTimestamp(java.lang.String arg0) {
    return (A)withCompletionTimestamp(new String(arg0));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.BuildCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>();}
    io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.BuildCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>();}
    io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.BuildCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>();}
    for (io.fabric8.openshift.api.model.BuildCondition item : items) {io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.BuildCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>();}
    for (io.fabric8.openshift.api.model.BuildCondition item : items) {io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.BuildCondition... items) {
    for (io.fabric8.openshift.api.model.BuildCondition item : items) {io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.BuildCondition> items) {
    for (io.fabric8.openshift.api.model.BuildCondition item : items) {io.fabric8.openshift.api.model.BuildConditionBuilder builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.BuildConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.BuildConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.BuildCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.BuildCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.BuildCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.BuildCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.BuildCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.BuildCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.BuildCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildConditionBuilder>(); for (io.fabric8.openshift.api.model.BuildCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.BuildCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.BuildCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.BuildCondition item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildCondition item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getConfig() {
    return this.config!=null?this.config.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildConfig() {
    return this.config!=null?this.config.build():null;
  }
  public A withConfig(io.fabric8.kubernetes.api.model.ObjectReference config) {
    _visitables.get("config").remove(this.config);
    if (config!=null){ this.config= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
  }
  public java.lang.Boolean hasConfig() {
    return this.config != null;
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> withNewConfig() {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.ConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> withNewConfigLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.ConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editConfig() {
    return withNewConfigLike(getConfig());
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editOrNewConfig() {
    return withNewConfigLike(getConfig() != null ? getConfig(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewConfigLike(getConfig() != null ? getConfig(): item);
  }
  public java.lang.Long getDuration() {
    return this.duration;
  }
  public A withDuration(java.lang.Long duration) {
    this.duration=duration; return (A) this;
  }
  public java.lang.Boolean hasDuration() {
    return this.duration != null;
  }
  public java.lang.String getLogSnippet() {
    return this.logSnippet;
  }
  public A withLogSnippet(java.lang.String logSnippet) {
    this.logSnippet=logSnippet; return (A) this;
  }
  public java.lang.Boolean hasLogSnippet() {
    return this.logSnippet != null;
  }
  
  /**
   * Method is deprecated. use withLogSnippet instead.
   */
  @java.lang.Deprecated
  public A withNewLogSnippet(java.lang.String arg0) {
    return (A)withLogSnippet(new String(arg0));
  }
  public java.lang.String getMessage() {
    return this.message;
  }
  public A withMessage(java.lang.String message) {
    this.message=message; return (A) this;
  }
  public java.lang.Boolean hasMessage() {
    return this.message != null;
  }
  
  /**
   * Method is deprecated. use withMessage instead.
   */
  @java.lang.Deprecated
  public A withNewMessage(java.lang.String arg0) {
    return (A)withMessage(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.BuildStatusOutput getOutput() {
    return this.output!=null?this.output.build():null;
  }
  public io.fabric8.openshift.api.model.BuildStatusOutput buildOutput() {
    return this.output!=null?this.output.build():null;
  }
  public A withOutput(io.fabric8.openshift.api.model.BuildStatusOutput output) {
    _visitables.get("output").remove(this.output);
    if (output!=null){ this.output= new io.fabric8.openshift.api.model.BuildStatusOutputBuilder(output); _visitables.get("output").add(this.output);} return (A) this;
  }
  public java.lang.Boolean hasOutput() {
    return this.output != null;
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> withNewOutput() {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.OutputNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> withNewOutputLike(io.fabric8.openshift.api.model.BuildStatusOutput item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.OutputNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOutput() {
    return withNewOutputLike(getOutput());
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOrNewOutput() {
    return withNewOutputLike(getOutput() != null ? getOutput(): new io.fabric8.openshift.api.model.BuildStatusOutputBuilder().build());
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<A> editOrNewOutputLike(io.fabric8.openshift.api.model.BuildStatusOutput item) {
    return withNewOutputLike(getOutput() != null ? getOutput(): item);
  }
  public java.lang.String getOutputDockerImageReference() {
    return this.outputDockerImageReference;
  }
  public A withOutputDockerImageReference(java.lang.String outputDockerImageReference) {
    this.outputDockerImageReference=outputDockerImageReference; return (A) this;
  }
  public java.lang.Boolean hasOutputDockerImageReference() {
    return this.outputDockerImageReference != null;
  }
  
  /**
   * Method is deprecated. use withOutputDockerImageReference instead.
   */
  @java.lang.Deprecated
  public A withNewOutputDockerImageReference(java.lang.String arg0) {
    return (A)withOutputDockerImageReference(new String(arg0));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  
  /**
   * Method is deprecated. use withPhase instead.
   */
  @java.lang.Deprecated
  public A withNewPhase(java.lang.String arg0) {
    return (A)withPhase(new String(arg0));
  }
  public java.lang.String getReason() {
    return this.reason;
  }
  public A withReason(java.lang.String reason) {
    this.reason=reason; return (A) this;
  }
  public java.lang.Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * Method is deprecated. use withReason instead.
   */
  @java.lang.Deprecated
  public A withNewReason(java.lang.String arg0) {
    return (A)withReason(new String(arg0));
  }
  public A addToStages(java.lang.Integer index,io.fabric8.openshift.api.model.StageInfo item) {
    if (this.stages == null) {this.stages = new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>();}
    io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);_visitables.get("stages").add(index >= 0 ? index : _visitables.get("stages").size(), builder);this.stages.add(index >= 0 ? index : stages.size(), builder); return (A)this;
  }
  public A setToStages(java.lang.Integer index,io.fabric8.openshift.api.model.StageInfo item) {
    if (this.stages == null) {this.stages = new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>();}
    io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);
    if (index < 0 || index >= _visitables.get("stages").size()) { _visitables.get("stages").add(builder); } else { _visitables.get("stages").set(index, builder);}
    if (index < 0 || index >= stages.size()) { stages.add(builder); } else { stages.set(index, builder);}
     return (A)this;
  }
  public A addToStages(io.fabric8.openshift.api.model.StageInfo... items) {
    if (this.stages == null) {this.stages = new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>();}
    for (io.fabric8.openshift.api.model.StageInfo item : items) {io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);_visitables.get("stages").add(builder);this.stages.add(builder);} return (A)this;
  }
  public A addAllToStages(java.util.Collection<io.fabric8.openshift.api.model.StageInfo> items) {
    if (this.stages == null) {this.stages = new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>();}
    for (io.fabric8.openshift.api.model.StageInfo item : items) {io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);_visitables.get("stages").add(builder);this.stages.add(builder);} return (A)this;
  }
  public A removeFromStages(io.fabric8.openshift.api.model.StageInfo... items) {
    for (io.fabric8.openshift.api.model.StageInfo item : items) {io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);_visitables.get("stages").remove(builder);if (this.stages != null) {this.stages.remove(builder);}} return (A)this;
  }
  public A removeAllFromStages(java.util.Collection<io.fabric8.openshift.api.model.StageInfo> items) {
    for (io.fabric8.openshift.api.model.StageInfo item : items) {io.fabric8.openshift.api.model.StageInfoBuilder builder = new io.fabric8.openshift.api.model.StageInfoBuilder(item);_visitables.get("stages").remove(builder);if (this.stages != null) {this.stages.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStages(java.util.function.Predicate<io.fabric8.openshift.api.model.StageInfoBuilder> predicate) {
    if (stages == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.StageInfoBuilder> each = stages.iterator();
    final List visitables = _visitables.get("stages");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.StageInfoBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStages instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.StageInfo> getStages() {
    return build(stages);
  }
  public java.util.List<io.fabric8.openshift.api.model.StageInfo> buildStages() {
    return build(stages);
  }
  public io.fabric8.openshift.api.model.StageInfo buildStage(java.lang.Integer index) {
    return this.stages.get(index).build();
  }
  public io.fabric8.openshift.api.model.StageInfo buildFirstStage() {
    return this.stages.get(0).build();
  }
  public io.fabric8.openshift.api.model.StageInfo buildLastStage() {
    return this.stages.get(stages.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.StageInfo buildMatchingStage(java.util.function.Predicate<io.fabric8.openshift.api.model.StageInfoBuilder> predicate) {
    for (io.fabric8.openshift.api.model.StageInfoBuilder item: stages) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingStage(java.util.function.Predicate<io.fabric8.openshift.api.model.StageInfoBuilder> predicate) {
    for (io.fabric8.openshift.api.model.StageInfoBuilder item: stages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStages(java.util.List<io.fabric8.openshift.api.model.StageInfo> stages) {
    if (this.stages != null) { _visitables.get("stages").removeAll(this.stages);}
    if (stages != null) {this.stages = new java.util.ArrayList<io.fabric8.openshift.api.model.StageInfoBuilder>(); for (io.fabric8.openshift.api.model.StageInfo item : stages){this.addToStages(item);}} else { this.stages = null;} return (A) this;
  }
  public A withStages(io.fabric8.openshift.api.model.StageInfo... stages) {
    if (this.stages != null) {this.stages.clear();}
    if (stages != null) {for (io.fabric8.openshift.api.model.StageInfo item :stages){ this.addToStages(item);}} return (A) this;
  }
  public java.lang.Boolean hasStages() {
    return stages != null && !stages.isEmpty();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> addNewStage() {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.StagesNestedImpl();
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> addNewStageLike(io.fabric8.openshift.api.model.StageInfo item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.StagesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> setNewStageLike(java.lang.Integer index,io.fabric8.openshift.api.model.StageInfo item) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentImpl.StagesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editStage(java.lang.Integer index) {
    if (stages.size() <= index) throw new RuntimeException("Can't edit stages. Index exceeds size.");
    return setNewStageLike(index, buildStage(index));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editFirstStage() {
    if (stages.size() == 0) throw new RuntimeException("Can't edit first stages. The list is empty.");
    return setNewStageLike(0, buildStage(0));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editLastStage() {
    int index = stages.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last stages. The list is empty.");
    return setNewStageLike(index, buildStage(index));
  }
  public io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<A> editMatchingStage(java.util.function.Predicate<io.fabric8.openshift.api.model.StageInfoBuilder> predicate) {
    int index = -1;
    for (int i=0;i<stages.size();i++) { 
    if (predicate.test(stages.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching stages. No match found.");
    return setNewStageLike(index, buildStage(index));
  }
  public java.lang.String getStartTimestamp() {
    return this.startTimestamp;
  }
  public A withStartTimestamp(java.lang.String startTimestamp) {
    this.startTimestamp=startTimestamp; return (A) this;
  }
  public java.lang.Boolean hasStartTimestamp() {
    return this.startTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withStartTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewStartTimestamp(java.lang.String arg0) {
    return (A)withStartTimestamp(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildStatusFluentImpl that = (BuildStatusFluentImpl) o;
    if (cancelled != null ? !cancelled.equals(that.cancelled) :that.cancelled != null) return false;
    if (completionTimestamp != null ? !completionTimestamp.equals(that.completionTimestamp) :that.completionTimestamp != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (config != null ? !config.equals(that.config) :that.config != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (logSnippet != null ? !logSnippet.equals(that.logSnippet) :that.logSnippet != null) return false;
    if (message != null ? !message.equals(that.message) :that.message != null) return false;
    if (output != null ? !output.equals(that.output) :that.output != null) return false;
    if (outputDockerImageReference != null ? !outputDockerImageReference.equals(that.outputDockerImageReference) :that.outputDockerImageReference != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (stages != null ? !stages.equals(that.stages) :that.stages != null) return false;
    if (startTimestamp != null ? !startTimestamp.equals(that.startTimestamp) :that.startTimestamp != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cancelled,  completionTimestamp,  conditions,  config,  duration,  logSnippet,  message,  output,  outputDockerImageReference,  phase,  reason,  stages,  startTimestamp,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.BuildConditionFluentImpl<io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.BuildStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.BuildCondition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ConfigNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<N>> implements io.fabric8.openshift.api.model.BuildStatusFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    ConfigNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) BuildStatusFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig() {
      return and();
    }
    
  }
  public class OutputNestedImpl<N> extends io.fabric8.openshift.api.model.BuildStatusOutputFluentImpl<io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<N>> implements io.fabric8.openshift.api.model.BuildStatusFluent.OutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OutputNestedImpl(io.fabric8.openshift.api.model.BuildStatusOutput item) {
      this.builder = new io.fabric8.openshift.api.model.BuildStatusOutputBuilder(this, item);
    }
    OutputNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildStatusOutputBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildStatusOutputBuilder builder;
    public N and() {
      return (N) BuildStatusFluentImpl.this.withOutput(builder.build());
    }
    public N endOutput() {
      return and();
    }
    
  }
  public class StagesNestedImpl<N> extends io.fabric8.openshift.api.model.StageInfoFluentImpl<io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<N>> implements io.fabric8.openshift.api.model.BuildStatusFluent.StagesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StagesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.StageInfo item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.StageInfoBuilder(this, item);
    }
    StagesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.StageInfoBuilder(this);
    }
    io.fabric8.openshift.api.model.StageInfoBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) BuildStatusFluentImpl.this.setToStages(index,builder.build());
    }
    public N endStage() {
      return and();
    }
    
  }
  
}