package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterNetworkBuilder extends io.fabric8.openshift.api.model.ClusterNetworkFluentImpl<io.fabric8.openshift.api.model.ClusterNetworkBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ClusterNetwork,io.fabric8.openshift.api.model.ClusterNetworkBuilder>{
  public ClusterNetworkBuilder() {
    this(false);
  }
  public ClusterNetworkBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterNetwork(), validationEnabled);
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetworkFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterNetwork(), validationEnabled);
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetworkFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetwork instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetworkFluent<?> fluent,io.fabric8.openshift.api.model.ClusterNetwork instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withClusterNetworks(instance.getClusterNetworks()); 
    fluent.withHostsubnetlength(instance.getHostsubnetlength()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withMtu(instance.getMtu()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withPluginName(instance.getPluginName()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    fluent.withVxlanPort(instance.getVxlanPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetwork instance) {
    this(instance,false);
  }
  public ClusterNetworkBuilder(io.fabric8.openshift.api.model.ClusterNetwork instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withClusterNetworks(instance.getClusterNetworks()); 
    this.withHostsubnetlength(instance.getHostsubnetlength()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withMtu(instance.getMtu()); 
    this.withNetwork(instance.getNetwork()); 
    this.withPluginName(instance.getPluginName()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withVxlanPort(instance.getVxlanPort()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ClusterNetworkFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ClusterNetwork build() {
    ClusterNetwork buildable = new ClusterNetwork(fluent.getApiVersion(),fluent.getClusterNetworks(),fluent.getHostsubnetlength(),fluent.getKind(),fluent.getMetadata(),fluent.getMtu(),fluent.getNetwork(),fluent.getPluginName(),fluent.getServiceNetwork(),fluent.getVxlanPort());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterNetworkBuilder that = (ClusterNetworkBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}