package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class ClusterRoleBindingFluentImpl<A extends io.fabric8.openshift.api.model.ClusterRoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.ClusterRoleBindingFluent<A>{
  public ClusterRoleBindingFluentImpl() {
  }
  public ClusterRoleBindingFluentImpl(io.fabric8.openshift.api.model.ClusterRoleBinding instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupNames(instance.getGroupNames()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withUserNames(instance.getUserNames()); 
  }
  private java.lang.String apiVersion;
  private java.util.List<java.lang.String> groupNames = new java.util.ArrayList<java.lang.String>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder roleRef;
  private java.util.List<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> subjects =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();
  private java.util.List<java.lang.String> userNames = new java.util.ArrayList<java.lang.String>();
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToGroupNames(java.lang.Integer index,java.lang.String item) {
    if (this.groupNames == null) {this.groupNames = new java.util.ArrayList<java.lang.String>();}
    this.groupNames.add(index, item);
    return (A)this;
  }
  public A setToGroupNames(java.lang.Integer index,java.lang.String item) {
    if (this.groupNames == null) {this.groupNames = new java.util.ArrayList<java.lang.String>();}
    this.groupNames.set(index, item); return (A)this;
  }
  public A addToGroupNames(java.lang.String... items) {
    if (this.groupNames == null) {this.groupNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.groupNames.add(item);} return (A)this;
  }
  public A addAllToGroupNames(java.util.Collection<java.lang.String> items) {
    if (this.groupNames == null) {this.groupNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.groupNames.add(item);} return (A)this;
  }
  public A removeFromGroupNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
  }
  public A removeAllFromGroupNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.groupNames!= null){ this.groupNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getGroupNames() {
    return this.groupNames;
  }
  public java.lang.String getGroupName(java.lang.Integer index) {
    return this.groupNames.get(index);
  }
  public java.lang.String getFirstGroupName() {
    return this.groupNames.get(0);
  }
  public java.lang.String getLastGroupName() {
    return this.groupNames.get(groupNames.size() - 1);
  }
  public java.lang.String getMatchingGroupName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: groupNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingGroupName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: groupNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroupNames(java.util.List<java.lang.String> groupNames) {
    if (groupNames != null) {this.groupNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : groupNames){this.addToGroupNames(item);}} else { this.groupNames = null;} return (A) this;
  }
  public A withGroupNames(java.lang.String... groupNames) {
    if (this.groupNames != null) {this.groupNames.clear();}
    if (groupNames != null) {for (java.lang.String item :groupNames){ this.addToGroupNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasGroupNames() {
    return groupNames != null && !groupNames.isEmpty();
  }
  public A addNewGroupName(java.lang.String arg0) {
    return (A)addToGroupNames(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRoleRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getRoleRef() {
    return this.roleRef!=null?this.roleRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildRoleRef() {
    return this.roleRef!=null?this.roleRef.build():null;
  }
  public A withRoleRef(io.fabric8.kubernetes.api.model.ObjectReference roleRef) {
    _visitables.get("roleRef").remove(this.roleRef);
    if (roleRef!=null){ this.roleRef= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} return (A) this;
  }
  public java.lang.Boolean hasRoleRef() {
    return this.roleRef != null;
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.RoleRefNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.RoleRefNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef() {
    return withNewRoleRefLike(getRoleRef());
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
  }
  public A addToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.ObjectReference item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
  }
  public A setToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.ObjectReference item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
    if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
     return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>();}
    for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items) {
    for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.ObjectReference> items) {
    for (io.fabric8.kubernetes.api.model.ObjectReference item : items) {io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> getSubjects() {
    return build(subjects);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> buildSubjects() {
    return build(subjects);
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildSubject(java.lang.Integer index) {
    return this.subjects.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ObjectReferenceBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(java.util.List<io.fabric8.kubernetes.api.model.ObjectReference> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
    if (subjects != null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder>(); for (io.fabric8.kubernetes.api.model.ObjectReference item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects) {
    if (this.subjects != null) {this.subjects.clear();}
    if (subjects != null) {for (io.fabric8.kubernetes.api.model.ObjectReference item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject() {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.SubjectsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl.SubjectsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> editSubject(java.lang.Integer index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public A addToUserNames(java.lang.Integer index,java.lang.String item) {
    if (this.userNames == null) {this.userNames = new java.util.ArrayList<java.lang.String>();}
    this.userNames.add(index, item);
    return (A)this;
  }
  public A setToUserNames(java.lang.Integer index,java.lang.String item) {
    if (this.userNames == null) {this.userNames = new java.util.ArrayList<java.lang.String>();}
    this.userNames.set(index, item); return (A)this;
  }
  public A addToUserNames(java.lang.String... items) {
    if (this.userNames == null) {this.userNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.userNames.add(item);} return (A)this;
  }
  public A addAllToUserNames(java.util.Collection<java.lang.String> items) {
    if (this.userNames == null) {this.userNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.userNames.add(item);} return (A)this;
  }
  public A removeFromUserNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
  }
  public A removeAllFromUserNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.userNames!= null){ this.userNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getUserNames() {
    return this.userNames;
  }
  public java.lang.String getUserName(java.lang.Integer index) {
    return this.userNames.get(index);
  }
  public java.lang.String getFirstUserName() {
    return this.userNames.get(0);
  }
  public java.lang.String getLastUserName() {
    return this.userNames.get(userNames.size() - 1);
  }
  public java.lang.String getMatchingUserName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: userNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingUserName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: userNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUserNames(java.util.List<java.lang.String> userNames) {
    if (userNames != null) {this.userNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : userNames){this.addToUserNames(item);}} else { this.userNames = null;} return (A) this;
  }
  public A withUserNames(java.lang.String... userNames) {
    if (this.userNames != null) {this.userNames.clear();}
    if (userNames != null) {for (java.lang.String item :userNames){ this.addToUserNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasUserNames() {
    return userNames != null && !userNames.isEmpty();
  }
  public A addNewUserName(java.lang.String arg0) {
    return (A)addToUserNames(new String(arg0));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
    if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
    if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  groupNames,  kind,  metadata,  roleRef,  subjects,  userNames,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ClusterRoleBindingFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class RoleRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<N>> implements io.fabric8.openshift.api.model.ClusterRoleBindingFluent.RoleRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleRefNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    RoleRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef() {
      return and();
    }
    
  }
  public class SubjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<N>> implements io.fabric8.openshift.api.model.ClusterRoleBindingFluent.SubjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SubjectsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ClusterRoleBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}