package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConsoleStatusBuilder extends io.fabric8.openshift.api.model.ConsoleStatusFluentImpl<io.fabric8.openshift.api.model.ConsoleStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ConsoleStatus,io.fabric8.openshift.api.model.ConsoleStatusBuilder>{
  public ConsoleStatusBuilder() {
    this(false);
  }
  public ConsoleStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleStatus instance) {
    this(fluent, instance, false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConsoleURL(instance.getConsoleURL()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatus instance) {
    this(instance,false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConsoleURL(instance.getConsoleURL()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleStatus build() {
    ConsoleStatus buildable = new ConsoleStatus(fluent.getConsoleURL());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleStatusBuilder that = (ConsoleStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}