package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageStreamImageBuilder extends io.fabric8.openshift.api.model.ImageStreamImageFluentImpl<io.fabric8.openshift.api.model.ImageStreamImageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamImage,io.fabric8.openshift.api.model.ImageStreamImageBuilder>{
  public ImageStreamImageBuilder() {
    this(false);
  }
  public ImageStreamImageBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImage instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImage instance) {
    this(instance,false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamImage build() {
    ImageStreamImage buildable = new ImageStreamImage(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamImageBuilder that = (ImageStreamImageBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}