package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageStreamMappingBuilder extends io.fabric8.openshift.api.model.ImageStreamMappingFluentImpl<io.fabric8.openshift.api.model.ImageStreamMappingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamMapping,io.fabric8.openshift.api.model.ImageStreamMappingBuilder>{
  public ImageStreamMappingBuilder() {
    this(false);
  }
  public ImageStreamMappingBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamMapping instance) {
    this(fluent, instance, false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTag(instance.getTag()); 
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMapping instance) {
    this(instance,false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTag(instance.getTag()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamMapping build() {
    ImageStreamMapping buildable = new ImageStreamMapping(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getTag());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamMappingBuilder that = (ImageStreamMappingBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}