package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class InfrastructureStatusBuilder extends io.fabric8.openshift.api.model.InfrastructureStatusFluentImpl<io.fabric8.openshift.api.model.InfrastructureStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.InfrastructureStatus,io.fabric8.openshift.api.model.InfrastructureStatusBuilder>{
  public InfrastructureStatusBuilder() {
    this(false);
  }
  public InfrastructureStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureStatus instance) {
    this(fluent, instance, false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalURI(instance.getApiServerInternalURI()); 
    fluent.withApiServerURL(instance.getApiServerURL()); 
    fluent.withControlPlaneTopology(instance.getControlPlaneTopology()); 
    fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    fluent.withInfrastructureName(instance.getInfrastructureName()); 
    fluent.withInfrastructureTopology(instance.getInfrastructureTopology()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withPlatformStatus(instance.getPlatformStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatus instance) {
    this(instance,false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalURI(instance.getApiServerInternalURI()); 
    this.withApiServerURL(instance.getApiServerURL()); 
    this.withControlPlaneTopology(instance.getControlPlaneTopology()); 
    this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    this.withInfrastructureName(instance.getInfrastructureName()); 
    this.withInfrastructureTopology(instance.getInfrastructureTopology()); 
    this.withPlatform(instance.getPlatform()); 
    this.withPlatformStatus(instance.getPlatformStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.InfrastructureStatus build() {
    InfrastructureStatus buildable = new InfrastructureStatus(fluent.getApiServerInternalURI(),fluent.getApiServerURL(),fluent.getControlPlaneTopology(),fluent.getEtcdDiscoveryDomain(),fluent.getInfrastructureName(),fluent.getInfrastructureTopology(),fluent.getPlatform(),fluent.getPlatformStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfrastructureStatusBuilder that = (InfrastructureStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}