package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class OpenIDClaimsBuilder extends io.fabric8.openshift.api.model.OpenIDClaimsFluentImpl<io.fabric8.openshift.api.model.OpenIDClaimsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.OpenIDClaims,io.fabric8.openshift.api.model.OpenIDClaimsBuilder>{
  public OpenIDClaimsBuilder() {
    this(false);
  }
  public OpenIDClaimsBuilder(java.lang.Boolean validationEnabled) {
    this(new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDClaims instance) {
    this(fluent, instance, false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDClaims instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEmail(instance.getEmail()); 
    fluent.withName(instance.getName()); 
    fluent.withPreferredUsername(instance.getPreferredUsername()); 
    this.validationEnabled = validationEnabled; 
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaims instance) {
    this(instance,false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaims instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEmail(instance.getEmail()); 
    this.withName(instance.getName()); 
    this.withPreferredUsername(instance.getPreferredUsername()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OpenIDClaims build() {
    OpenIDClaims buildable = new OpenIDClaims(fluent.getEmail(),fluent.getName(),fluent.getPreferredUsername());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenIDClaimsBuilder that = (OpenIDClaimsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}