package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageChangeCauseFluent<A extends ImageChangeCauseFluent<A>> extends BaseFluent<A>{
  public ImageChangeCauseFluent() {
  }
  
  public ImageChangeCauseFluent(ImageChangeCause instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder fromRef;
  private String imageID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageChangeCause instance) {
    instance = (instance != null ? instance : new ImageChangeCause());
    if (instance != null) {
          this.withFromRef(instance.getFromRef());
          this.withImageID(instance.getImageID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildFromRef() {
    return this.fromRef != null ? this.fromRef.build() : null;
  }
  
  public A withFromRef(ObjectReference fromRef) {
    this._visitables.remove("fromRef");
    if (fromRef != null) {
        this.fromRef = new ObjectReferenceBuilder(fromRef);
        this._visitables.get("fromRef").add(this.fromRef);
    } else {
        this.fromRef = null;
        this._visitables.get("fromRef").remove(this.fromRef);
    }
    return (A) this;
  }
  
  public boolean hasFromRef() {
    return this.fromRef != null;
  }
  
  public FromRefNested<A> withNewFromRef() {
    return new FromRefNested(null);
  }
  
  public FromRefNested<A> withNewFromRefLike(ObjectReference item) {
    return new FromRefNested(item);
  }
  
  public FromRefNested<A> editFromRef() {
    return withNewFromRefLike(java.util.Optional.ofNullable(buildFromRef()).orElse(null));
  }
  
  public FromRefNested<A> editOrNewFromRef() {
    return withNewFromRefLike(java.util.Optional.ofNullable(buildFromRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public FromRefNested<A> editOrNewFromRefLike(ObjectReference item) {
    return withNewFromRefLike(java.util.Optional.ofNullable(buildFromRef()).orElse(item));
  }
  
  public String getImageID() {
    return this.imageID;
  }
  
  public A withImageID(String imageID) {
    this.imageID = imageID;
    return (A) this;
  }
  
  public boolean hasImageID() {
    return this.imageID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageChangeCauseFluent that = (ImageChangeCauseFluent) o;
    if (!java.util.Objects.equals(fromRef, that.fromRef)) return false;
    if (!java.util.Objects.equals(imageID, that.imageID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fromRef,  imageID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fromRef != null) { sb.append("fromRef:"); sb.append(fromRef + ","); }
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FromRefNested<N> extends ObjectReferenceFluent<FromRefNested<N>> implements Nested<N>{
    FromRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ImageChangeCauseFluent.this.withFromRef(builder.build());
    }
    
    public N endFromRef() {
      return and();
    }
    
  
  }

}