package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceBuilder extends TemplateInstanceFluentImpl<TemplateInstanceBuilder> implements VisitableBuilder<TemplateInstance,TemplateInstanceBuilder>{
  public TemplateInstanceBuilder() {
    this(false);
  }
  public TemplateInstanceBuilder(Boolean validationEnabled) {
    this(new TemplateInstance(), validationEnabled);
  }
  public TemplateInstanceBuilder(TemplateInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceBuilder(TemplateInstanceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateInstance(), validationEnabled);
  }
  public TemplateInstanceBuilder(TemplateInstanceFluent<?> fluent,TemplateInstance instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceBuilder(TemplateInstanceFluent<?> fluent,TemplateInstance instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceBuilder(TemplateInstance instance) {
    this(instance,false);
  }
  public TemplateInstanceBuilder(TemplateInstance instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TemplateInstanceFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateInstance build() {
    TemplateInstance buildable = new TemplateInstance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}