package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RangeAllocationListBuilder extends RangeAllocationListFluentImpl<RangeAllocationListBuilder> implements VisitableBuilder<RangeAllocationList,RangeAllocationListBuilder>{
  public RangeAllocationListBuilder() {
    this(false);
  }
  public RangeAllocationListBuilder(Boolean validationEnabled) {
    this(new RangeAllocationList(), validationEnabled);
  }
  public RangeAllocationListBuilder(RangeAllocationListFluent<?> fluent) {
    this(fluent, false);
  }
  public RangeAllocationListBuilder(RangeAllocationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RangeAllocationList(), validationEnabled);
  }
  public RangeAllocationListBuilder(RangeAllocationListFluent<?> fluent,RangeAllocationList instance) {
    this(fluent, instance, false);
  }
  public RangeAllocationListBuilder(RangeAllocationListFluent<?> fluent,RangeAllocationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RangeAllocationListBuilder(RangeAllocationList instance) {
    this(instance,false);
  }
  public RangeAllocationListBuilder(RangeAllocationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RangeAllocationListFluent<?> fluent;
  Boolean validationEnabled;
  public RangeAllocationList build() {
    RangeAllocationList buildable = new RangeAllocationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}