package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceAccessReviewResponseBuilder extends ResourceAccessReviewResponseFluentImpl<ResourceAccessReviewResponseBuilder> implements VisitableBuilder<ResourceAccessReviewResponse,ResourceAccessReviewResponseBuilder>{
  public ResourceAccessReviewResponseBuilder() {
    this(false);
  }
  public ResourceAccessReviewResponseBuilder(Boolean validationEnabled) {
    this(new ResourceAccessReviewResponse(), validationEnabled);
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponseFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceAccessReviewResponse(), validationEnabled);
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponseFluent<?> fluent,ResourceAccessReviewResponse instance) {
    this(fluent, instance, false);
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponseFluent<?> fluent,ResourceAccessReviewResponse instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEvalutionError(instance.getEvalutionError()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withKind(instance.getKind()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withUsers(instance.getUsers()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponse instance) {
    this(instance,false);
  }
  public ResourceAccessReviewResponseBuilder(ResourceAccessReviewResponse instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEvalutionError(instance.getEvalutionError()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceAccessReviewResponseFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceAccessReviewResponse build() {
    ResourceAccessReviewResponse buildable = new ResourceAccessReviewResponse(fluent.getApiVersion(),fluent.getEvalutionError(),fluent.getGroups(),fluent.getKind(),fluent.getNamespace(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}