package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DeploymentConfigStatusFluentImpl<A extends DeploymentConfigStatusFluent<A>> extends BaseFluent<A> implements DeploymentConfigStatusFluent<A>{
  public DeploymentConfigStatusFluentImpl() {
  }
  public DeploymentConfigStatusFluentImpl(DeploymentConfigStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDetails(instance.getDetails()); 
    this.withLatestVersion(instance.getLatestVersion()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer availableReplicas;
  private ArrayList<DeploymentConditionBuilder> conditions = new ArrayList<DeploymentConditionBuilder>();
  private DeploymentDetailsBuilder details;
  private Long latestVersion;
  private Long observedGeneration;
  private Integer readyReplicas;
  private Integer replicas;
  private Integer unavailableReplicas;
  private Integer updatedReplicas;
  private Map<String,Object> additionalProperties;
  public Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(Integer index,DeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DeploymentConditionBuilder>();}
    DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,DeploymentCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DeploymentConditionBuilder>();}
    DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.DeploymentCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DeploymentConditionBuilder>();}
    for (DeploymentCondition item : items) {DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<DeploymentCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DeploymentConditionBuilder>();}
    for (DeploymentCondition item : items) {DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.DeploymentCondition... items) {
    for (DeploymentCondition item : items) {DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<DeploymentCondition> items) {
    for (DeploymentCondition item : items) {DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<DeploymentConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      DeploymentConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DeploymentCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<DeploymentCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public DeploymentCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public DeploymentCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public DeploymentCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
    for (DeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
    for (DeploymentConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<DeploymentCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (DeploymentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.DeploymentCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (DeploymentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition() {
    return new DeploymentConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(DeploymentCondition item) {
    return new DeploymentConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,DeploymentCondition item) {
    return new DeploymentConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeploymentDetails getDetails() {
    return this.details!=null ?this.details.build():null;
  }
  public DeploymentDetails buildDetails() {
    return this.details!=null ?this.details.build():null;
  }
  public A withDetails(DeploymentDetails details) {
    _visitables.get("details").remove(this.details);
    if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.get("details").add(this.details);} else { this.details = null; _visitables.get("details").remove(this.details); } return (A) this;
  }
  public Boolean hasDetails() {
    return this.details != null;
  }
  public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails() {
    return new DeploymentConfigStatusFluentImpl.DetailsNestedImpl();
  }
  public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item) {
    return new DeploymentConfigStatusFluentImpl.DetailsNestedImpl(item);
  }
  public DeploymentConfigStatusFluent.DetailsNested<A> editDetails() {
    return withNewDetailsLike(getDetails());
  }
  public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails() {
    return withNewDetailsLike(getDetails() != null ? getDetails(): new DeploymentDetailsBuilder().build());
  }
  public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item) {
    return withNewDetailsLike(getDetails() != null ? getDetails(): item);
  }
  public Long getLatestVersion() {
    return this.latestVersion;
  }
  public A withLatestVersion(Long latestVersion) {
    this.latestVersion=latestVersion; return (A) this;
  }
  public Boolean hasLatestVersion() {
    return this.latestVersion != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public Integer getUnavailableReplicas() {
    return this.unavailableReplicas;
  }
  public A withUnavailableReplicas(Integer unavailableReplicas) {
    this.unavailableReplicas=unavailableReplicas; return (A) this;
  }
  public Boolean hasUnavailableReplicas() {
    return this.unavailableReplicas != null;
  }
  public Integer getUpdatedReplicas() {
    return this.updatedReplicas;
  }
  public A withUpdatedReplicas(Integer updatedReplicas) {
    this.updatedReplicas=updatedReplicas; return (A) this;
  }
  public Boolean hasUpdatedReplicas() {
    return this.updatedReplicas != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeploymentConfigStatusFluentImpl that = (DeploymentConfigStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (latestVersion != null ? !latestVersion.equals(that.latestVersion) :that.latestVersion != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
    if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  details,  latestVersion,  observedGeneration,  readyReplicas,  replicas,  unavailableReplicas,  updatedReplicas,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableReplicas != null) { sb.append("availableReplicas:"); sb.append(availableReplicas + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (details != null) { sb.append("details:"); sb.append(details + ","); }
    if (latestVersion != null) { sb.append("latestVersion:"); sb.append(latestVersion + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (unavailableReplicas != null) { sb.append("unavailableReplicas:"); sb.append(unavailableReplicas + ","); }
    if (updatedReplicas != null) { sb.append("updatedReplicas:"); sb.append(updatedReplicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends DeploymentConditionFluentImpl<DeploymentConfigStatusFluent.ConditionsNested<N>> implements DeploymentConfigStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,DeploymentCondition item) {
      this.index = index;
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) DeploymentConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class DetailsNestedImpl<N> extends DeploymentDetailsFluentImpl<DeploymentConfigStatusFluent.DetailsNested<N>> implements DeploymentConfigStatusFluent.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.builder = new DeploymentDetailsBuilder(this);
    }
    DeploymentDetailsBuilder builder;
    public N and() {
      return (N) DeploymentConfigStatusFluentImpl.this.withDetails(builder.build());
    }
    public N endDetails() {
      return and();
    }
    
  }
  
}