package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JenkinsPipelineBuildStrategyFluentImpl<A extends JenkinsPipelineBuildStrategyFluent<A>> extends BaseFluent<A> implements JenkinsPipelineBuildStrategyFluent<A>{
  public JenkinsPipelineBuildStrategyFluentImpl() {
  }
  public JenkinsPipelineBuildStrategyFluentImpl(JenkinsPipelineBuildStrategy instance) {
    this.withEnv(instance.getEnv()); 
    this.withJenkinsfile(instance.getJenkinsfile()); 
    this.withJenkinsfilePath(instance.getJenkinsfilePath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private String jenkinsfile;
  private String jenkinsfilePath;
  private Map<String,Object> additionalProperties;
  public A addToEnv(Integer index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(Integer index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnv() {
    return this.env;
  }
  public EnvVar getEnv(Integer index) {
    return this.env.get(index);
  }
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public String getJenkinsfile() {
    return this.jenkinsfile;
  }
  public A withJenkinsfile(String jenkinsfile) {
    this.jenkinsfile=jenkinsfile; return (A) this;
  }
  public Boolean hasJenkinsfile() {
    return this.jenkinsfile != null;
  }
  public String getJenkinsfilePath() {
    return this.jenkinsfilePath;
  }
  public A withJenkinsfilePath(String jenkinsfilePath) {
    this.jenkinsfilePath=jenkinsfilePath; return (A) this;
  }
  public Boolean hasJenkinsfilePath() {
    return this.jenkinsfilePath != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JenkinsPipelineBuildStrategyFluentImpl that = (JenkinsPipelineBuildStrategyFluentImpl) o;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (jenkinsfile != null ? !jenkinsfile.equals(that.jenkinsfile) :that.jenkinsfile != null) return false;
    if (jenkinsfilePath != null ? !jenkinsfilePath.equals(that.jenkinsfilePath) :that.jenkinsfilePath != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(env,  jenkinsfile,  jenkinsfilePath,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (jenkinsfile != null) { sb.append("jenkinsfile:"); sb.append(jenkinsfile + ","); }
    if (jenkinsfilePath != null) { sb.append("jenkinsfilePath:"); sb.append(jenkinsfilePath + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}