package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IdentityFluent<A extends IdentityFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToExtra(String key,String value);
  public A addToExtra(Map<String,String> map);
  public A removeFromExtra(String key);
  public A removeFromExtra(Map<String,String> map);
  public Map<String,String> getExtra();
  public <K,V>A withExtra(Map<String,String> extra);
  public Boolean hasExtra();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public IdentityFluent.MetadataNested<A> withNewMetadata();
  public IdentityFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public IdentityFluent.MetadataNested<A> editMetadata();
  public IdentityFluent.MetadataNested<A> editOrNewMetadata();
  public IdentityFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public String getProviderName();
  public A withProviderName(String providerName);
  public Boolean hasProviderName();
  public String getProviderUserName();
  public A withProviderUserName(String providerUserName);
  public Boolean hasProviderUserName();
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getUser();
  public ObjectReference buildUser();
  public A withUser(ObjectReference user);
  public Boolean hasUser();
  public IdentityFluent.UserNested<A> withNewUser();
  public IdentityFluent.UserNested<A> withNewUserLike(ObjectReference item);
  public IdentityFluent.UserNested<A> editUser();
  public IdentityFluent.UserNested<A> editOrNewUser();
  public IdentityFluent.UserNested<A> editOrNewUserLike(ObjectReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<IdentityFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface UserNested<N> extends Nested<N>,ObjectReferenceFluent<IdentityFluent.UserNested<N>>{
    public N and();
    public N endUser();
    
  }
  
}