package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildVolumeMountBuilder extends BuildVolumeMountFluentImpl<BuildVolumeMountBuilder> implements VisitableBuilder<BuildVolumeMount,BuildVolumeMountBuilder>{
  public BuildVolumeMountBuilder() {
    this(false);
  }
  public BuildVolumeMountBuilder(Boolean validationEnabled) {
    this(new BuildVolumeMount(), validationEnabled);
  }
  public BuildVolumeMountBuilder(BuildVolumeMountFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeMountBuilder(BuildVolumeMountFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildVolumeMount(), validationEnabled);
  }
  public BuildVolumeMountBuilder(BuildVolumeMountFluent<?> fluent,BuildVolumeMount instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeMountBuilder(BuildVolumeMountFluent<?> fluent,BuildVolumeMount instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationPath(instance.getDestinationPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeMountBuilder(BuildVolumeMount instance) {
    this(instance,false);
  }
  public BuildVolumeMountBuilder(BuildVolumeMount instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationPath(instance.getDestinationPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BuildVolumeMountFluent<?> fluent;
  Boolean validationEnabled;
  public BuildVolumeMount build() {
    BuildVolumeMount buildable = new BuildVolumeMount(fluent.getDestinationPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}