package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface BrokerTemplateInstanceSpecFluent<A extends BrokerTemplateInstanceSpecFluent<A>> extends Fluent<A>{
  public A addToBindingIDs(Integer index,String item);
  public A setToBindingIDs(Integer index,String item);
  public A addToBindingIDs(java.lang.String... items);
  public A addAllToBindingIDs(Collection<String> items);
  public A removeFromBindingIDs(java.lang.String... items);
  public A removeAllFromBindingIDs(Collection<String> items);
  public List<String> getBindingIDs();
  public String getBindingID(Integer index);
  public String getFirstBindingID();
  public String getLastBindingID();
  public String getMatchingBindingID(Predicate<String> predicate);
  public Boolean hasMatchingBindingID(Predicate<String> predicate);
  public A withBindingIDs(List<String> bindingIDs);
  public A withBindingIDs(java.lang.String... bindingIDs);
  public Boolean hasBindingIDs();
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getSecret();
  public ObjectReference buildSecret();
  public A withSecret(ObjectReference secret);
  public Boolean hasSecret();
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecret();
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> withNewSecretLike(ObjectReference item);
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editSecret();
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecret();
  public BrokerTemplateInstanceSpecFluent.SecretNested<A> editOrNewSecretLike(ObjectReference item);
  
  /**
   * This method has been deprecated, please use method buildTemplateInstance instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getTemplateInstance();
  public ObjectReference buildTemplateInstance();
  public A withTemplateInstance(ObjectReference templateInstance);
  public Boolean hasTemplateInstance();
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstance();
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> withNewTemplateInstanceLike(ObjectReference item);
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editTemplateInstance();
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstance();
  public BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<A> editOrNewTemplateInstanceLike(ObjectReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface SecretNested<N> extends Nested<N>,ObjectReferenceFluent<BrokerTemplateInstanceSpecFluent.SecretNested<N>>{
    public N and();
    public N endSecret();
    
  }
  public interface TemplateInstanceNested<N> extends Nested<N>,ObjectReferenceFluent<BrokerTemplateInstanceSpecFluent.TemplateInstanceNested<N>>{
    public N and();
    public N endTemplateInstance();
    
  }
  
}