package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeTriggerBuilder extends ImageChangeTriggerFluentImpl<ImageChangeTriggerBuilder> implements VisitableBuilder<ImageChangeTrigger,ImageChangeTriggerBuilder>{
  public ImageChangeTriggerBuilder() {
    this(false);
  }
  public ImageChangeTriggerBuilder(Boolean validationEnabled) {
    this(new ImageChangeTrigger(), validationEnabled);
  }
  public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageChangeTrigger(), validationEnabled);
  }
  public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,ImageChangeTrigger instance) {
    this(fluent, instance, false);
  }
  public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent,ImageChangeTrigger instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeTriggerBuilder(ImageChangeTrigger instance) {
    this(instance,false);
  }
  public ImageChangeTriggerBuilder(ImageChangeTrigger instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
    this.withPaused(instance.getPaused()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageChangeTriggerFluent<?> fluent;
  Boolean validationEnabled;
  public ImageChangeTrigger build() {
    ImageChangeTrigger buildable = new ImageChangeTrigger(fluent.getFrom(),fluent.getLastTriggeredImageID(),fluent.getPaused());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}