package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityPolicyReviewSpecFluentImpl<A extends PodSecurityPolicyReviewSpecFluent<A>> extends BaseFluent<A> implements PodSecurityPolicyReviewSpecFluent<A>{
  public PodSecurityPolicyReviewSpecFluentImpl() {
  }
  public PodSecurityPolicyReviewSpecFluentImpl(PodSecurityPolicyReviewSpec instance) {
    this.withServiceAccountNames(instance.getServiceAccountNames()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> serviceAccountNames = new ArrayList<String>();
  private PodTemplateSpecBuilder template;
  private Map<String,Object> additionalProperties;
  public A addToServiceAccountNames(Integer index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.add(index, item);
    return (A)this;
  }
  public A setToServiceAccountNames(Integer index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.set(index, item); return (A)this;
  }
  public A addToServiceAccountNames(java.lang.String... items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  public A addAllToServiceAccountNames(Collection<String> items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  public A removeFromServiceAccountNames(java.lang.String... items) {
    for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceAccountNames(Collection<String> items) {
    for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
  }
  public List<String> getServiceAccountNames() {
    return this.serviceAccountNames;
  }
  public String getServiceAccountName(Integer index) {
    return this.serviceAccountNames.get(index);
  }
  public String getFirstServiceAccountName() {
    return this.serviceAccountNames.get(0);
  }
  public String getLastServiceAccountName() {
    return this.serviceAccountNames.get(serviceAccountNames.size() - 1);
  }
  public String getMatchingServiceAccountName(Predicate<String> predicate) {
    for (String item: serviceAccountNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
    for (String item: serviceAccountNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceAccountNames(List<String> serviceAccountNames) {
    if (serviceAccountNames != null) {this.serviceAccountNames = new ArrayList(); for (String item : serviceAccountNames){this.addToServiceAccountNames(item);}} else { this.serviceAccountNames = null;} return (A) this;
  }
  public A withServiceAccountNames(java.lang.String... serviceAccountNames) {
    if (this.serviceAccountNames != null) {this.serviceAccountNames.clear();}
    if (serviceAccountNames != null) {for (String item :serviceAccountNames){ this.addToServiceAccountNames(item);}} return (A) this;
  }
  public Boolean hasServiceAccountNames() {
    return serviceAccountNames != null && !serviceAccountNames.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplate() {
    return new PodSecurityPolicyReviewSpecFluentImpl.TemplateNestedImpl();
  }
  public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new PodSecurityPolicyReviewSpecFluentImpl.TemplateNestedImpl(item);
  }
  public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
  }
  public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSecurityPolicyReviewSpecFluentImpl that = (PodSecurityPolicyReviewSpecFluentImpl) o;
    if (serviceAccountNames != null ? !serviceAccountNames.equals(that.serviceAccountNames) :that.serviceAccountNames != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(serviceAccountNames,  template,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (serviceAccountNames != null && !serviceAccountNames.isEmpty()) { sb.append("serviceAccountNames:"); sb.append(serviceAccountNames + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<PodSecurityPolicyReviewSpecFluent.TemplateNested<N>> implements PodSecurityPolicyReviewSpecFluent.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) PodSecurityPolicyReviewSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}