package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterNetworkFluent<A extends ClusterNetworkFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToClusterNetworks(Integer index,ClusterNetworkEntry item);
  public A setToClusterNetworks(Integer index,ClusterNetworkEntry item);
  public A addToClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items);
  public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items);
  public A removeFromClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items);
  public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetworks();
  public List<ClusterNetworkEntry> buildClusterNetworks();
  public ClusterNetworkEntry buildClusterNetwork(Integer index);
  public ClusterNetworkEntry buildFirstClusterNetwork();
  public ClusterNetworkEntry buildLastClusterNetwork();
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks);
  public A withClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... clusterNetworks);
  public Boolean hasClusterNetworks();
  public A addNewClusterNetwork(String cidr,Integer hostSubnetLength);
  public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork();
  public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
  public ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item);
  public ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(Integer index);
  public ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork();
  public ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork();
  public ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Integer getHostsubnetlength();
  public A withHostsubnetlength(Integer hostsubnetlength);
  public Boolean hasHostsubnetlength();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ClusterNetworkFluent.MetadataNested<A> withNewMetadata();
  public ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ClusterNetworkFluent.MetadataNested<A> editMetadata();
  public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata();
  public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public Integer getMtu();
  public A withMtu(Integer mtu);
  public Boolean hasMtu();
  public String getNetwork();
  public A withNetwork(String network);
  public Boolean hasNetwork();
  public String getPluginName();
  public A withPluginName(String pluginName);
  public Boolean hasPluginName();
  public String getServiceNetwork();
  public A withServiceNetwork(String serviceNetwork);
  public Boolean hasServiceNetwork();
  public Integer getVxlanPort();
  public A withVxlanPort(Integer vxlanPort);
  public Boolean hasVxlanPort();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClusterNetworksNested<N> extends Nested<N>,ClusterNetworkEntryFluent<ClusterNetworkFluent.ClusterNetworksNested<N>>{
    public N and();
    public N endClusterNetwork();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterNetworkFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}