package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionConfigBuilder extends ConnectionConfigFluentImpl<ConnectionConfigBuilder> implements VisitableBuilder<ConnectionConfig,ConnectionConfigBuilder>{
  public ConnectionConfigBuilder() {
    this(false);
  }
  public ConnectionConfigBuilder(Boolean validationEnabled) {
    this(new ConnectionConfig(), validationEnabled);
  }
  public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectionConfig(), validationEnabled);
  }
  public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent,ConnectionConfig instance) {
    this(fluent, instance, false);
  }
  public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent,ConnectionConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withTlsClientConfig(instance.getTlsClientConfig()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConnectionConfigBuilder(ConnectionConfig instance) {
    this(instance,false);
  }
  public ConnectionConfigBuilder(ConnectionConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withTlsClientConfig(instance.getTlsClientConfig()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConnectionConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectionConfig build() {
    ConnectionConfig buildable = new ConnectionConfig(fluent.getCa(),fluent.getTlsClientConfig(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}