package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageStreamSpecFluent<A extends ImageStreamSpecFluent<A>> extends Fluent<A>{
  public String getDockerImageRepository();
  public A withDockerImageRepository(String dockerImageRepository);
  public Boolean hasDockerImageRepository();
  
  /**
   * This method has been deprecated, please use method buildLookupPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageLookupPolicy getLookupPolicy();
  public ImageLookupPolicy buildLookupPolicy();
  public A withLookupPolicy(ImageLookupPolicy lookupPolicy);
  public Boolean hasLookupPolicy();
  public A withNewLookupPolicy(Boolean local);
  public ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicy();
  public ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item);
  public ImageStreamSpecFluent.LookupPolicyNested<A> editLookupPolicy();
  public ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicy();
  public ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item);
  public A addToTags(Integer index,TagReference item);
  public A setToTags(Integer index,TagReference item);
  public A addToTags(io.fabric8.openshift.api.model.TagReference... items);
  public A addAllToTags(Collection<TagReference> items);
  public A removeFromTags(io.fabric8.openshift.api.model.TagReference... items);
  public A removeAllFromTags(Collection<TagReference> items);
  public A removeMatchingFromTags(Predicate<TagReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TagReference> getTags();
  public List<TagReference> buildTags();
  public TagReference buildTag(Integer index);
  public TagReference buildFirstTag();
  public TagReference buildLastTag();
  public TagReference buildMatchingTag(Predicate<TagReferenceBuilder> predicate);
  public Boolean hasMatchingTag(Predicate<TagReferenceBuilder> predicate);
  public A withTags(List<TagReference> tags);
  public A withTags(io.fabric8.openshift.api.model.TagReference... tags);
  public Boolean hasTags();
  public ImageStreamSpecFluent.TagsNested<A> addNewTag();
  public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item);
  public ImageStreamSpecFluent.TagsNested<A> setNewTagLike(Integer index,TagReference item);
  public ImageStreamSpecFluent.TagsNested<A> editTag(Integer index);
  public ImageStreamSpecFluent.TagsNested<A> editFirstTag();
  public ImageStreamSpecFluent.TagsNested<A> editLastTag();
  public ImageStreamSpecFluent.TagsNested<A> editMatchingTag(Predicate<TagReferenceBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface LookupPolicyNested<N> extends Nested<N>,ImageLookupPolicyFluent<ImageStreamSpecFluent.LookupPolicyNested<N>>{
    public N and();
    public N endLookupPolicy();
    
  }
  public interface TagsNested<N> extends Nested<N>,TagReferenceFluent<ImageStreamSpecFluent.TagsNested<N>>{
    public N and();
    public N endTag();
    
  }
  
}