package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteStatusBuilder extends RouteStatusFluentImpl<RouteStatusBuilder> implements VisitableBuilder<RouteStatus,RouteStatusBuilder>{
  public RouteStatusBuilder() {
    this(false);
  }
  public RouteStatusBuilder(Boolean validationEnabled) {
    this(new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance) {
    this(fluent, instance, false);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIngress(instance.getIngress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteStatusBuilder(RouteStatus instance) {
    this(instance,false);
  }
  public RouteStatusBuilder(RouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RouteStatus build() {
    RouteStatus buildable = new RouteStatus(fluent.getIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}