package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecurityContextConstraintsFluentImpl<A extends SecurityContextConstraintsFluent<A>> extends BaseFluent<A> implements SecurityContextConstraintsFluent<A>{
  public SecurityContextConstraintsFluentImpl() {
  }
  public SecurityContextConstraintsFluentImpl(SecurityContextConstraints instance) {
    this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); 
    this.withAllowHostIPC(instance.getAllowHostIPC()); 
    this.withAllowHostNetwork(instance.getAllowHostNetwork()); 
    this.withAllowHostPID(instance.getAllowHostPID()); 
    this.withAllowHostPorts(instance.getAllowHostPorts()); 
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); 
    this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    this.withFsGroup(instance.getFsGroup()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withPriority(instance.getPriority()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxContext(instance.getSeLinuxContext()); 
    this.withSeccompProfiles(instance.getSeccompProfiles()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withUsers(instance.getUsers()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean allowHostDirVolumePlugin;
  private Boolean allowHostIPC;
  private Boolean allowHostNetwork;
  private Boolean allowHostPID;
  private Boolean allowHostPorts;
  private Boolean allowPrivilegeEscalation;
  private Boolean allowPrivilegedContainer;
  private List<String> allowedCapabilities = new ArrayList<String>();
  private ArrayList<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
  private List<String> allowedUnsafeSysctls = new ArrayList<String>();
  private String apiVersion;
  private List<String> defaultAddCapabilities = new ArrayList<String>();
  private Boolean defaultAllowPrivilegeEscalation;
  private List<String> forbiddenSysctls = new ArrayList<String>();
  private FSGroupStrategyOptionsBuilder fsGroup;
  private List<String> groups = new ArrayList<String>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private Integer priority;
  private Boolean readOnlyRootFilesystem;
  private List<String> requiredDropCapabilities = new ArrayList<String>();
  private RunAsUserStrategyOptionsBuilder runAsUser;
  private SELinuxContextStrategyOptionsBuilder seLinuxContext;
  private List<String> seccompProfiles = new ArrayList<String>();
  private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
  private List<String> users = new ArrayList<String>();
  private List<String> volumes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public Boolean getAllowHostDirVolumePlugin() {
    return this.allowHostDirVolumePlugin;
  }
  public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
    this.allowHostDirVolumePlugin=allowHostDirVolumePlugin; return (A) this;
  }
  public Boolean hasAllowHostDirVolumePlugin() {
    return this.allowHostDirVolumePlugin != null;
  }
  public Boolean getAllowHostIPC() {
    return this.allowHostIPC;
  }
  public A withAllowHostIPC(Boolean allowHostIPC) {
    this.allowHostIPC=allowHostIPC; return (A) this;
  }
  public Boolean hasAllowHostIPC() {
    return this.allowHostIPC != null;
  }
  public Boolean getAllowHostNetwork() {
    return this.allowHostNetwork;
  }
  public A withAllowHostNetwork(Boolean allowHostNetwork) {
    this.allowHostNetwork=allowHostNetwork; return (A) this;
  }
  public Boolean hasAllowHostNetwork() {
    return this.allowHostNetwork != null;
  }
  public Boolean getAllowHostPID() {
    return this.allowHostPID;
  }
  public A withAllowHostPID(Boolean allowHostPID) {
    this.allowHostPID=allowHostPID; return (A) this;
  }
  public Boolean hasAllowHostPID() {
    return this.allowHostPID != null;
  }
  public Boolean getAllowHostPorts() {
    return this.allowHostPorts;
  }
  public A withAllowHostPorts(Boolean allowHostPorts) {
    this.allowHostPorts=allowHostPorts; return (A) this;
  }
  public Boolean hasAllowHostPorts() {
    return this.allowHostPorts != null;
  }
  public Boolean getAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation;
  }
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
    this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
  }
  public Boolean hasAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation != null;
  }
  public Boolean getAllowPrivilegedContainer() {
    return this.allowPrivilegedContainer;
  }
  public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
    this.allowPrivilegedContainer=allowPrivilegedContainer; return (A) this;
  }
  public Boolean hasAllowPrivilegedContainer() {
    return this.allowPrivilegedContainer != null;
  }
  public A addToAllowedCapabilities(Integer index,String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    this.allowedCapabilities.add(index, item);
    return (A)this;
  }
  public A setToAllowedCapabilities(Integer index,String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    this.allowedCapabilities.set(index, item); return (A)this;
  }
  public A addToAllowedCapabilities(java.lang.String... items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A addAllToAllowedCapabilities(Collection<String> items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A removeFromAllowedCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedCapabilities(Collection<String> items) {
    for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getAllowedCapabilities() {
    return this.allowedCapabilities;
  }
  public String getAllowedCapability(Integer index) {
    return this.allowedCapabilities.get(index);
  }
  public String getFirstAllowedCapability() {
    return this.allowedCapabilities.get(0);
  }
  public String getLastAllowedCapability() {
    return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
  }
  public String getMatchingAllowedCapability(Predicate<String> predicate) {
    for (String item: allowedCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
    for (String item: allowedCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedCapabilities(List<String> allowedCapabilities) {
    if (allowedCapabilities != null) {this.allowedCapabilities = new ArrayList(); for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} else { this.allowedCapabilities = null;} return (A) this;
  }
  public A withAllowedCapabilities(java.lang.String... allowedCapabilities) {
    if (this.allowedCapabilities != null) {this.allowedCapabilities.clear();}
    if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
  }
  public Boolean hasAllowedCapabilities() {
    return allowedCapabilities != null && !allowedCapabilities.isEmpty();
  }
  public A addToAllowedFlexVolumes(Integer index,AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(index >= 0 ? index : _visitables.get("allowedFlexVolumes").size(), builder);this.allowedFlexVolumes.add(index >= 0 ? index : allowedFlexVolumes.size(), builder); return (A)this;
  }
  public A setToAllowedFlexVolumes(Integer index,AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedFlexVolumes").size()) { _visitables.get("allowedFlexVolumes").add(builder); } else { _visitables.get("allowedFlexVolumes").set(index, builder);}
    if (index < 0 || index >= allowedFlexVolumes.size()) { allowedFlexVolumes.add(builder); } else { allowedFlexVolumes.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A removeFromAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... items) {
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
    if (allowedFlexVolumes == null) return (A) this;
    final Iterator<AllowedFlexVolumeBuilder> each = allowedFlexVolumes.iterator();
    final List visitables = _visitables.get("allowedFlexVolumes");
    while (each.hasNext()) {
      AllowedFlexVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedFlexVolume> getAllowedFlexVolumes() {
    return allowedFlexVolumes != null ? build(allowedFlexVolumes) : null;
  }
  public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
    return allowedFlexVolumes != null ? build(allowedFlexVolumes) : null;
  }
  public AllowedFlexVolume buildAllowedFlexVolume(Integer index) {
    return this.allowedFlexVolumes.get(index).build();
  }
  public AllowedFlexVolume buildFirstAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(0).build();
  }
  public AllowedFlexVolume buildLastAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(allowedFlexVolumes.size() - 1).build();
  }
  public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    for (AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    for (AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) { _visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);}
    if (allowedFlexVolumes != null) {this.allowedFlexVolumes = new ArrayList(); for (AllowedFlexVolume item : allowedFlexVolumes){this.addToAllowedFlexVolumes(item);}} else { this.allowedFlexVolumes = null;} return (A) this;
  }
  public A withAllowedFlexVolumes(io.fabric8.openshift.api.model.AllowedFlexVolume... allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.clear();}
    if (allowedFlexVolumes != null) {for (AllowedFlexVolume item :allowedFlexVolumes){ this.addToAllowedFlexVolumes(item);}} return (A) this;
  }
  public Boolean hasAllowedFlexVolumes() {
    return allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty();
  }
  public A addNewAllowedFlexVolume(String driver) {
    return (A)addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
    return new SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl();
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
    return new SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl(-1, item);
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(Integer index,AllowedFlexVolume item) {
    return new SecurityContextConstraintsFluentImpl.AllowedFlexVolumesNestedImpl(index, item);
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(Integer index) {
    if (allowedFlexVolumes.size() <= index) throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
    if (allowedFlexVolumes.size() == 0) throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(0, buildAllowedFlexVolume(0));
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
    int index = allowedFlexVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public SecurityContextConstraintsFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedFlexVolumes.size();i++) { 
    if (predicate.test(allowedFlexVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public A addToAllowedUnsafeSysctls(Integer index,String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    this.allowedUnsafeSysctls.add(index, item);
    return (A)this;
  }
  public A setToAllowedUnsafeSysctls(Integer index,String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    this.allowedUnsafeSysctls.set(index, item); return (A)this;
  }
  public A addToAllowedUnsafeSysctls(java.lang.String... items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A removeFromAllowedUnsafeSysctls(java.lang.String... items) {
    for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
    for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public List<String> getAllowedUnsafeSysctls() {
    return this.allowedUnsafeSysctls;
  }
  public String getAllowedUnsafeSysctl(Integer index) {
    return this.allowedUnsafeSysctls.get(index);
  }
  public String getFirstAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(0);
  }
  public String getLastAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(allowedUnsafeSysctls.size() - 1);
  }
  public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
    for (String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
    for (String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
    if (allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls = new ArrayList(); for (String item : allowedUnsafeSysctls){this.addToAllowedUnsafeSysctls(item);}} else { this.allowedUnsafeSysctls = null;} return (A) this;
  }
  public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls) {
    if (this.allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls.clear();}
    if (allowedUnsafeSysctls != null) {for (String item :allowedUnsafeSysctls){ this.addToAllowedUnsafeSysctls(item);}} return (A) this;
  }
  public Boolean hasAllowedUnsafeSysctls() {
    return allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty();
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToDefaultAddCapabilities(Integer index,String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    this.defaultAddCapabilities.add(index, item);
    return (A)this;
  }
  public A setToDefaultAddCapabilities(Integer index,String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    this.defaultAddCapabilities.set(index, item); return (A)this;
  }
  public A addToDefaultAddCapabilities(java.lang.String... items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A addAllToDefaultAddCapabilities(Collection<String> items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A removeFromDefaultAddCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
    for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getDefaultAddCapabilities() {
    return this.defaultAddCapabilities;
  }
  public String getDefaultAddCapability(Integer index) {
    return this.defaultAddCapabilities.get(index);
  }
  public String getFirstDefaultAddCapability() {
    return this.defaultAddCapabilities.get(0);
  }
  public String getLastDefaultAddCapability() {
    return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
  }
  public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
    for (String item: defaultAddCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
    for (String item: defaultAddCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
    if (defaultAddCapabilities != null) {this.defaultAddCapabilities = new ArrayList(); for (String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} else { this.defaultAddCapabilities = null;} return (A) this;
  }
  public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities) {
    if (this.defaultAddCapabilities != null) {this.defaultAddCapabilities.clear();}
    if (defaultAddCapabilities != null) {for (String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
  }
  public Boolean hasDefaultAddCapabilities() {
    return defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty();
  }
  public Boolean getDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation;
  }
  public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
    this.defaultAllowPrivilegeEscalation=defaultAllowPrivilegeEscalation; return (A) this;
  }
  public Boolean hasDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation != null;
  }
  public A addToForbiddenSysctls(Integer index,String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    this.forbiddenSysctls.add(index, item);
    return (A)this;
  }
  public A setToForbiddenSysctls(Integer index,String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    this.forbiddenSysctls.set(index, item); return (A)this;
  }
  public A addToForbiddenSysctls(java.lang.String... items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A addAllToForbiddenSysctls(Collection<String> items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A removeFromForbiddenSysctls(java.lang.String... items) {
    for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromForbiddenSysctls(Collection<String> items) {
    for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public List<String> getForbiddenSysctls() {
    return this.forbiddenSysctls;
  }
  public String getForbiddenSysctl(Integer index) {
    return this.forbiddenSysctls.get(index);
  }
  public String getFirstForbiddenSysctl() {
    return this.forbiddenSysctls.get(0);
  }
  public String getLastForbiddenSysctl() {
    return this.forbiddenSysctls.get(forbiddenSysctls.size() - 1);
  }
  public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
    for (String item: forbiddenSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
    for (String item: forbiddenSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withForbiddenSysctls(List<String> forbiddenSysctls) {
    if (forbiddenSysctls != null) {this.forbiddenSysctls = new ArrayList(); for (String item : forbiddenSysctls){this.addToForbiddenSysctls(item);}} else { this.forbiddenSysctls = null;} return (A) this;
  }
  public A withForbiddenSysctls(java.lang.String... forbiddenSysctls) {
    if (this.forbiddenSysctls != null) {this.forbiddenSysctls.clear();}
    if (forbiddenSysctls != null) {for (String item :forbiddenSysctls){ this.addToForbiddenSysctls(item);}} return (A) this;
  }
  public Boolean hasForbiddenSysctls() {
    return forbiddenSysctls != null && !forbiddenSysctls.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildFsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public FSGroupStrategyOptions getFsGroup() {
    return this.fsGroup!=null ?this.fsGroup.build():null;
  }
  public FSGroupStrategyOptions buildFsGroup() {
    return this.fsGroup!=null ?this.fsGroup.build():null;
  }
  public A withFsGroup(FSGroupStrategyOptions fsGroup) {
    _visitables.get("fsGroup").remove(this.fsGroup);
    if (fsGroup!=null){ this.fsGroup= new FSGroupStrategyOptionsBuilder(fsGroup); _visitables.get("fsGroup").add(this.fsGroup);} else { this.fsGroup = null; _visitables.get("fsGroup").remove(this.fsGroup); } return (A) this;
  }
  public Boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup() {
    return new SecurityContextConstraintsFluentImpl.FsGroupNestedImpl();
  }
  public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
    return new SecurityContextConstraintsFluentImpl.FsGroupNestedImpl(item);
  }
  public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup() {
    return withNewFsGroupLike(getFsGroup());
  }
  public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup() {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new FSGroupStrategyOptionsBuilder().build());
  }
  public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata() {
    return new SecurityContextConstraintsFluentImpl.MetadataNestedImpl();
  }
  public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new SecurityContextConstraintsFluentImpl.MetadataNestedImpl(item);
  }
  public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public Integer getPriority() {
    return this.priority;
  }
  public A withPriority(Integer priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public Boolean getReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem;
  }
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
    this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
  }
  public Boolean hasReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem != null;
  }
  public A addToRequiredDropCapabilities(Integer index,String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    this.requiredDropCapabilities.add(index, item);
    return (A)this;
  }
  public A setToRequiredDropCapabilities(Integer index,String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    this.requiredDropCapabilities.set(index, item); return (A)this;
  }
  public A addToRequiredDropCapabilities(java.lang.String... items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A addAllToRequiredDropCapabilities(Collection<String> items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A removeFromRequiredDropCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
    for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getRequiredDropCapabilities() {
    return this.requiredDropCapabilities;
  }
  public String getRequiredDropCapability(Integer index) {
    return this.requiredDropCapabilities.get(index);
  }
  public String getFirstRequiredDropCapability() {
    return this.requiredDropCapabilities.get(0);
  }
  public String getLastRequiredDropCapability() {
    return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
  }
  public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
    for (String item: requiredDropCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
    for (String item: requiredDropCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
    if (requiredDropCapabilities != null) {this.requiredDropCapabilities = new ArrayList(); for (String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} else { this.requiredDropCapabilities = null;} return (A) this;
  }
  public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities) {
    if (this.requiredDropCapabilities != null) {this.requiredDropCapabilities.clear();}
    if (requiredDropCapabilities != null) {for (String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
  }
  public Boolean hasRequiredDropCapabilities() {
    return requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildRunAsUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsUserStrategyOptions getRunAsUser() {
    return this.runAsUser!=null ?this.runAsUser.build():null;
  }
  public RunAsUserStrategyOptions buildRunAsUser() {
    return this.runAsUser!=null ?this.runAsUser.build():null;
  }
  public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
    _visitables.get("runAsUser").remove(this.runAsUser);
    if (runAsUser!=null){ this.runAsUser= new RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.get("runAsUser").add(this.runAsUser);} else { this.runAsUser = null; _visitables.get("runAsUser").remove(this.runAsUser); } return (A) this;
  }
  public Boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  public A withNewRunAsUser(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser() {
    return new SecurityContextConstraintsFluentImpl.RunAsUserNestedImpl();
  }
  public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
    return new SecurityContextConstraintsFluentImpl.RunAsUserNestedImpl(item);
  }
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser());
  }
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new RunAsUserStrategyOptionsBuilder().build());
  }
  public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSeLinuxContext instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxContextStrategyOptions getSeLinuxContext() {
    return this.seLinuxContext!=null ?this.seLinuxContext.build():null;
  }
  public SELinuxContextStrategyOptions buildSeLinuxContext() {
    return this.seLinuxContext!=null ?this.seLinuxContext.build():null;
  }
  public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
    _visitables.get("seLinuxContext").remove(this.seLinuxContext);
    if (seLinuxContext!=null){ this.seLinuxContext= new SELinuxContextStrategyOptionsBuilder(seLinuxContext); _visitables.get("seLinuxContext").add(this.seLinuxContext);} else { this.seLinuxContext = null; _visitables.get("seLinuxContext").remove(this.seLinuxContext); } return (A) this;
  }
  public Boolean hasSeLinuxContext() {
    return this.seLinuxContext != null;
  }
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext() {
    return new SecurityContextConstraintsFluentImpl.SeLinuxContextNestedImpl();
  }
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
    return new SecurityContextConstraintsFluentImpl.SeLinuxContextNestedImpl(item);
  }
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext() {
    return withNewSeLinuxContextLike(getSeLinuxContext());
  }
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext() {
    return withNewSeLinuxContextLike(getSeLinuxContext() != null ? getSeLinuxContext(): new SELinuxContextStrategyOptionsBuilder().build());
  }
  public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
    return withNewSeLinuxContextLike(getSeLinuxContext() != null ? getSeLinuxContext(): item);
  }
  public A addToSeccompProfiles(Integer index,String item) {
    if (this.seccompProfiles == null) {this.seccompProfiles = new ArrayList<String>();}
    this.seccompProfiles.add(index, item);
    return (A)this;
  }
  public A setToSeccompProfiles(Integer index,String item) {
    if (this.seccompProfiles == null) {this.seccompProfiles = new ArrayList<String>();}
    this.seccompProfiles.set(index, item); return (A)this;
  }
  public A addToSeccompProfiles(java.lang.String... items) {
    if (this.seccompProfiles == null) {this.seccompProfiles = new ArrayList<String>();}
    for (String item : items) {this.seccompProfiles.add(item);} return (A)this;
  }
  public A addAllToSeccompProfiles(Collection<String> items) {
    if (this.seccompProfiles == null) {this.seccompProfiles = new ArrayList<String>();}
    for (String item : items) {this.seccompProfiles.add(item);} return (A)this;
  }
  public A removeFromSeccompProfiles(java.lang.String... items) {
    for (String item : items) {if (this.seccompProfiles!= null){ this.seccompProfiles.remove(item);}} return (A)this;
  }
  public A removeAllFromSeccompProfiles(Collection<String> items) {
    for (String item : items) {if (this.seccompProfiles!= null){ this.seccompProfiles.remove(item);}} return (A)this;
  }
  public List<String> getSeccompProfiles() {
    return this.seccompProfiles;
  }
  public String getSeccompProfile(Integer index) {
    return this.seccompProfiles.get(index);
  }
  public String getFirstSeccompProfile() {
    return this.seccompProfiles.get(0);
  }
  public String getLastSeccompProfile() {
    return this.seccompProfiles.get(seccompProfiles.size() - 1);
  }
  public String getMatchingSeccompProfile(Predicate<String> predicate) {
    for (String item: seccompProfiles) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSeccompProfile(Predicate<String> predicate) {
    for (String item: seccompProfiles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSeccompProfiles(List<String> seccompProfiles) {
    if (seccompProfiles != null) {this.seccompProfiles = new ArrayList(); for (String item : seccompProfiles){this.addToSeccompProfiles(item);}} else { this.seccompProfiles = null;} return (A) this;
  }
  public A withSeccompProfiles(java.lang.String... seccompProfiles) {
    if (this.seccompProfiles != null) {this.seccompProfiles.clear();}
    if (seccompProfiles != null) {for (String item :seccompProfiles){ this.addToSeccompProfiles(item);}} return (A) this;
  }
  public Boolean hasSeccompProfiles() {
    return seccompProfiles != null && !seccompProfiles.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSupplementalGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public SupplementalGroupsStrategyOptions getSupplementalGroups() {
    return this.supplementalGroups!=null ?this.supplementalGroups.build():null;
  }
  public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
    return this.supplementalGroups!=null ?this.supplementalGroups.build():null;
  }
  public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
    _visitables.get("supplementalGroups").remove(this.supplementalGroups);
    if (supplementalGroups!=null){ this.supplementalGroups= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.get("supplementalGroups").add(this.supplementalGroups);} else { this.supplementalGroups = null; _visitables.get("supplementalGroups").remove(this.supplementalGroups); } return (A) this;
  }
  public Boolean hasSupplementalGroups() {
    return this.supplementalGroups != null;
  }
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
    return new SecurityContextConstraintsFluentImpl.SupplementalGroupsNestedImpl();
  }
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
    return new SecurityContextConstraintsFluentImpl.SupplementalGroupsNestedImpl(item);
  }
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups());
  }
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new SupplementalGroupsStrategyOptionsBuilder().build());
  }
  public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
  }
  public A addToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.add(index, item);
    return (A)this;
  }
  public A setToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.set(index, item); return (A)this;
  }
  public A addToUsers(java.lang.String... items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A addAllToUsers(Collection<String> items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A removeFromUsers(java.lang.String... items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public A removeAllFromUsers(Collection<String> items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public List<String> getUsers() {
    return this.users;
  }
  public String getUser(Integer index) {
    return this.users.get(index);
  }
  public String getFirstUser() {
    return this.users.get(0);
  }
  public String getLastUser() {
    return this.users.get(users.size() - 1);
  }
  public String getMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(List<String> users) {
    if (users != null) {this.users = new ArrayList(); for (String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(java.lang.String... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (String item :users){ this.addToUsers(item);}} return (A) this;
  }
  public Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public A addToVolumes(Integer index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(Integer index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(java.lang.String... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(Collection<String> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(java.lang.String... items) {
    for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<String> items) {
    for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public List<String> getVolumes() {
    return this.volumes;
  }
  public String getVolume(Integer index) {
    return this.volumes.get(index);
  }
  public String getFirstVolume() {
    return this.volumes.get(0);
  }
  public String getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public String getMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<String> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(java.lang.String... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl) o;
    if (allowHostDirVolumePlugin != null ? !allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) :that.allowHostDirVolumePlugin != null) return false;
    if (allowHostIPC != null ? !allowHostIPC.equals(that.allowHostIPC) :that.allowHostIPC != null) return false;
    if (allowHostNetwork != null ? !allowHostNetwork.equals(that.allowHostNetwork) :that.allowHostNetwork != null) return false;
    if (allowHostPID != null ? !allowHostPID.equals(that.allowHostPID) :that.allowHostPID != null) return false;
    if (allowHostPorts != null ? !allowHostPorts.equals(that.allowHostPorts) :that.allowHostPorts != null) return false;
    if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
    if (allowPrivilegedContainer != null ? !allowPrivilegedContainer.equals(that.allowPrivilegedContainer) :that.allowPrivilegedContainer != null) return false;
    if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
    if (allowedFlexVolumes != null ? !allowedFlexVolumes.equals(that.allowedFlexVolumes) :that.allowedFlexVolumes != null) return false;
    if (allowedUnsafeSysctls != null ? !allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) :that.allowedUnsafeSysctls != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
    if (defaultAllowPrivilegeEscalation != null ? !defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) :that.defaultAllowPrivilegeEscalation != null) return false;
    if (forbiddenSysctls != null ? !forbiddenSysctls.equals(that.forbiddenSysctls) :that.forbiddenSysctls != null) return false;
    if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
    if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
    if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
    if (seLinuxContext != null ? !seLinuxContext.equals(that.seLinuxContext) :that.seLinuxContext != null) return false;
    if (seccompProfiles != null ? !seccompProfiles.equals(that.seccompProfiles) :that.seccompProfiles != null) return false;
    if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowHostDirVolumePlugin,  allowHostIPC,  allowHostNetwork,  allowHostPID,  allowHostPorts,  allowPrivilegeEscalation,  allowPrivilegedContainer,  allowedCapabilities,  allowedFlexVolumes,  allowedUnsafeSysctls,  apiVersion,  defaultAddCapabilities,  defaultAllowPrivilegeEscalation,  forbiddenSysctls,  fsGroup,  groups,  kind,  metadata,  priority,  readOnlyRootFilesystem,  requiredDropCapabilities,  runAsUser,  seLinuxContext,  seccompProfiles,  supplementalGroups,  users,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowHostDirVolumePlugin != null) { sb.append("allowHostDirVolumePlugin:"); sb.append(allowHostDirVolumePlugin + ","); }
    if (allowHostIPC != null) { sb.append("allowHostIPC:"); sb.append(allowHostIPC + ","); }
    if (allowHostNetwork != null) { sb.append("allowHostNetwork:"); sb.append(allowHostNetwork + ","); }
    if (allowHostPID != null) { sb.append("allowHostPID:"); sb.append(allowHostPID + ","); }
    if (allowHostPorts != null) { sb.append("allowHostPorts:"); sb.append(allowHostPorts + ","); }
    if (allowPrivilegeEscalation != null) { sb.append("allowPrivilegeEscalation:"); sb.append(allowPrivilegeEscalation + ","); }
    if (allowPrivilegedContainer != null) { sb.append("allowPrivilegedContainer:"); sb.append(allowPrivilegedContainer + ","); }
    if (allowedCapabilities != null && !allowedCapabilities.isEmpty()) { sb.append("allowedCapabilities:"); sb.append(allowedCapabilities + ","); }
    if (allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty()) { sb.append("allowedFlexVolumes:"); sb.append(allowedFlexVolumes + ","); }
    if (allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty()) { sb.append("allowedUnsafeSysctls:"); sb.append(allowedUnsafeSysctls + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty()) { sb.append("defaultAddCapabilities:"); sb.append(defaultAddCapabilities + ","); }
    if (defaultAllowPrivilegeEscalation != null) { sb.append("defaultAllowPrivilegeEscalation:"); sb.append(defaultAllowPrivilegeEscalation + ","); }
    if (forbiddenSysctls != null && !forbiddenSysctls.isEmpty()) { sb.append("forbiddenSysctls:"); sb.append(forbiddenSysctls + ","); }
    if (fsGroup != null) { sb.append("fsGroup:"); sb.append(fsGroup + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (readOnlyRootFilesystem != null) { sb.append("readOnlyRootFilesystem:"); sb.append(readOnlyRootFilesystem + ","); }
    if (requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty()) { sb.append("requiredDropCapabilities:"); sb.append(requiredDropCapabilities + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (seLinuxContext != null) { sb.append("seLinuxContext:"); sb.append(seLinuxContext + ","); }
    if (seccompProfiles != null && !seccompProfiles.isEmpty()) { sb.append("seccompProfiles:"); sb.append(seccompProfiles + ","); }
    if (supplementalGroups != null) { sb.append("supplementalGroups:"); sb.append(supplementalGroups + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowHostDirVolumePlugin() {
    return withAllowHostDirVolumePlugin(true);
  }
  public A withAllowHostIPC() {
    return withAllowHostIPC(true);
  }
  public A withAllowHostNetwork() {
    return withAllowHostNetwork(true);
  }
  public A withAllowHostPID() {
    return withAllowHostPID(true);
  }
  public A withAllowHostPorts() {
    return withAllowHostPorts(true);
  }
  public A withAllowPrivilegeEscalation() {
    return withAllowPrivilegeEscalation(true);
  }
  public A withAllowPrivilegedContainer() {
    return withAllowPrivilegedContainer(true);
  }
  public A withDefaultAllowPrivilegeEscalation() {
    return withDefaultAllowPrivilegeEscalation(true);
  }
  public A withReadOnlyRootFilesystem() {
    return withReadOnlyRootFilesystem(true);
  }
  class AllowedFlexVolumesNestedImpl<N> extends AllowedFlexVolumeFluentImpl<SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>> implements SecurityContextConstraintsFluent.AllowedFlexVolumesNested<N>,Nested<N>{
    AllowedFlexVolumesNestedImpl(Integer index,AllowedFlexVolume item) {
      this.index = index;
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumesNestedImpl() {
      this.index = -1;
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    Integer index;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.setToAllowedFlexVolumes(index,builder.build());
    }
    public N endAllowedFlexVolume() {
      return and();
    }
    
  }
  class FsGroupNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.FsGroupNested<N>> implements SecurityContextConstraintsFluent.FsGroupNested<N>,Nested<N>{
    FsGroupNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FsGroupNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.withFsGroup(builder.build());
    }
    public N endFsGroup() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>> implements SecurityContextConstraintsFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RunAsUserNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>> implements SecurityContextConstraintsFluent.RunAsUserNested<N>,Nested<N>{
    RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.withRunAsUser(builder.build());
    }
    public N endRunAsUser() {
      return and();
    }
    
  }
  class SeLinuxContextNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>> implements SecurityContextConstraintsFluent.SeLinuxContextNested<N>,Nested<N>{
    SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SeLinuxContextNestedImpl() {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(builder.build());
    }
    public N endSeLinuxContext() {
      return and();
    }
    
  }
  class SupplementalGroupsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>> implements SecurityContextConstraintsFluent.SupplementalGroupsNested<N>,Nested<N>{
    SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(builder.build());
    }
    public N endSupplementalGroups() {
      return and();
    }
    
  }
  
}