package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicySubjectReviewBuilder extends PodSecurityPolicySubjectReviewFluentImpl<PodSecurityPolicySubjectReviewBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReview,PodSecurityPolicySubjectReviewBuilder>{
  public PodSecurityPolicySubjectReviewBuilder() {
    this(false);
  }
  public PodSecurityPolicySubjectReviewBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicySubjectReview(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicySubjectReview(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance) {
    this(instance,false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicySubjectReviewFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicySubjectReview build() {
    PodSecurityPolicySubjectReview buildable = new PodSecurityPolicySubjectReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}