package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends BaseFluent<A> implements PolicyRuleFluent<A>{
  public PolicyRuleFluentImpl() {
  }
  public PolicyRuleFluentImpl(PolicyRule instance) {
    this.withApiGroups(instance.getApiGroups()); 
    this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withResourceNames(instance.getResourceNames()); 
    this.withResources(instance.getResources()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> apiGroups = new ArrayList<String>();
  private VisitableBuilder<? extends KubernetesResource,?> attributeRestrictions;
  private List<String> nonResourceURLs = new ArrayList<String>();
  private List<String> resourceNames = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private List<String> verbs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToApiGroups(Integer index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(Integer index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromApiGroups(Collection<String> items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  public String getApiGroup(Integer index) {
    return this.apiGroups.get(index);
  }
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public String getMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new ArrayList(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear();}
    if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public Boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAttributeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public KubernetesResource buildAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public A withAttributeRestrictions(KubernetesResource attributeRestrictions) {
    if (attributeRestrictions instanceof GenericWebHookCause){ this.attributeRestrictions= new GenericWebHookCauseBuilder((GenericWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountRestriction){ this.attributeRestrictions= new ServiceAccountRestrictionBuilder((ServiceAccountRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ScopeRestriction){ this.attributeRestrictions= new ScopeRestrictionBuilder((ScopeRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretLocalReference){ this.attributeRestrictions= new SecretLocalReferenceBuilder((SecretLocalReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof StepInfo){ this.attributeRestrictions= new StepInfoBuilder((StepInfo)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserRestriction){ this.attributeRestrictions= new UserRestrictionBuilder((UserRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodTemplateSpec){ this.attributeRestrictions= new PodTemplateSpecBuilder((PodTemplateSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceList){ this.attributeRestrictions= new TemplateInstanceListBuilder((TemplateInstanceList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImport){ this.attributeRestrictions= new ImageStreamImportBuilder((ImageStreamImport)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceRequirements){ this.attributeRestrictions= new ResourceRequirementsBuilder((ResourceRequirements)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitHubWebHookCause){ this.attributeRestrictions= new GitHubWebHookCauseBuilder((GitHubWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientList){ this.attributeRestrictions= new OAuthClientListBuilder((OAuthClientList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReviewStatus){ this.attributeRestrictions= new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceStatus){ this.attributeRestrictions= new TemplateInstanceStatusBuilder((TemplateInstanceStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositoryList){ this.attributeRestrictions= new HelmChartRepositoryListBuilder((HelmChartRepositoryList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PolicyRule){ this.attributeRestrictions= new PolicyRuleBuilder((PolicyRule)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentTriggerPolicy){ this.attributeRestrictions= new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStrategy){ this.attributeRestrictions= new BuildStrategyBuilder((BuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RepositoryImportSpec){ this.attributeRestrictions= new RepositoryImportSpecBuilder((RepositoryImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstanceList){ this.attributeRestrictions= new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImportStatus){ this.attributeRestrictions= new ImageStreamImportStatusBuilder((ImageStreamImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof CustomBuildStrategy){ this.attributeRestrictions= new CustomBuildStrategyBuilder((CustomBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaSelector){ this.attributeRestrictions= new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectAccessReviewResponse){ this.attributeRestrictions= new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentTriggerImageChangeParams){ this.attributeRestrictions= new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalObjectReference){ this.attributeRestrictions= new LocalObjectReferenceBuilder((LocalObjectReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagImageHook){ this.attributeRestrictions= new TagImageHookBuilder((TagImageHook)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteTargetReference){ this.attributeRestrictions= new RouteTargetReferenceBuilder((RouteTargetReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.runtime.RawExtension){ this.attributeRestrictions= new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder((io.fabric8.openshift.api.model.runtime.RawExtension)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReviewSpec){ this.attributeRestrictions= new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagReferencePolicy){ this.attributeRestrictions= new TagReferencePolicyBuilder((TagReferencePolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleList){ this.attributeRestrictions= new RoleListBuilder((RoleList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Project){ this.attributeRestrictions= new ProjectBuilder((Project)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolumeSource){ this.attributeRestrictions= new BuildVolumeSourceBuilder((BuildVolumeSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuotaList){ this.attributeRestrictions= new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigList){ this.attributeRestrictions= new DeploymentConfigListBuilder((DeploymentConfigList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatusOutput){ this.attributeRestrictions= new BuildStatusOutputBuilder((BuildStatusOutput)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfig){ this.attributeRestrictions= new BuildConfigBuilder((BuildConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageImportStatus){ this.attributeRestrictions= new ImageImportStatusBuilder((ImageImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReview){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitLabWebHookCause){ this.attributeRestrictions= new GitLabWebHookCauseBuilder((GitLabWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigStatus){ this.attributeRestrictions= new DeploymentConfigStatusBuilder((DeploymentConfigStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretBuildSource){ this.attributeRestrictions= new SecretBuildSourceBuilder((SecretBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicySpec){ this.attributeRestrictions= new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepository){ this.attributeRestrictions= new HelmChartRepositoryBuilder((HelmChartRepository)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagEvent){ this.attributeRestrictions= new TagEventBuilder((TagEvent)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTagList){ this.attributeRestrictions= new ImageStreamTagListBuilder((ImageStreamTagList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BitbucketWebHookCause){ this.attributeRestrictions= new BitbucketWebHookCauseBuilder((BitbucketWebHookCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectList){ this.attributeRestrictions= new ProjectListBuilder((ProjectList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocation){ this.attributeRestrictions= new RangeAllocationBuilder((RangeAllocation)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleScopeRestriction){ this.attributeRestrictions= new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Route){ this.attributeRestrictions= new RouteBuilder((Route)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceStrategyOptions){ this.attributeRestrictions= new SourceStrategyOptionsBuilder((SourceStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetwork){ this.attributeRestrictions= new ClusterNetworkBuilder((ClusterNetwork)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeToken){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DockerBuildStrategy){ this.attributeRestrictions= new DockerBuildStrategyBuilder((DockerBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureCondition){ this.attributeRestrictions= new SignatureConditionBuilder((SignatureCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessToken){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestrictionList){ this.attributeRestrictions= new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RawExtension){ this.attributeRestrictions= new RawExtensionBuilder((RawExtension)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraintsList){ this.attributeRestrictions= new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof IdentityList){ this.attributeRestrictions= new IdentityListBuilder((IdentityList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigList){ this.attributeRestrictions= new BuildConfigListBuilder((BuildConfigList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetworkList){ this.attributeRestrictions= new ClusterNetworkListBuilder((ClusterNetworkList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceCondition){ this.attributeRestrictions= new TemplateInstanceConditionBuilder((TemplateInstanceCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RepositoryImportStatus){ this.attributeRestrictions= new RepositoryImportStatusBuilder((RepositoryImportStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCause){ this.attributeRestrictions= new DeploymentCauseBuilder((DeploymentCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GroupList){ this.attributeRestrictions= new GroupListBuilder((GroupList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RunAsUserStrategyOptions){ this.attributeRestrictions= new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LifecycleHook){ this.attributeRestrictions= new LifecycleHookBuilder((LifecycleHook)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTagReference){ this.attributeRestrictions= new ImageStreamTagReferenceBuilder((ImageStreamTagReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceControlUser){ this.attributeRestrictions= new SourceControlUserBuilder((SourceControlUser)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Container){ this.attributeRestrictions= new ContainerBuilder((Container)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamList){ this.attributeRestrictions= new ImageStreamListBuilder((ImageStreamList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBinding){ this.attributeRestrictions= new ClusterRoleBindingBuilder((ClusterRoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceAccessReview){ this.attributeRestrictions= new ResourceAccessReviewBuilder((ResourceAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SelfSubjectRulesReview){ this.attributeRestrictions= new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessTokenList){ this.attributeRestrictions= new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeTriggerStatus){ this.attributeRestrictions= new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteStatus){ this.attributeRestrictions= new RouteStatusBuilder((RouteStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuota){ this.attributeRestrictions= new ClusterResourceQuotaBuilder((ClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NamedTagEventList){ this.attributeRestrictions= new NamedTagEventListBuilder((NamedTagEventList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaList){ this.attributeRestrictions= new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteSpec){ this.attributeRestrictions= new RouteSpecBuilder((RouteSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectRequest){ this.attributeRestrictions= new ProjectRequestBuilder((ProjectRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Template){ this.attributeRestrictions= new TemplateBuilder((Template)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLookupPolicy){ this.attributeRestrictions= new ImageLookupPolicyBuilder((ImageLookupPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorization){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeCause){ this.attributeRestrictions= new ImageChangeCauseBuilder((ImageChangeCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AllowedFlexVolume){ this.attributeRestrictions= new AllowedFlexVolumeBuilder((AllowedFlexVolume)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectAccessReview){ this.attributeRestrictions= new SubjectAccessReviewBuilder((SubjectAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalResourceAccessReview){ this.attributeRestrictions= new LocalResourceAccessReviewBuilder((LocalResourceAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRole){ this.attributeRestrictions= new ClusterRoleBuilder((ClusterRole)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ConnectionConfig){ this.attributeRestrictions= new ConnectionConfigBuilder((ConnectionConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagEventCondition){ this.attributeRestrictions= new TagEventConditionBuilder((TagEventCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LabelSelector){ this.attributeRestrictions= new LabelSelectorBuilder((LabelSelector)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespaceList){ this.attributeRestrictions= new NetNamespaceListBuilder((NetNamespaceList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstanceSpec){ this.attributeRestrictions= new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BinaryBuildSource){ this.attributeRestrictions= new BinaryBuildSourceBuilder((BinaryBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorizationList){ this.attributeRestrictions= new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildSpec){ this.attributeRestrictions= new BuildSpecBuilder((BuildSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectStatus){ this.attributeRestrictions= new ProjectStatusBuilder((ProjectStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof LocalSubjectAccessReview){ this.attributeRestrictions= new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RollingDeploymentStrategyParams){ this.attributeRestrictions= new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitSourceRevision){ this.attributeRestrictions= new GitSourceRevisionBuilder((GitSourceRevision)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLabel){ this.attributeRestrictions= new ImageLabelBuilder((ImageLabel)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageChangeTrigger){ this.attributeRestrictions= new ImageChangeTriggerBuilder((ImageChangeTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReviewSpec){ this.attributeRestrictions= new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTag){ this.attributeRestrictions= new ImageTagBuilder((ImageTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImportSpec){ this.attributeRestrictions= new ImageStreamImportSpecBuilder((ImageStreamImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof FSGroupStrategyOptions){ this.attributeRestrictions= new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicyReview){ this.attributeRestrictions= new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RecreateDeploymentStrategyParams){ this.attributeRestrictions= new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DockerStrategyOptions){ this.attributeRestrictions= new DockerStrategyOptionsBuilder((DockerStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageList){ this.attributeRestrictions= new ImageListBuilder((ImageList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ConfigMapBuildSource){ this.attributeRestrictions= new ConfigMapBuildSourceBuilder((ConfigMapBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTagList){ this.attributeRestrictions= new ImageTagListBuilder((ImageTagList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessToken){ this.attributeRestrictions= new OAuthAccessTokenBuilder((OAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfig){ this.attributeRestrictions= new DeploymentConfigBuilder((DeploymentConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBinding){ this.attributeRestrictions= new RoleBindingBuilder((RoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Image){ this.attributeRestrictions= new ImageBuilder((Image)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TLSConfig){ this.attributeRestrictions= new TLSConfigBuilder((TLSConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolume){ this.attributeRestrictions= new BuildVolumeBuilder((BuildVolume)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceSpec){ this.attributeRestrictions= new TemplateInstanceSpecBuilder((TemplateInstanceSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatus){ this.attributeRestrictions= new BuildStatusBuilder((BuildStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSource){ this.attributeRestrictions= new ImageSourceBuilder((ImageSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ObjectMeta){ this.attributeRestrictions= new ObjectMetaBuilder((ObjectMeta)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PersistentVolumeClaim){ this.attributeRestrictions= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySelfSubjectReview){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagReference){ this.attributeRestrictions= new TagReferenceBuilder((TagReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyRule){ this.attributeRestrictions= new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReviewStatus){ this.attributeRestrictions= new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildVolumeMount){ this.attributeRestrictions= new BuildVolumeMountBuilder((BuildVolumeMount)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetworkEntry){ this.attributeRestrictions= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceObject){ this.attributeRestrictions= new TemplateInstanceObjectBuilder((TemplateInstanceObject)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GenericKubernetesResource){ this.attributeRestrictions= new GenericKubernetesResourceBuilder((GenericKubernetesResource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildSource){ this.attributeRestrictions= new BuildSourceBuilder((BuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaStatus){ this.attributeRestrictions= new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCondition){ this.attributeRestrictions= new DeploymentConditionBuilder((DeploymentCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositorySpec){ this.attributeRestrictions= new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentCauseImageTrigger){ this.attributeRestrictions= new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamMapping){ this.attributeRestrictions= new ImageStreamMappingBuilder((ImageStreamMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SubjectRulesReview){ this.attributeRestrictions= new SubjectRulesReviewBuilder((SubjectRulesReview)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Role){ this.attributeRestrictions= new RoleBuilder((Role)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GitBuildSource){ this.attributeRestrictions= new GitBuildSourceBuilder((GitBuildSource)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyList){ this.attributeRestrictions= new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SelfSubjectRulesReviewSpec){ this.attributeRestrictions= new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSourcePath){ this.attributeRestrictions= new ImageSourcePathBuilder((ImageSourcePath)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigStatus){ this.attributeRestrictions= new BuildConfigStatusBuilder((BuildConfigStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceQuotaStatusByNamespace){ this.attributeRestrictions= new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceBuildStrategy){ this.attributeRestrictions= new SourceBuildStrategyBuilder((SourceBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Parameter){ this.attributeRestrictions= new ParameterBuilder((Parameter)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingList){ this.attributeRestrictions= new RoleBindingListBuilder((RoleBindingList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySelfSubjectReviewSpec){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstance){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildPostCommitSpec){ this.attributeRestrictions= new BuildPostCommitSpecBuilder((BuildPostCommitSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeTokenList){ this.attributeRestrictions= new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentStrategy){ this.attributeRestrictions= new DeploymentStrategyBuilder((DeploymentStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureSubject){ this.attributeRestrictions= new SignatureSubjectBuilder((SignatureSubject)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnetList){ this.attributeRestrictions= new HostSubnetListBuilder((HostSubnetList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteIngressCondition){ this.attributeRestrictions= new RouteIngressConditionBuilder((RouteIngressCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof CustomDeploymentStrategyParams){ this.attributeRestrictions= new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageImportSpec){ this.attributeRestrictions= new ImageImportSpecBuilder((ImageImportSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof StageInfo){ this.attributeRestrictions= new StageInfoBuilder((StageInfo)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestrictionSpec){ this.attributeRestrictions= new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof IDRange){ this.attributeRestrictions= new IDRangeBuilder((IDRange)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserList){ this.attributeRestrictions= new UserListBuilder((UserList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfigSpec){ this.attributeRestrictions= new BuildConfigSpecBuilder((BuildConfigSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof User){ this.attributeRestrictions= new UserBuilder((User)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImage){ this.attributeRestrictions= new ImageStreamImageBuilder((ImageStreamImage)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildStatusOutputTo){ this.attributeRestrictions= new BuildStatusOutputToBuilder((BuildStatusOutputTo)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildCondition){ this.attributeRestrictions= new BuildConditionBuilder((BuildCondition)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ResourceAccessReviewResponse){ this.attributeRestrictions= new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ExecNewPodHook){ this.attributeRestrictions= new ExecNewPodHookBuilder((ExecNewPodHook)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecretSpec){ this.attributeRestrictions= new SecretSpecBuilder((SecretSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBindingList){ this.attributeRestrictions= new ClusterRoleBindingListBuilder((ClusterRoleBindingList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicyPeer){ this.attributeRestrictions= new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstance){ this.attributeRestrictions= new TemplateInstanceBuilder((TemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof WebHookTrigger){ this.attributeRestrictions= new WebHookTriggerBuilder((WebHookTrigger)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountReference){ this.attributeRestrictions= new ServiceAccountReferenceBuilder((ServiceAccountReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Build){ this.attributeRestrictions= new BuildBuilder((Build)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestriction){ this.attributeRestrictions= new RoleBindingRestrictionBuilder((RoleBindingRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TagImportPolicy){ this.attributeRestrictions= new TagImportPolicyBuilder((TagImportPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTag){ this.attributeRestrictions= new ImageStreamTagBuilder((ImageStreamTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildTriggerPolicy){ this.attributeRestrictions= new BuildTriggerPolicyBuilder((BuildTriggerPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoutePort){ this.attributeRestrictions= new RoutePortBuilder((RoutePort)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstanceRequester){ this.attributeRestrictions= new TemplateInstanceRequesterBuilder((TemplateInstanceRequester)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Group){ this.attributeRestrictions= new GroupBuilder((Group)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildTriggerCause){ this.attributeRestrictions= new BuildTriggerCauseBuilder((BuildTriggerCause)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSignature){ this.attributeRestrictions= new ImageSignatureBuilder((ImageSignature)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepositoryStatus){ this.attributeRestrictions= new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfigSpec){ this.attributeRestrictions= new DeploymentConfigSpecBuilder((DeploymentConfigSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnet){ this.attributeRestrictions= new HostSubnetBuilder((HostSubnet)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof GroupRestriction){ this.attributeRestrictions= new GroupRestrictionBuilder((GroupRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuota){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessTokenList){ this.attributeRestrictions= new OAuthAccessTokenListBuilder((OAuthAccessTokenList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof JenkinsPipelineBuildStrategy){ this.attributeRestrictions= new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraints){ this.attributeRestrictions= new SecurityContextConstraintsBuilder((SecurityContextConstraints)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SupplementalGroupsStrategyOptions){ this.attributeRestrictions= new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ServiceAccountPodSecurityPolicyReviewStatus){ this.attributeRestrictions= new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildRequest){ this.attributeRestrictions= new BuildRequestBuilder((BuildRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SELinuxContextStrategyOptions){ this.attributeRestrictions= new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleList){ this.attributeRestrictions= new ClusterRoleListBuilder((ClusterRoleList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteList){ this.attributeRestrictions= new RouteListBuilder((RouteList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamStatus){ this.attributeRestrictions= new ImageStreamStatusBuilder((ImageStreamStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicy){ this.attributeRestrictions= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespace){ this.attributeRestrictions= new NetNamespaceBuilder((NetNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserIdentityMapping){ this.attributeRestrictions= new UserIdentityMappingBuilder((UserIdentityMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentDetails){ this.attributeRestrictions= new DeploymentDetailsBuilder((DeploymentDetails)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReviewStatus){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PodSecurityPolicySubjectReviewSpec){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStream){ this.attributeRestrictions= new ImageStreamBuilder((ImageStream)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildList){ this.attributeRestrictions= new BuildListBuilder((BuildList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateList){ this.attributeRestrictions= new TemplateListBuilder((TemplateList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildOutput){ this.attributeRestrictions= new BuildOutputBuilder((BuildOutput)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectSpec){ this.attributeRestrictions= new ProjectSpecBuilder((ProjectSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SourceRevision){ this.attributeRestrictions= new SourceRevisionBuilder((SourceRevision)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ObjectReference){ this.attributeRestrictions= new ObjectReferenceBuilder((ObjectReference)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SignatureIssuer){ this.attributeRestrictions= new SignatureIssuerBuilder((SignatureIssuer)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageLayer){ this.attributeRestrictions= new ImageLayerBuilder((ImageLayer)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuotaSpec){ this.attributeRestrictions= new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamSpec){ this.attributeRestrictions= new ImageStreamSpecBuilder((ImageStreamSpec)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RouteIngress){ this.attributeRestrictions= new RouteIngressBuilder((RouteIngress)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClient){ this.attributeRestrictions= new OAuthClientBuilder((OAuthClient)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Identity){ this.attributeRestrictions= new IdentityBuilder((Identity)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocationList){ this.attributeRestrictions= new RangeAllocationListBuilder((RangeAllocationList)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    return (A) this;
  }
  public Boolean hasAttributeRestrictions() {
    return this.attributeRestrictions != null;
  }
  public A withGenericWebHookCauseAttributeRestrictions(GenericWebHookCause genericWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (genericWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GenericWebHookCauseBuilder(genericWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictionsLike(GenericWebHookCause item) {
    return new PolicyRuleFluentImpl.GenericWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountRestrictionAttributeRestrictions(ServiceAccountRestriction serviceAccountRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountRestrictionBuilder(serviceAccountRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictionsLike(ServiceAccountRestriction item) {
    return new PolicyRuleFluentImpl.ServiceAccountRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withScopeRestrictionAttributeRestrictions(ScopeRestriction scopeRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (scopeRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ScopeRestrictionBuilder(scopeRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictionsLike(ScopeRestriction item) {
    return new PolicyRuleFluentImpl.ScopeRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretLocalReferenceAttributeRestrictions(SecretLocalReference secretLocalReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretLocalReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new SecretLocalReferenceBuilder(secretLocalReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictionsLike(SecretLocalReference item) {
    return new PolicyRuleFluentImpl.SecretLocalReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSecretLocalReferenceAttributeRestrictions(String name) {
    return (A)withSecretLocalReferenceAttributeRestrictions(new SecretLocalReference(name));
  }
  public A withStepInfoAttributeRestrictions(StepInfo stepInfoAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (stepInfoAttributeRestrictions!=null){ this.attributeRestrictions= new StepInfoBuilder(stepInfoAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictions() {
    return new PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictionsLike(StepInfo item) {
    return new PolicyRuleFluentImpl.StepInfoAttributeRestrictionsNestedImpl(item);
  }
  public A withNewStepInfoAttributeRestrictions(Long durationMilliseconds,String name,String startTime) {
    return (A)withStepInfoAttributeRestrictions(new StepInfo(durationMilliseconds, name, startTime));
  }
  public A withUserRestrictionAttributeRestrictions(UserRestriction userRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new UserRestrictionBuilder(userRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictionsLike(UserRestriction item) {
    return new PolicyRuleFluentImpl.UserRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withPodTemplateSpecAttributeRestrictions(PodTemplateSpec podTemplateSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podTemplateSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodTemplateSpecBuilder(podTemplateSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictionsLike(PodTemplateSpec item) {
    return new PolicyRuleFluentImpl.PodTemplateSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceListAttributeRestrictions(TemplateInstanceList templateInstanceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceListAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceListBuilder(templateInstanceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictionsLike(TemplateInstanceList item) {
    return new PolicyRuleFluentImpl.TemplateInstanceListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportBuilder(imageStreamImportAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item) {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceRequirementsAttributeRestrictions(ResourceRequirements resourceRequirementsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceRequirementsAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceRequirementsBuilder(resourceRequirementsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictionsLike(ResourceRequirements item) {
    return new PolicyRuleFluentImpl.ResourceRequirementsAttributeRestrictionsNestedImpl(item);
  }
  public A withGitHubWebHookCauseAttributeRestrictions(GitHubWebHookCause gitHubWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitHubWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GitHubWebHookCauseBuilder(gitHubWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictionsLike(GitHubWebHookCause item) {
    return new PolicyRuleFluentImpl.GitHubWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientListAttributeRestrictions(OAuthClientList oAuthClientListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientListBuilder(oAuthClientListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictionsLike(OAuthClientList item) {
    return new PolicyRuleFluentImpl.OAuthClientListAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewStatusAttributeRestrictions(PodSecurityPolicyReviewStatus podSecurityPolicyReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewStatusBuilder(podSecurityPolicyReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictionsLike(PodSecurityPolicyReviewStatus item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceStatusAttributeRestrictions(TemplateInstanceStatus templateInstanceStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceStatusAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceStatusBuilder(templateInstanceStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictionsLike(TemplateInstanceStatus item) {
    return new PolicyRuleFluentImpl.TemplateInstanceStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryListAttributeRestrictions(HelmChartRepositoryList helmChartRepositoryListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryListAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryListBuilder(helmChartRepositoryListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictionsLike(HelmChartRepositoryList item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryListAttributeRestrictionsNestedImpl(item);
  }
  public A withPolicyRuleAttributeRestrictions(PolicyRule policyRuleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (policyRuleAttributeRestrictions!=null){ this.attributeRestrictions= new PolicyRuleBuilder(policyRuleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictionsLike(PolicyRule item) {
    return new PolicyRuleFluentImpl.PolicyRuleAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentTriggerPolicyAttributeRestrictions(DeploymentTriggerPolicy deploymentTriggerPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentTriggerPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentTriggerPolicyBuilder(deploymentTriggerPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictionsLike(DeploymentTriggerPolicy item) {
    return new PolicyRuleFluentImpl.DeploymentTriggerPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStrategyAttributeRestrictions(BuildStrategy buildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStrategyBuilder(buildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictionsLike(BuildStrategy item) {
    return new PolicyRuleFluentImpl.BuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withRepositoryImportSpecAttributeRestrictions(RepositoryImportSpec repositoryImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (repositoryImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RepositoryImportSpecBuilder(repositoryImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictionsLike(RepositoryImportSpec item) {
    return new PolicyRuleFluentImpl.RepositoryImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceListAttributeRestrictions(BrokerTemplateInstanceList brokerTemplateInstanceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceListAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceListBuilder(brokerTemplateInstanceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictionsLike(BrokerTemplateInstanceList item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportStatusAttributeRestrictions(ImageStreamImportStatus imageStreamImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportStatusBuilder(imageStreamImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictionsLike(ImageStreamImportStatus item) {
    return new PolicyRuleFluentImpl.ImageStreamImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withCustomBuildStrategyAttributeRestrictions(CustomBuildStrategy customBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (customBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new CustomBuildStrategyBuilder(customBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictionsLike(CustomBuildStrategy item) {
    return new PolicyRuleFluentImpl.CustomBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaSelectorAttributeRestrictions(ClusterResourceQuotaSelector clusterResourceQuotaSelectorAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaSelectorAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaSelectorBuilder(clusterResourceQuotaSelectorAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictionsLike(ClusterResourceQuotaSelector item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectAccessReviewResponseAttributeRestrictions(SubjectAccessReviewResponse subjectAccessReviewResponseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectAccessReviewResponseAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectAccessReviewResponseBuilder(subjectAccessReviewResponseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictionsLike(SubjectAccessReviewResponse item) {
    return new PolicyRuleFluentImpl.SubjectAccessReviewResponseAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentTriggerImageChangeParamsAttributeRestrictions(DeploymentTriggerImageChangeParams deploymentTriggerImageChangeParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentTriggerImageChangeParamsAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentTriggerImageChangeParamsBuilder(deploymentTriggerImageChangeParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictionsLike(DeploymentTriggerImageChangeParams item) {
    return new PolicyRuleFluentImpl.DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalObjectReferenceAttributeRestrictions(LocalObjectReference localObjectReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localObjectReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new LocalObjectReferenceBuilder(localObjectReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictionsLike(LocalObjectReference item) {
    return new PolicyRuleFluentImpl.LocalObjectReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewLocalObjectReferenceAttributeRestrictions(String name) {
    return (A)withLocalObjectReferenceAttributeRestrictions(new LocalObjectReference(name));
  }
  public A withTagImageHookAttributeRestrictions(TagImageHook tagImageHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagImageHookAttributeRestrictions!=null){ this.attributeRestrictions= new TagImageHookBuilder(tagImageHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictionsLike(TagImageHook item) {
    return new PolicyRuleFluentImpl.TagImageHookAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteTargetReferenceAttributeRestrictions(RouteTargetReference routeTargetReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeTargetReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new RouteTargetReferenceBuilder(routeTargetReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictionsLike(RouteTargetReference item) {
    return new PolicyRuleFluentImpl.RouteTargetReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRouteTargetReferenceAttributeRestrictions(String kind,String name,Integer weight) {
    return (A)withRouteTargetReferenceAttributeRestrictions(new RouteTargetReference(kind, name, weight));
  }
  public A withRawExtensionAttributeRestrictions(io.fabric8.openshift.api.model.runtime.RawExtension rawExtensionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rawExtensionAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(rawExtensionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewOpenshiftRawExtensionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return new PolicyRuleFluentImpl.OpenshiftRawExtensionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewOpenshiftRawExtensionAttributeRestrictions(Object value) {
    return (A)withRawExtensionAttributeRestrictions(new RawExtension(value));
  }
  public A withSubjectRulesReviewSpecAttributeRestrictions(SubjectRulesReviewSpec subjectRulesReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewSpecBuilder(subjectRulesReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictionsLike(SubjectRulesReviewSpec item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withTagReferencePolicyAttributeRestrictions(TagReferencePolicy tagReferencePolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagReferencePolicyAttributeRestrictions!=null){ this.attributeRestrictions= new TagReferencePolicyBuilder(tagReferencePolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictionsLike(TagReferencePolicy item) {
    return new PolicyRuleFluentImpl.TagReferencePolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagReferencePolicyAttributeRestrictions(String type) {
    return (A)withTagReferencePolicyAttributeRestrictions(new TagReferencePolicy(type));
  }
  public A withRoleListAttributeRestrictions(RoleList roleListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleListBuilder(roleListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictionsLike(RoleList item) {
    return new PolicyRuleFluentImpl.RoleListAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectAttributeRestrictions(Project projectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectBuilder(projectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item) {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeSourceAttributeRestrictions(BuildVolumeSource buildVolumeSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeSourceBuilder(buildVolumeSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictionsLike(BuildVolumeSource item) {
    return new PolicyRuleFluentImpl.BuildVolumeSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaListAttributeRestrictions(AppliedClusterResourceQuotaList appliedClusterResourceQuotaListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaListAttributeRestrictions!=null){ this.attributeRestrictions= new AppliedClusterResourceQuotaListBuilder(appliedClusterResourceQuotaListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictionsLike(AppliedClusterResourceQuotaList item) {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigListAttributeRestrictions(DeploymentConfigList deploymentConfigListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigListAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigListBuilder(deploymentConfigListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictionsLike(DeploymentConfigList item) {
    return new PolicyRuleFluentImpl.DeploymentConfigListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusOutputAttributeRestrictions(BuildStatusOutput buildStatusOutputAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusOutputAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusOutputBuilder(buildStatusOutputAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictionsLike(BuildStatusOutput item) {
    return new PolicyRuleFluentImpl.BuildStatusOutputAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigBuilder(buildConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item) {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withImageImportStatusAttributeRestrictions(ImageImportStatus imageImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageImportStatusBuilder(imageImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictionsLike(ImageImportStatus item) {
    return new PolicyRuleFluentImpl.ImageImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewAttributeRestrictions(PodSecurityPolicySubjectReview podSecurityPolicySubjectReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewBuilder(podSecurityPolicySubjectReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictionsLike(PodSecurityPolicySubjectReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withGitLabWebHookCauseAttributeRestrictions(GitLabWebHookCause gitLabWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitLabWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new GitLabWebHookCauseBuilder(gitLabWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictionsLike(GitLabWebHookCause item) {
    return new PolicyRuleFluentImpl.GitLabWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigStatusAttributeRestrictions(DeploymentConfigStatus deploymentConfigStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigStatusAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigStatusBuilder(deploymentConfigStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictionsLike(DeploymentConfigStatus item) {
    return new PolicyRuleFluentImpl.DeploymentConfigStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretBuildSourceAttributeRestrictions(SecretBuildSource secretBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new SecretBuildSourceBuilder(secretBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictionsLike(SecretBuildSource item) {
    return new PolicyRuleFluentImpl.SecretBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicySpecAttributeRestrictions(EgressNetworkPolicySpec egressNetworkPolicySpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicySpecAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicySpecBuilder(egressNetworkPolicySpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictionsLike(EgressNetworkPolicySpec item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicySpecAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryAttributeRestrictions(HelmChartRepository helmChartRepositoryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryBuilder(helmChartRepositoryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(HelmChartRepository item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl(item);
  }
  public A withTagEventAttributeRestrictions(TagEvent tagEventAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagEventAttributeRestrictions!=null){ this.attributeRestrictions= new TagEventBuilder(tagEventAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagEventAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictionsLike(TagEvent item) {
    return new PolicyRuleFluentImpl.TagEventAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagEventAttributeRestrictions(String created,String dockerImageReference,Long generation,String image) {
    return (A)withTagEventAttributeRestrictions(new TagEvent(created, dockerImageReference, generation, image));
  }
  public A withImageStreamTagListAttributeRestrictions(ImageStreamTagList imageStreamTagListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagListBuilder(imageStreamTagListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictionsLike(ImageStreamTagList item) {
    return new PolicyRuleFluentImpl.ImageStreamTagListAttributeRestrictionsNestedImpl(item);
  }
  public A withBitbucketWebHookCauseAttributeRestrictions(BitbucketWebHookCause bitbucketWebHookCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (bitbucketWebHookCauseAttributeRestrictions!=null){ this.attributeRestrictions= new BitbucketWebHookCauseBuilder(bitbucketWebHookCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictionsLike(BitbucketWebHookCause item) {
    return new PolicyRuleFluentImpl.BitbucketWebHookCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectListAttributeRestrictions(ProjectList projectListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectListAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectListBuilder(projectListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictionsLike(ProjectList item) {
    return new PolicyRuleFluentImpl.ProjectListAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationAttributeRestrictions(RangeAllocation rangeAllocationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationAttributeRestrictions!=null){ this.attributeRestrictions= new RangeAllocationBuilder(rangeAllocationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item) {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleScopeRestrictionAttributeRestrictions(ClusterRoleScopeRestriction clusterRoleScopeRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleScopeRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleScopeRestrictionBuilder(clusterRoleScopeRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictionsLike(ClusterRoleScopeRestriction item) {
    return new PolicyRuleFluentImpl.ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteAttributeRestrictions(Route routeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeAttributeRestrictions!=null){ this.attributeRestrictions= new RouteBuilder(routeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item) {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceStrategyOptionsAttributeRestrictions(SourceStrategyOptions sourceStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SourceStrategyOptionsBuilder(sourceStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictionsLike(SourceStrategyOptions item) {
    return new PolicyRuleFluentImpl.SourceStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSourceStrategyOptionsAttributeRestrictions(Boolean incremental) {
    return (A)withSourceStrategyOptionsAttributeRestrictions(new SourceStrategyOptions(incremental));
  }
  public A withClusterNetworkAttributeRestrictions(ClusterNetwork clusterNetworkAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkBuilder(clusterNetworkAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item) {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item) {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDockerBuildStrategyAttributeRestrictions(DockerBuildStrategy dockerBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (dockerBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new DockerBuildStrategyBuilder(dockerBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictionsLike(DockerBuildStrategy item) {
    return new PolicyRuleFluentImpl.DockerBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureConditionAttributeRestrictions(SignatureCondition signatureConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureConditionAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureConditionBuilder(signatureConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictionsLike(SignatureCondition item) {
    return new PolicyRuleFluentImpl.SignatureConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenAttributeRestrictions(UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(UserOAuthAccessToken item) {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionListAttributeRestrictions(RoleBindingRestrictionList roleBindingRestrictionListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionListBuilder(roleBindingRestrictionListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictionsLike(RoleBindingRestrictionList item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionListAttributeRestrictionsNestedImpl(item);
  }
  public A withRawExtensionAttributeRestrictions(RawExtension rawExtensionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rawExtensionAttributeRestrictions!=null){ this.attributeRestrictions= new RawExtensionBuilder(rawExtensionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(RawExtension item) {
    return new PolicyRuleFluentImpl.RawExtensionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRawExtensionAttributeRestrictions(Object value) {
    return (A)withRawExtensionAttributeRestrictions(new RawExtension(value));
  }
  public A withSecurityContextConstraintsListAttributeRestrictions(SecurityContextConstraintsList securityContextConstraintsListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsListAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsListBuilder(securityContextConstraintsListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictionsLike(SecurityContextConstraintsList item) {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsListAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityListAttributeRestrictions(IdentityList identityListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityListAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityListBuilder(identityListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictionsLike(IdentityList item) {
    return new PolicyRuleFluentImpl.IdentityListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigListAttributeRestrictions(BuildConfigList buildConfigListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigListAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigListBuilder(buildConfigListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictionsLike(BuildConfigList item) {
    return new PolicyRuleFluentImpl.BuildConfigListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterNetworkListAttributeRestrictions(ClusterNetworkList clusterNetworkListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkListBuilder(clusterNetworkListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictionsLike(ClusterNetworkList item) {
    return new PolicyRuleFluentImpl.ClusterNetworkListAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceConditionAttributeRestrictions(TemplateInstanceCondition templateInstanceConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceConditionAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceConditionBuilder(templateInstanceConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictionsLike(TemplateInstanceCondition item) {
    return new PolicyRuleFluentImpl.TemplateInstanceConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTemplateInstanceConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withTemplateInstanceConditionAttributeRestrictions(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withRepositoryImportStatusAttributeRestrictions(RepositoryImportStatus repositoryImportStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (repositoryImportStatusAttributeRestrictions!=null){ this.attributeRestrictions= new RepositoryImportStatusBuilder(repositoryImportStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictionsLike(RepositoryImportStatus item) {
    return new PolicyRuleFluentImpl.RepositoryImportStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentCauseAttributeRestrictions(DeploymentCause deploymentCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentCauseAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentCauseBuilder(deploymentCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictionsLike(DeploymentCause item) {
    return new PolicyRuleFluentImpl.DeploymentCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupListAttributeRestrictions(GroupList groupListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupListAttributeRestrictions!=null){ this.attributeRestrictions= new GroupListBuilder(groupListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictionsLike(GroupList item) {
    return new PolicyRuleFluentImpl.GroupListAttributeRestrictionsNestedImpl(item);
  }
  public A withRunAsUserStrategyOptionsAttributeRestrictions(RunAsUserStrategyOptions runAsUserStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (runAsUserStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new RunAsUserStrategyOptionsBuilder(runAsUserStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictionsLike(RunAsUserStrategyOptions item) {
    return new PolicyRuleFluentImpl.RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRunAsUserStrategyOptionsAttributeRestrictions(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withRunAsUserStrategyOptionsAttributeRestrictions(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  public A withLifecycleHookAttributeRestrictions(LifecycleHook lifecycleHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (lifecycleHookAttributeRestrictions!=null){ this.attributeRestrictions= new LifecycleHookBuilder(lifecycleHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictionsLike(LifecycleHook item) {
    return new PolicyRuleFluentImpl.LifecycleHookAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamTagReferenceAttributeRestrictions(ImageStreamTagReference imageStreamTagReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagReferenceBuilder(imageStreamTagReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictionsLike(ImageStreamTagReference item) {
    return new PolicyRuleFluentImpl.ImageStreamTagReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageStreamTagReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withImageStreamTagReferenceAttributeRestrictions(new ImageStreamTagReference(name, namespace));
  }
  public A withSourceControlUserAttributeRestrictions(SourceControlUser sourceControlUserAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceControlUserAttributeRestrictions!=null){ this.attributeRestrictions= new SourceControlUserBuilder(sourceControlUserAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictionsLike(SourceControlUser item) {
    return new PolicyRuleFluentImpl.SourceControlUserAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSourceControlUserAttributeRestrictions(String email,String name) {
    return (A)withSourceControlUserAttributeRestrictions(new SourceControlUser(email, name));
  }
  public A withContainerAttributeRestrictions(Container containerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (containerAttributeRestrictions!=null){ this.attributeRestrictions= new ContainerBuilder(containerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ContainerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictionsLike(Container item) {
    return new PolicyRuleFluentImpl.ContainerAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamListAttributeRestrictions(ImageStreamList imageStreamListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamListBuilder(imageStreamListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictionsLike(ImageStreamList item) {
    return new PolicyRuleFluentImpl.ImageStreamListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingBuilder(clusterRoleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item) {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceAccessReviewAttributeRestrictions(ResourceAccessReview resourceAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceAccessReviewBuilder(resourceAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictionsLike(ResourceAccessReview item) {
    return new PolicyRuleFluentImpl.ResourceAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewAttributeRestrictions(SelfSubjectRulesReview selfSubjectRulesReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (selfSubjectRulesReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SelfSubjectRulesReviewBuilder(selfSubjectRulesReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictionsLike(SelfSubjectRulesReview item) {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenListAttributeRestrictions(UserOAuthAccessTokenList userOAuthAccessTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new UserOAuthAccessTokenListBuilder(userOAuthAccessTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictionsLike(UserOAuthAccessTokenList item) {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageChangeTriggerStatusAttributeRestrictions(ImageChangeTriggerStatus imageChangeTriggerStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeTriggerStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeTriggerStatusBuilder(imageChangeTriggerStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictionsLike(ImageChangeTriggerStatus item) {
    return new PolicyRuleFluentImpl.ImageChangeTriggerStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteStatusAttributeRestrictions(RouteStatus routeStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeStatusAttributeRestrictions!=null){ this.attributeRestrictions= new RouteStatusBuilder(routeStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictionsLike(RouteStatus item) {
    return new PolicyRuleFluentImpl.RouteStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaAttributeRestrictions(ClusterResourceQuota clusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaBuilder(clusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withNamedTagEventListAttributeRestrictions(NamedTagEventList namedTagEventListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (namedTagEventListAttributeRestrictions!=null){ this.attributeRestrictions= new NamedTagEventListBuilder(namedTagEventListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictionsLike(NamedTagEventList item) {
    return new PolicyRuleFluentImpl.NamedTagEventListAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaListAttributeRestrictions(ClusterResourceQuotaList clusterResourceQuotaListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaListBuilder(clusterResourceQuotaListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictionsLike(ClusterResourceQuotaList item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteSpecAttributeRestrictions(RouteSpec routeSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RouteSpecBuilder(routeSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictionsLike(RouteSpec item) {
    return new PolicyRuleFluentImpl.RouteSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectRequestAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectRequestBuilder(projectRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item) {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateBuilder(templateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item) {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl(item);
  }
  public A withImageLookupPolicyAttributeRestrictions(ImageLookupPolicy imageLookupPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLookupPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLookupPolicyBuilder(imageLookupPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictionsLike(ImageLookupPolicy item) {
    return new PolicyRuleFluentImpl.ImageLookupPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLookupPolicyAttributeRestrictions(Boolean local) {
    return (A)withImageLookupPolicyAttributeRestrictions(new ImageLookupPolicy(local));
  }
  public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item) {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl(item);
  }
  public A withImageChangeCauseAttributeRestrictions(ImageChangeCause imageChangeCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeCauseAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeCauseBuilder(imageChangeCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictionsLike(ImageChangeCause item) {
    return new PolicyRuleFluentImpl.ImageChangeCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withAllowedFlexVolumeAttributeRestrictions(AllowedFlexVolume allowedFlexVolumeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (allowedFlexVolumeAttributeRestrictions!=null){ this.attributeRestrictions= new AllowedFlexVolumeBuilder(allowedFlexVolumeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictionsLike(AllowedFlexVolume item) {
    return new PolicyRuleFluentImpl.AllowedFlexVolumeAttributeRestrictionsNestedImpl(item);
  }
  public A withNewAllowedFlexVolumeAttributeRestrictions(String driver) {
    return (A)withAllowedFlexVolumeAttributeRestrictions(new AllowedFlexVolume(driver));
  }
  public A withSubjectAccessReviewAttributeRestrictions(SubjectAccessReview subjectAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectAccessReviewBuilder(subjectAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictionsLike(SubjectAccessReview item) {
    return new PolicyRuleFluentImpl.SubjectAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalResourceAccessReviewAttributeRestrictions(LocalResourceAccessReview localResourceAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localResourceAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new LocalResourceAccessReviewBuilder(localResourceAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictionsLike(LocalResourceAccessReview item) {
    return new PolicyRuleFluentImpl.LocalResourceAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBuilder(clusterRoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item) {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl(item);
  }
  public A withConnectionConfigAttributeRestrictions(ConnectionConfig connectionConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (connectionConfigAttributeRestrictions!=null){ this.attributeRestrictions= new ConnectionConfigBuilder(connectionConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictionsLike(ConnectionConfig item) {
    return new PolicyRuleFluentImpl.ConnectionConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withTagEventConditionAttributeRestrictions(TagEventCondition tagEventConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagEventConditionAttributeRestrictions!=null){ this.attributeRestrictions= new TagEventConditionBuilder(tagEventConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictionsLike(TagEventCondition item) {
    return new PolicyRuleFluentImpl.TagEventConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withLabelSelectorAttributeRestrictions(LabelSelector labelSelectorAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (labelSelectorAttributeRestrictions!=null){ this.attributeRestrictions= new LabelSelectorBuilder(labelSelectorAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictionsLike(LabelSelector item) {
    return new PolicyRuleFluentImpl.LabelSelectorAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceListAttributeRestrictions(NetNamespaceList netNamespaceListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceListAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceListBuilder(netNamespaceListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictionsLike(NetNamespaceList item) {
    return new PolicyRuleFluentImpl.NetNamespaceListAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceSpecAttributeRestrictions(BrokerTemplateInstanceSpec brokerTemplateInstanceSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceSpecBuilder(brokerTemplateInstanceSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictionsLike(BrokerTemplateInstanceSpec item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBinaryBuildSourceAttributeRestrictions(BinaryBuildSource binaryBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (binaryBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BinaryBuildSourceBuilder(binaryBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictionsLike(BinaryBuildSource item) {
    return new PolicyRuleFluentImpl.BinaryBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBinaryBuildSourceAttributeRestrictions(String asFile) {
    return (A)withBinaryBuildSourceAttributeRestrictions(new BinaryBuildSource(asFile));
  }
  public A withOAuthClientAuthorizationListAttributeRestrictions(OAuthClientAuthorizationList oAuthClientAuthorizationListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationListBuilder(oAuthClientAuthorizationListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictionsLike(OAuthClientAuthorizationList item) {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildSpecAttributeRestrictions(BuildSpec buildSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildSpecBuilder(buildSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictionsLike(BuildSpec item) {
    return new PolicyRuleFluentImpl.BuildSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectStatusAttributeRestrictions(ProjectStatus projectStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectStatusBuilder(projectStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictionsLike(ProjectStatus item) {
    return new PolicyRuleFluentImpl.ProjectStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withLocalSubjectAccessReviewAttributeRestrictions(LocalSubjectAccessReview localSubjectAccessReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (localSubjectAccessReviewAttributeRestrictions!=null){ this.attributeRestrictions= new LocalSubjectAccessReviewBuilder(localSubjectAccessReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictionsLike(LocalSubjectAccessReview item) {
    return new PolicyRuleFluentImpl.LocalSubjectAccessReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRollingDeploymentStrategyParamsAttributeRestrictions(RollingDeploymentStrategyParams rollingDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rollingDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new RollingDeploymentStrategyParamsBuilder(rollingDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictionsLike(RollingDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withGitSourceRevisionAttributeRestrictions(GitSourceRevision gitSourceRevisionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitSourceRevisionAttributeRestrictions!=null){ this.attributeRestrictions= new GitSourceRevisionBuilder(gitSourceRevisionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictionsLike(GitSourceRevision item) {
    return new PolicyRuleFluentImpl.GitSourceRevisionAttributeRestrictionsNestedImpl(item);
  }
  public A withImageLabelAttributeRestrictions(ImageLabel imageLabelAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLabelAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLabelBuilder(imageLabelAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictionsLike(ImageLabel item) {
    return new PolicyRuleFluentImpl.ImageLabelAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLabelAttributeRestrictions(String name,String value) {
    return (A)withImageLabelAttributeRestrictions(new ImageLabel(name, value));
  }
  public A withImageChangeTriggerAttributeRestrictions(ImageChangeTrigger imageChangeTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageChangeTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new ImageChangeTriggerBuilder(imageChangeTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictionsLike(ImageChangeTrigger item) {
    return new PolicyRuleFluentImpl.ImageChangeTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewSpecAttributeRestrictions(PodSecurityPolicyReviewSpec podSecurityPolicyReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewSpecBuilder(podSecurityPolicyReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictionsLike(PodSecurityPolicyReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagAttributeRestrictions(ImageTag imageTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageTagBuilder(imageTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item) {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportSpecAttributeRestrictions(ImageStreamImportSpec imageStreamImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportSpecBuilder(imageStreamImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictionsLike(ImageStreamImportSpec item) {
    return new PolicyRuleFluentImpl.ImageStreamImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withFSGroupStrategyOptionsAttributeRestrictions(FSGroupStrategyOptions fSGroupStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (fSGroupStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new FSGroupStrategyOptionsBuilder(fSGroupStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictionsLike(FSGroupStrategyOptions item) {
    return new PolicyRuleFluentImpl.FSGroupStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicyReviewAttributeRestrictions(PodSecurityPolicyReview podSecurityPolicyReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicyReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicyReviewBuilder(podSecurityPolicyReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictionsLike(PodSecurityPolicyReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicyReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRecreateDeploymentStrategyParamsAttributeRestrictions(RecreateDeploymentStrategyParams recreateDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (recreateDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new RecreateDeploymentStrategyParamsBuilder(recreateDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictionsLike(RecreateDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withDockerStrategyOptionsAttributeRestrictions(DockerStrategyOptions dockerStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (dockerStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new DockerStrategyOptionsBuilder(dockerStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictionsLike(DockerStrategyOptions item) {
    return new PolicyRuleFluentImpl.DockerStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withImageListAttributeRestrictions(ImageList imageListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageListBuilder(imageListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictionsLike(ImageList item) {
    return new PolicyRuleFluentImpl.ImageListAttributeRestrictionsNestedImpl(item);
  }
  public A withConfigMapBuildSourceAttributeRestrictions(ConfigMapBuildSource configMapBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (configMapBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new ConfigMapBuildSourceBuilder(configMapBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictionsLike(ConfigMapBuildSource item) {
    return new PolicyRuleFluentImpl.ConfigMapBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagListAttributeRestrictions(ImageTagList imageTagListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagListAttributeRestrictions!=null){ this.attributeRestrictions= new ImageTagListBuilder(imageTagListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictionsLike(ImageTagList item) {
    return new PolicyRuleFluentImpl.ImageTagListAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenBuilder(oAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item) {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigBuilder(deploymentConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item) {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingBuilder(roleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item) {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageAttributeRestrictions(Image imageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageBuilder(imageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item) {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl(item);
  }
  public A withTLSConfigAttributeRestrictions(TLSConfig tLSConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tLSConfigAttributeRestrictions!=null){ this.attributeRestrictions= new TLSConfigBuilder(tLSConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictionsLike(TLSConfig item) {
    return new PolicyRuleFluentImpl.TLSConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeAttributeRestrictions(BuildVolume buildVolumeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeBuilder(buildVolumeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictionsLike(BuildVolume item) {
    return new PolicyRuleFluentImpl.BuildVolumeAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceSpecAttributeRestrictions(TemplateInstanceSpec templateInstanceSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceSpecAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceSpecBuilder(templateInstanceSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictionsLike(TemplateInstanceSpec item) {
    return new PolicyRuleFluentImpl.TemplateInstanceSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusAttributeRestrictions(BuildStatus buildStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusBuilder(buildStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictionsLike(BuildStatus item) {
    return new PolicyRuleFluentImpl.BuildStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSourceAttributeRestrictions(ImageSource imageSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSourceAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSourceBuilder(imageSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictionsLike(ImageSource item) {
    return new PolicyRuleFluentImpl.ImageSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withObjectMetaAttributeRestrictions(ObjectMeta objectMetaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (objectMetaAttributeRestrictions!=null){ this.attributeRestrictions= new ObjectMetaBuilder(objectMetaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictionsLike(ObjectMeta item) {
    return new PolicyRuleFluentImpl.ObjectMetaAttributeRestrictionsNestedImpl(item);
  }
  public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (persistentVolumeClaimAttributeRestrictions!=null){ this.attributeRestrictions= new PersistentVolumeClaimBuilder(persistentVolumeClaimAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item) {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewAttributeRestrictions(PodSecurityPolicySelfSubjectReview podSecurityPolicySelfSubjectReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySelfSubjectReviewAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewBuilder(podSecurityPolicySelfSubjectReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReview item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withTagReferenceAttributeRestrictions(TagReference tagReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new TagReferenceBuilder(tagReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictionsLike(TagReference item) {
    return new PolicyRuleFluentImpl.TagReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyRuleAttributeRestrictions(EgressNetworkPolicyRule egressNetworkPolicyRuleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyRuleAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyRuleBuilder(egressNetworkPolicyRuleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictionsLike(EgressNetworkPolicyRule item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectRulesReviewStatusAttributeRestrictions(SubjectRulesReviewStatus subjectRulesReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewStatusBuilder(subjectRulesReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictionsLike(SubjectRulesReviewStatus item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildVolumeMountAttributeRestrictions(BuildVolumeMount buildVolumeMountAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildVolumeMountAttributeRestrictions!=null){ this.attributeRestrictions= new BuildVolumeMountBuilder(buildVolumeMountAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictionsLike(BuildVolumeMount item) {
    return new PolicyRuleFluentImpl.BuildVolumeMountAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBuildVolumeMountAttributeRestrictions(String destinationPath) {
    return (A)withBuildVolumeMountAttributeRestrictions(new BuildVolumeMount(destinationPath));
  }
  public A withClusterNetworkEntryAttributeRestrictions(ClusterNetworkEntry clusterNetworkEntryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkEntryAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkEntryBuilder(clusterNetworkEntryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictionsLike(ClusterNetworkEntry item) {
    return new PolicyRuleFluentImpl.ClusterNetworkEntryAttributeRestrictionsNestedImpl(item);
  }
  public A withNewClusterNetworkEntryAttributeRestrictions(String cidr,Integer hostSubnetLength) {
    return (A)withClusterNetworkEntryAttributeRestrictions(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public A withTemplateInstanceObjectAttributeRestrictions(TemplateInstanceObject templateInstanceObjectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceObjectAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceObjectBuilder(templateInstanceObjectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictionsLike(TemplateInstanceObject item) {
    return new PolicyRuleFluentImpl.TemplateInstanceObjectAttributeRestrictionsNestedImpl(item);
  }
  public A withGenericKubernetesResourceAttributeRestrictions(GenericKubernetesResource genericKubernetesResourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (genericKubernetesResourceAttributeRestrictions!=null){ this.attributeRestrictions= new GenericKubernetesResourceBuilder(genericKubernetesResourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictionsLike(GenericKubernetesResource item) {
    return new PolicyRuleFluentImpl.GenericKubernetesResourceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildSourceAttributeRestrictions(BuildSource buildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new BuildSourceBuilder(buildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictionsLike(BuildSource item) {
    return new PolicyRuleFluentImpl.BuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaStatusAttributeRestrictions(ClusterResourceQuotaStatus clusterResourceQuotaStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaStatusBuilder(clusterResourceQuotaStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictionsLike(ClusterResourceQuotaStatus item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConditionAttributeRestrictions(DeploymentCondition deploymentConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConditionAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConditionBuilder(deploymentConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictionsLike(DeploymentCondition item) {
    return new PolicyRuleFluentImpl.DeploymentConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositorySpecAttributeRestrictions(HelmChartRepositorySpec helmChartRepositorySpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositorySpecAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositorySpecBuilder(helmChartRepositorySpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictionsLike(HelmChartRepositorySpec item) {
    return new PolicyRuleFluentImpl.HelmChartRepositorySpecAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentCauseImageTriggerAttributeRestrictions(DeploymentCauseImageTrigger deploymentCauseImageTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentCauseImageTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentCauseImageTriggerBuilder(deploymentCauseImageTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictionsLike(DeploymentCauseImageTrigger item) {
    return new PolicyRuleFluentImpl.DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamMappingAttributeRestrictions(ImageStreamMapping imageStreamMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamMappingAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamMappingBuilder(imageStreamMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item) {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withSubjectRulesReviewAttributeRestrictions(SubjectRulesReview subjectRulesReviewAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (subjectRulesReviewAttributeRestrictions!=null){ this.attributeRestrictions= new SubjectRulesReviewBuilder(subjectRulesReviewAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictionsLike(SubjectRulesReview item) {
    return new PolicyRuleFluentImpl.SubjectRulesReviewAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleAttributeRestrictions(Role roleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBuilder(roleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item) {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl(item);
  }
  public A withGitBuildSourceAttributeRestrictions(GitBuildSource gitBuildSourceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (gitBuildSourceAttributeRestrictions!=null){ this.attributeRestrictions= new GitBuildSourceBuilder(gitBuildSourceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictionsLike(GitBuildSource item) {
    return new PolicyRuleFluentImpl.GitBuildSourceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewGitBuildSourceAttributeRestrictions(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withGitBuildSourceAttributeRestrictions(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  public A withEgressNetworkPolicyListAttributeRestrictions(EgressNetworkPolicyList egressNetworkPolicyListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyListAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyListBuilder(egressNetworkPolicyListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictionsLike(EgressNetworkPolicyList item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyListAttributeRestrictionsNestedImpl(item);
  }
  public A withSelfSubjectRulesReviewSpecAttributeRestrictions(SelfSubjectRulesReviewSpec selfSubjectRulesReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (selfSubjectRulesReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SelfSubjectRulesReviewSpecBuilder(selfSubjectRulesReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictionsLike(SelfSubjectRulesReviewSpec item) {
    return new PolicyRuleFluentImpl.SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSourcePathAttributeRestrictions(ImageSourcePath imageSourcePathAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSourcePathAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSourcePathBuilder(imageSourcePathAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictionsLike(ImageSourcePath item) {
    return new PolicyRuleFluentImpl.ImageSourcePathAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageSourcePathAttributeRestrictions(String destinationDir,String sourcePath) {
    return (A)withImageSourcePathAttributeRestrictions(new ImageSourcePath(destinationDir, sourcePath));
  }
  public A withBuildConfigStatusAttributeRestrictions(BuildConfigStatus buildConfigStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigStatusAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigStatusBuilder(buildConfigStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictionsLike(BuildConfigStatus item) {
    return new PolicyRuleFluentImpl.BuildConfigStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceQuotaStatusByNamespaceAttributeRestrictions(ResourceQuotaStatusByNamespace resourceQuotaStatusByNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceQuotaStatusByNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceQuotaStatusByNamespaceBuilder(resourceQuotaStatusByNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictionsLike(ResourceQuotaStatusByNamespace item) {
    return new PolicyRuleFluentImpl.ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceBuildStrategyAttributeRestrictions(SourceBuildStrategy sourceBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new SourceBuildStrategyBuilder(sourceBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictionsLike(SourceBuildStrategy item) {
    return new PolicyRuleFluentImpl.SourceBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withParameterAttributeRestrictions(Parameter parameterAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (parameterAttributeRestrictions!=null){ this.attributeRestrictions= new ParameterBuilder(parameterAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ParameterAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictionsLike(Parameter item) {
    return new PolicyRuleFluentImpl.ParameterAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingListAttributeRestrictions(RoleBindingList roleBindingListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingListAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingListBuilder(roleBindingListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictionsLike(RoleBindingList item) {
    return new PolicyRuleFluentImpl.RoleBindingListAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions(PodSecurityPolicySelfSubjectReviewSpec podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySelfSubjectReviewSpecBuilder(podSecurityPolicySelfSubjectReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceAttributeRestrictions(BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(BrokerTemplateInstance item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildPostCommitSpecAttributeRestrictions(BuildPostCommitSpec buildPostCommitSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildPostCommitSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildPostCommitSpecBuilder(buildPostCommitSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictionsLike(BuildPostCommitSpec item) {
    return new PolicyRuleFluentImpl.BuildPostCommitSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenListAttributeRestrictions(OAuthAuthorizeTokenList oAuthAuthorizeTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenListBuilder(oAuthAuthorizeTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictionsLike(OAuthAuthorizeTokenList item) {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentStrategyAttributeRestrictions(DeploymentStrategy deploymentStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentStrategyBuilder(deploymentStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictionsLike(DeploymentStrategy item) {
    return new PolicyRuleFluentImpl.DeploymentStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureSubjectAttributeRestrictions(SignatureSubject signatureSubjectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureSubjectAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureSubjectBuilder(signatureSubjectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictionsLike(SignatureSubject item) {
    return new PolicyRuleFluentImpl.SignatureSubjectAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSignatureSubjectAttributeRestrictions(String commonName,String organization,String publicKeyID) {
    return (A)withSignatureSubjectAttributeRestrictions(new SignatureSubject(commonName, organization, publicKeyID));
  }
  public A withHostSubnetListAttributeRestrictions(HostSubnetList hostSubnetListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetListAttributeRestrictions!=null){ this.attributeRestrictions= new HostSubnetListBuilder(hostSubnetListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictionsLike(HostSubnetList item) {
    return new PolicyRuleFluentImpl.HostSubnetListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteIngressConditionAttributeRestrictions(RouteIngressCondition routeIngressConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeIngressConditionAttributeRestrictions!=null){ this.attributeRestrictions= new RouteIngressConditionBuilder(routeIngressConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictionsLike(RouteIngressCondition item) {
    return new PolicyRuleFluentImpl.RouteIngressConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withNewRouteIngressConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withRouteIngressConditionAttributeRestrictions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withCustomDeploymentStrategyParamsAttributeRestrictions(CustomDeploymentStrategyParams customDeploymentStrategyParamsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (customDeploymentStrategyParamsAttributeRestrictions!=null){ this.attributeRestrictions= new CustomDeploymentStrategyParamsBuilder(customDeploymentStrategyParamsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictionsLike(CustomDeploymentStrategyParams item) {
    return new PolicyRuleFluentImpl.CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl(item);
  }
  public A withImageImportSpecAttributeRestrictions(ImageImportSpec imageImportSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageImportSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageImportSpecBuilder(imageImportSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictionsLike(ImageImportSpec item) {
    return new PolicyRuleFluentImpl.ImageImportSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withStageInfoAttributeRestrictions(StageInfo stageInfoAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (stageInfoAttributeRestrictions!=null){ this.attributeRestrictions= new StageInfoBuilder(stageInfoAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictions() {
    return new PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictionsLike(StageInfo item) {
    return new PolicyRuleFluentImpl.StageInfoAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionSpecAttributeRestrictions(RoleBindingRestrictionSpec roleBindingRestrictionSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionSpecAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionSpecBuilder(roleBindingRestrictionSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictionsLike(RoleBindingRestrictionSpec item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withIDRangeAttributeRestrictions(IDRange iDRangeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (iDRangeAttributeRestrictions!=null){ this.attributeRestrictions= new IDRangeBuilder(iDRangeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictionsLike(IDRange item) {
    return new PolicyRuleFluentImpl.IDRangeAttributeRestrictionsNestedImpl(item);
  }
  public A withNewIDRangeAttributeRestrictions(Long max,Long min) {
    return (A)withIDRangeAttributeRestrictions(new IDRange(max, min));
  }
  public A withUserListAttributeRestrictions(UserList userListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userListAttributeRestrictions!=null){ this.attributeRestrictions= new UserListBuilder(userListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictionsLike(UserList item) {
    return new PolicyRuleFluentImpl.UserListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigSpecAttributeRestrictions(BuildConfigSpec buildConfigSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigSpecAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigSpecBuilder(buildConfigSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictionsLike(BuildConfigSpec item) {
    return new PolicyRuleFluentImpl.BuildConfigSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withUserAttributeRestrictions(User userAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userAttributeRestrictions!=null){ this.attributeRestrictions= new UserBuilder(userAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item) {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImageAttributeRestrictions(ImageStreamImage imageStreamImageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImageBuilder(imageStreamImageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item) {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildStatusOutputToAttributeRestrictions(BuildStatusOutputTo buildStatusOutputToAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildStatusOutputToAttributeRestrictions!=null){ this.attributeRestrictions= new BuildStatusOutputToBuilder(buildStatusOutputToAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictionsLike(BuildStatusOutputTo item) {
    return new PolicyRuleFluentImpl.BuildStatusOutputToAttributeRestrictionsNestedImpl(item);
  }
  public A withNewBuildStatusOutputToAttributeRestrictions(String imageDigest) {
    return (A)withBuildStatusOutputToAttributeRestrictions(new BuildStatusOutputTo(imageDigest));
  }
  public A withBuildConditionAttributeRestrictions(BuildCondition buildConditionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConditionAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConditionBuilder(buildConditionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictionsLike(BuildCondition item) {
    return new PolicyRuleFluentImpl.BuildConditionAttributeRestrictionsNestedImpl(item);
  }
  public A withResourceAccessReviewResponseAttributeRestrictions(ResourceAccessReviewResponse resourceAccessReviewResponseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (resourceAccessReviewResponseAttributeRestrictions!=null){ this.attributeRestrictions= new ResourceAccessReviewResponseBuilder(resourceAccessReviewResponseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictionsLike(ResourceAccessReviewResponse item) {
    return new PolicyRuleFluentImpl.ResourceAccessReviewResponseAttributeRestrictionsNestedImpl(item);
  }
  public A withExecNewPodHookAttributeRestrictions(ExecNewPodHook execNewPodHookAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (execNewPodHookAttributeRestrictions!=null){ this.attributeRestrictions= new ExecNewPodHookBuilder(execNewPodHookAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictionsLike(ExecNewPodHook item) {
    return new PolicyRuleFluentImpl.ExecNewPodHookAttributeRestrictionsNestedImpl(item);
  }
  public A withSecretSpecAttributeRestrictions(SecretSpec secretSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (secretSpecAttributeRestrictions!=null){ this.attributeRestrictions= new SecretSpecBuilder(secretSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictionsLike(SecretSpec item) {
    return new PolicyRuleFluentImpl.SecretSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingListAttributeRestrictions(ClusterRoleBindingList clusterRoleBindingListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingListBuilder(clusterRoleBindingListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictionsLike(ClusterRoleBindingList item) {
    return new PolicyRuleFluentImpl.ClusterRoleBindingListAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyPeerAttributeRestrictions(EgressNetworkPolicyPeer egressNetworkPolicyPeerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyPeerAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyPeerBuilder(egressNetworkPolicyPeerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictionsLike(EgressNetworkPolicyPeer item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewEgressNetworkPolicyPeerAttributeRestrictions(String cidrSelector,String dnsName) {
    return (A)withEgressNetworkPolicyPeerAttributeRestrictions(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  public A withTemplateInstanceAttributeRestrictions(TemplateInstance templateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceBuilder(templateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(TemplateInstance item) {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withWebHookTriggerAttributeRestrictions(WebHookTrigger webHookTriggerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (webHookTriggerAttributeRestrictions!=null){ this.attributeRestrictions= new WebHookTriggerBuilder(webHookTriggerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictionsLike(WebHookTrigger item) {
    return new PolicyRuleFluentImpl.WebHookTriggerAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountReferenceAttributeRestrictions(ServiceAccountReference serviceAccountReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountReferenceBuilder(serviceAccountReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictionsLike(ServiceAccountReference item) {
    return new PolicyRuleFluentImpl.ServiceAccountReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withNewServiceAccountReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withServiceAccountReferenceAttributeRestrictions(new ServiceAccountReference(name, namespace));
  }
  public A withBuildAttributeRestrictions(Build buildAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildAttributeRestrictions!=null){ this.attributeRestrictions= new BuildBuilder(buildAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item) {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionBuilder(roleBindingRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withTagImportPolicyAttributeRestrictions(TagImportPolicy tagImportPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (tagImportPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new TagImportPolicyBuilder(tagImportPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictionsLike(TagImportPolicy item) {
    return new PolicyRuleFluentImpl.TagImportPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNewTagImportPolicyAttributeRestrictions(Boolean insecure,Boolean scheduled) {
    return (A)withTagImportPolicyAttributeRestrictions(new TagImportPolicy(insecure, scheduled));
  }
  public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagBuilder(imageStreamTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item) {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildTriggerPolicyAttributeRestrictions(BuildTriggerPolicy buildTriggerPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildTriggerPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new BuildTriggerPolicyBuilder(buildTriggerPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictionsLike(BuildTriggerPolicy item) {
    return new PolicyRuleFluentImpl.BuildTriggerPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withRoutePortAttributeRestrictions(RoutePort routePortAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routePortAttributeRestrictions!=null){ this.attributeRestrictions= new RoutePortBuilder(routePortAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictionsLike(RoutePort item) {
    return new PolicyRuleFluentImpl.RoutePortAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceRequesterAttributeRestrictions(TemplateInstanceRequester templateInstanceRequesterAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceRequesterAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceRequesterBuilder(templateInstanceRequesterAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictionsLike(TemplateInstanceRequester item) {
    return new PolicyRuleFluentImpl.TemplateInstanceRequesterAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupAttributeRestrictions(Group groupAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupAttributeRestrictions!=null){ this.attributeRestrictions= new GroupBuilder(groupAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item) {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildTriggerCauseAttributeRestrictions(BuildTriggerCause buildTriggerCauseAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildTriggerCauseAttributeRestrictions!=null){ this.attributeRestrictions= new BuildTriggerCauseBuilder(buildTriggerCauseAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictionsLike(BuildTriggerCause item) {
    return new PolicyRuleFluentImpl.BuildTriggerCauseAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSignatureAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSignatureBuilder(imageSignatureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item) {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryStatusAttributeRestrictions(HelmChartRepositoryStatus helmChartRepositoryStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryStatusAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryStatusBuilder(helmChartRepositoryStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictionsLike(HelmChartRepositoryStatus item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigSpecAttributeRestrictions(DeploymentConfigSpec deploymentConfigSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigSpecAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigSpecBuilder(deploymentConfigSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictionsLike(DeploymentConfigSpec item) {
    return new PolicyRuleFluentImpl.DeploymentConfigSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withHostSubnetAttributeRestrictions(HostSubnet hostSubnetAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetAttributeRestrictions!=null){ this.attributeRestrictions= new HostSubnetBuilder(hostSubnetAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(HostSubnet item) {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupRestrictionAttributeRestrictions(GroupRestriction groupRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new GroupRestrictionBuilder(groupRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictionsLike(GroupRestriction item) {
    return new PolicyRuleFluentImpl.GroupRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaAttributeRestrictions(AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenListAttributeRestrictions(OAuthAccessTokenList oAuthAccessTokenListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenListAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenListBuilder(oAuthAccessTokenListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictionsLike(OAuthAccessTokenList item) {
    return new PolicyRuleFluentImpl.OAuthAccessTokenListAttributeRestrictionsNestedImpl(item);
  }
  public A withJenkinsPipelineBuildStrategyAttributeRestrictions(JenkinsPipelineBuildStrategy jenkinsPipelineBuildStrategyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (jenkinsPipelineBuildStrategyAttributeRestrictions!=null){ this.attributeRestrictions= new JenkinsPipelineBuildStrategyBuilder(jenkinsPipelineBuildStrategyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictionsLike(JenkinsPipelineBuildStrategy item) {
    return new PolicyRuleFluentImpl.JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl(item);
  }
  public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsBuilder(securityContextConstraintsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item) {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl(item);
  }
  public A withSupplementalGroupsStrategyOptionsAttributeRestrictions(SupplementalGroupsStrategyOptions supplementalGroupsStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (supplementalGroupsStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroupsStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictionsLike(SupplementalGroupsStrategyOptions item) {
    return new PolicyRuleFluentImpl.SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions(ServiceAccountPodSecurityPolicyReviewStatus serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ServiceAccountPodSecurityPolicyReviewStatusBuilder(serviceAccountPodSecurityPolicyReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new PolicyRuleFluentImpl.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildRequestAttributeRestrictions!=null){ this.attributeRestrictions= new BuildRequestBuilder(buildRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item) {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withSELinuxContextStrategyOptionsAttributeRestrictions(SELinuxContextStrategyOptions sELinuxContextStrategyOptionsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sELinuxContextStrategyOptionsAttributeRestrictions!=null){ this.attributeRestrictions= new SELinuxContextStrategyOptionsBuilder(sELinuxContextStrategyOptionsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictionsLike(SELinuxContextStrategyOptions item) {
    return new PolicyRuleFluentImpl.SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleListAttributeRestrictions(ClusterRoleList clusterRoleListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleListAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleListBuilder(clusterRoleListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictionsLike(ClusterRoleList item) {
    return new PolicyRuleFluentImpl.ClusterRoleListAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteListAttributeRestrictions(RouteList routeListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeListAttributeRestrictions!=null){ this.attributeRestrictions= new RouteListBuilder(routeListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictionsLike(RouteList item) {
    return new PolicyRuleFluentImpl.RouteListAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamStatusAttributeRestrictions(ImageStreamStatus imageStreamStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamStatusAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamStatusBuilder(imageStreamStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictionsLike(ImageStreamStatus item) {
    return new PolicyRuleFluentImpl.ImageStreamStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyAttributeRestrictions(EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyBuilder(egressNetworkPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceBuilder(netNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item) {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withUserIdentityMappingAttributeRestrictions(UserIdentityMapping userIdentityMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userIdentityMappingAttributeRestrictions!=null){ this.attributeRestrictions= new UserIdentityMappingBuilder(userIdentityMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(UserIdentityMapping item) {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentDetailsAttributeRestrictions(DeploymentDetails deploymentDetailsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentDetailsAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentDetailsBuilder(deploymentDetailsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictionsLike(DeploymentDetails item) {
    return new PolicyRuleFluentImpl.DeploymentDetailsAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewStatusAttributeRestrictions(PodSecurityPolicySubjectReviewStatus podSecurityPolicySubjectReviewStatusAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewStatusAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewStatusBuilder(podSecurityPolicySubjectReviewStatusAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictionsLike(PodSecurityPolicySubjectReviewStatus item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl(item);
  }
  public A withPodSecurityPolicySubjectReviewSpecAttributeRestrictions(PodSecurityPolicySubjectReviewSpec podSecurityPolicySubjectReviewSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (podSecurityPolicySubjectReviewSpecAttributeRestrictions!=null){ this.attributeRestrictions= new PodSecurityPolicySubjectReviewSpecBuilder(podSecurityPolicySubjectReviewSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySubjectReviewSpec item) {
    return new PolicyRuleFluentImpl.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamBuilder(imageStreamAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item) {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildListAttributeRestrictions(BuildList buildListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildListAttributeRestrictions!=null){ this.attributeRestrictions= new BuildListBuilder(buildListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictionsLike(BuildList item) {
    return new PolicyRuleFluentImpl.BuildListAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateListAttributeRestrictions(TemplateList templateListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateListAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateListBuilder(templateListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictionsLike(TemplateList item) {
    return new PolicyRuleFluentImpl.TemplateListAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildOutputAttributeRestrictions(BuildOutput buildOutputAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildOutputAttributeRestrictions!=null){ this.attributeRestrictions= new BuildOutputBuilder(buildOutputAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictionsLike(BuildOutput item) {
    return new PolicyRuleFluentImpl.BuildOutputAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectSpecAttributeRestrictions(ProjectSpec projectSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectSpecBuilder(projectSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictionsLike(ProjectSpec item) {
    return new PolicyRuleFluentImpl.ProjectSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withSourceRevisionAttributeRestrictions(SourceRevision sourceRevisionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (sourceRevisionAttributeRestrictions!=null){ this.attributeRestrictions= new SourceRevisionBuilder(sourceRevisionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictionsLike(SourceRevision item) {
    return new PolicyRuleFluentImpl.SourceRevisionAttributeRestrictionsNestedImpl(item);
  }
  public A withObjectReferenceAttributeRestrictions(ObjectReference objectReferenceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (objectReferenceAttributeRestrictions!=null){ this.attributeRestrictions= new ObjectReferenceBuilder(objectReferenceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictionsLike(ObjectReference item) {
    return new PolicyRuleFluentImpl.ObjectReferenceAttributeRestrictionsNestedImpl(item);
  }
  public A withSignatureIssuerAttributeRestrictions(SignatureIssuer signatureIssuerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (signatureIssuerAttributeRestrictions!=null){ this.attributeRestrictions= new SignatureIssuerBuilder(signatureIssuerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictionsLike(SignatureIssuer item) {
    return new PolicyRuleFluentImpl.SignatureIssuerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewSignatureIssuerAttributeRestrictions(String commonName,String organization) {
    return (A)withSignatureIssuerAttributeRestrictions(new SignatureIssuer(commonName, organization));
  }
  public A withImageLayerAttributeRestrictions(ImageLayer imageLayerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageLayerAttributeRestrictions!=null){ this.attributeRestrictions= new ImageLayerBuilder(imageLayerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictionsLike(ImageLayer item) {
    return new PolicyRuleFluentImpl.ImageLayerAttributeRestrictionsNestedImpl(item);
  }
  public A withNewImageLayerAttributeRestrictions(String mediaType,String name,Long size) {
    return (A)withImageLayerAttributeRestrictions(new ImageLayer(mediaType, name, size));
  }
  public A withClusterResourceQuotaSpecAttributeRestrictions(ClusterResourceQuotaSpec clusterResourceQuotaSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaSpecBuilder(clusterResourceQuotaSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictionsLike(ClusterResourceQuotaSpec item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamSpecAttributeRestrictions(ImageStreamSpec imageStreamSpecAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamSpecAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamSpecBuilder(imageStreamSpecAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictionsLike(ImageStreamSpec item) {
    return new PolicyRuleFluentImpl.ImageStreamSpecAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteIngressAttributeRestrictions(RouteIngress routeIngressAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeIngressAttributeRestrictions!=null){ this.attributeRestrictions= new RouteIngressBuilder(routeIngressAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictionsLike(RouteIngress item) {
    return new PolicyRuleFluentImpl.RouteIngressAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientBuilder(oAuthClientAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item) {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityBuilder(identityAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item) {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationListAttributeRestrictions(RangeAllocationList rangeAllocationListAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationListAttributeRestrictions!=null){ this.attributeRestrictions= new RangeAllocationListBuilder(rangeAllocationListAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictionsLike(RangeAllocationList item) {
    return new PolicyRuleFluentImpl.RangeAllocationListAttributeRestrictionsNestedImpl(item);
  }
  public A addToNonResourceURLs(Integer index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.add(index, item);
    return (A)this;
  }
  public A setToNonResourceURLs(Integer index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.set(index, item); return (A)this;
  }
  public A addToNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A addAllToNonResourceURLs(Collection<String> items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A removeFromNonResourceURLs(java.lang.String... items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public A removeAllFromNonResourceURLs(Collection<String> items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public List<String> getNonResourceURLs() {
    return this.nonResourceURLs;
  }
  public String getNonResourceURL(Integer index) {
    return this.nonResourceURLs.get(index);
  }
  public String getFirstNonResourceURL() {
    return this.nonResourceURLs.get(0);
  }
  public String getLastNonResourceURL() {
    return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
  }
  public String getMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceURLs(List<String> nonResourceURLs) {
    if (nonResourceURLs != null) {this.nonResourceURLs = new ArrayList(); for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
  }
  public A withNonResourceURLs(java.lang.String... nonResourceURLs) {
    if (this.nonResourceURLs != null) {this.nonResourceURLs.clear();}
    if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
  }
  public Boolean hasNonResourceURLs() {
    return nonResourceURLs != null && !nonResourceURLs.isEmpty();
  }
  public A addToResourceNames(Integer index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.add(index, item);
    return (A)this;
  }
  public A setToResourceNames(Integer index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.set(index, item); return (A)this;
  }
  public A addToResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A addAllToResourceNames(Collection<String> items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A removeFromResourceNames(java.lang.String... items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public A removeAllFromResourceNames(Collection<String> items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public List<String> getResourceNames() {
    return this.resourceNames;
  }
  public String getResourceName(Integer index) {
    return this.resourceNames.get(index);
  }
  public String getFirstResourceName() {
    return this.resourceNames.get(0);
  }
  public String getLastResourceName() {
    return this.resourceNames.get(resourceNames.size() - 1);
  }
  public String getMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceNames(List<String> resourceNames) {
    if (resourceNames != null) {this.resourceNames = new ArrayList(); for (String item : resourceNames){this.addToResourceNames(item);}} else { this.resourceNames = null;} return (A) this;
  }
  public A withResourceNames(java.lang.String... resourceNames) {
    if (this.resourceNames != null) {this.resourceNames.clear();}
    if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
  }
  public Boolean hasResourceNames() {
    return resourceNames != null && !resourceNames.isEmpty();
  }
  public A addToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(Integer index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToVerbs(Integer index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  public A setToVerbs(Integer index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.set(index, item); return (A)this;
  }
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A addAllToVerbs(Collection<String> items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A removeFromVerbs(java.lang.String... items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public A removeAllFromVerbs(Collection<String> items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public List<String> getVerbs() {
    return this.verbs;
  }
  public String getVerb(Integer index) {
    return this.verbs.get(index);
  }
  public String getFirstVerb() {
    return this.verbs.get(0);
  }
  public String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  public String getMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerbs(List<String> verbs) {
    if (verbs != null) {this.verbs = new ArrayList(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
  }
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {this.verbs.clear();}
    if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
  }
  public Boolean hasVerbs() {
    return verbs != null && !verbs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
    if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
    if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
    if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
    if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  attributeRestrictions,  nonResourceURLs,  resourceNames,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (attributeRestrictions != null) { sb.append("attributeRestrictions:"); sb.append(attributeRestrictions + ","); }
    if (nonResourceURLs != null && !nonResourceURLs.isEmpty()) { sb.append("nonResourceURLs:"); sb.append(nonResourceURLs + ","); }
    if (resourceNames != null && !resourceNames.isEmpty()) { sb.append("resourceNames:"); sb.append(resourceNames + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class GenericWebHookCauseAttributeRestrictionsNestedImpl<N> extends GenericWebHookCauseFluentImpl<PolicyRuleFluent.GenericWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GenericWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GenericWebHookCauseAttributeRestrictionsNestedImpl(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GenericWebHookCauseBuilder(this);
    }
    GenericWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGenericWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountRestrictionAttributeRestrictionsNestedImpl<N> extends ServiceAccountRestrictionFluentImpl<PolicyRuleFluent.ServiceAccountRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ServiceAccountRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountRestrictionAttributeRestrictionsNestedImpl(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountRestrictionBuilder(this);
    }
    ServiceAccountRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class ScopeRestrictionAttributeRestrictionsNestedImpl<N> extends ScopeRestrictionFluentImpl<PolicyRuleFluent.ScopeRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ScopeRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ScopeRestrictionAttributeRestrictionsNestedImpl(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ScopeRestrictionBuilder(this);
    }
    ScopeRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretLocalReferenceAttributeRestrictionsNestedImpl<N> extends SecretLocalReferenceFluentImpl<PolicyRuleFluent.SecretLocalReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecretLocalReferenceAttributeRestrictionsNested<N>,Nested<N>{
    SecretLocalReferenceAttributeRestrictionsNestedImpl(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new SecretLocalReferenceBuilder(this);
    }
    SecretLocalReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretLocalReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class StepInfoAttributeRestrictionsNestedImpl<N> extends StepInfoFluentImpl<PolicyRuleFluent.StepInfoAttributeRestrictionsNested<N>> implements PolicyRuleFluent.StepInfoAttributeRestrictionsNested<N>,Nested<N>{
    StepInfoAttributeRestrictionsNestedImpl(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoAttributeRestrictionsNestedImpl() {
      this.builder = new StepInfoBuilder(this);
    }
    StepInfoBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endStepInfoAttributeRestrictions() {
      return and();
    }
    
  }
  class UserRestrictionAttributeRestrictionsNestedImpl<N> extends UserRestrictionFluentImpl<PolicyRuleFluent.UserRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    UserRestrictionAttributeRestrictionsNestedImpl(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new UserRestrictionBuilder(this);
    }
    UserRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class PodTemplateSpecAttributeRestrictionsNestedImpl<N> extends PodTemplateSpecFluentImpl<PolicyRuleFluent.PodTemplateSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodTemplateSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodTemplateSpecAttributeRestrictionsNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodTemplateSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceListAttributeRestrictionsNestedImpl<N> extends TemplateInstanceListFluentImpl<PolicyRuleFluent.TemplateInstanceListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceListAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceListAttributeRestrictionsNestedImpl(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceListBuilder(this);
    }
    TemplateInstanceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportAttributeRestrictionsNestedImpl<N> extends ImageStreamImportFluentImpl<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportAttributeRestrictionsNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceRequirementsAttributeRestrictionsNestedImpl<N> extends ResourceRequirementsFluentImpl<PolicyRuleFluent.ResourceRequirementsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ResourceRequirementsAttributeRestrictionsNested<N>,Nested<N>{
    ResourceRequirementsAttributeRestrictionsNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceRequirementsAttributeRestrictions() {
      return and();
    }
    
  }
  class GitHubWebHookCauseAttributeRestrictionsNestedImpl<N> extends GitHubWebHookCauseFluentImpl<PolicyRuleFluent.GitHubWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GitHubWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GitHubWebHookCauseAttributeRestrictionsNestedImpl(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GitHubWebHookCauseBuilder(this);
    }
    GitHubWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitHubWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientListAttributeRestrictionsNestedImpl<N> extends OAuthClientListFluentImpl<PolicyRuleFluent.OAuthClientListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientListAttributeRestrictionsNestedImpl(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientListBuilder(this);
    }
    OAuthClientListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientListAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewStatusFluentImpl<PolicyRuleFluent.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceStatusAttributeRestrictionsNestedImpl<N> extends TemplateInstanceStatusFluentImpl<PolicyRuleFluent.TemplateInstanceStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceStatusAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceStatusAttributeRestrictionsNestedImpl(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceStatusBuilder(this);
    }
    TemplateInstanceStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryListAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryListFluentImpl<PolicyRuleFluent.HelmChartRepositoryListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HelmChartRepositoryListAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryListAttributeRestrictionsNestedImpl(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryListBuilder(this);
    }
    HelmChartRepositoryListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryListAttributeRestrictions() {
      return and();
    }
    
  }
  class PolicyRuleAttributeRestrictionsNestedImpl<N> extends PolicyRuleFluentImpl<PolicyRuleFluent.PolicyRuleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PolicyRuleAttributeRestrictionsNested<N>,Nested<N>{
    PolicyRuleAttributeRestrictionsNestedImpl(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleAttributeRestrictionsNestedImpl() {
      this.builder = new PolicyRuleBuilder(this);
    }
    PolicyRuleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentTriggerPolicyAttributeRestrictionsNestedImpl<N> extends DeploymentTriggerPolicyFluentImpl<PolicyRuleFluent.DeploymentTriggerPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentTriggerPolicyAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentTriggerPolicyAttributeRestrictionsNestedImpl(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentTriggerPolicyBuilder(this);
    }
    DeploymentTriggerPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStrategyAttributeRestrictionsNestedImpl<N> extends BuildStrategyFluentImpl<PolicyRuleFluent.BuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    BuildStrategyAttributeRestrictionsNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class RepositoryImportSpecAttributeRestrictionsNestedImpl<N> extends RepositoryImportSpecFluentImpl<PolicyRuleFluent.RepositoryImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RepositoryImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    RepositoryImportSpecAttributeRestrictionsNestedImpl(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RepositoryImportSpecBuilder(this);
    }
    RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRepositoryImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceListAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceListFluentImpl<PolicyRuleFluent.BrokerTemplateInstanceListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BrokerTemplateInstanceListAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceListAttributeRestrictionsNestedImpl(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceListBuilder(this);
    }
    BrokerTemplateInstanceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportStatusAttributeRestrictionsNestedImpl<N> extends ImageStreamImportStatusFluentImpl<PolicyRuleFluent.ImageStreamImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportStatusAttributeRestrictionsNestedImpl(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportStatusBuilder(this);
    }
    ImageStreamImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class CustomBuildStrategyAttributeRestrictionsNestedImpl<N> extends CustomBuildStrategyFluentImpl<PolicyRuleFluent.CustomBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.CustomBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    CustomBuildStrategyAttributeRestrictionsNestedImpl(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new CustomBuildStrategyBuilder(this);
    }
    CustomBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endCustomBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaSelectorFluentImpl<PolicyRuleFluent.ClusterResourceQuotaSelectorAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaSelectorAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaSelectorAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectAccessReviewResponseAttributeRestrictionsNestedImpl<N> extends SubjectAccessReviewResponseFluentImpl<PolicyRuleFluent.SubjectAccessReviewResponseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SubjectAccessReviewResponseAttributeRestrictionsNested<N>,Nested<N>{
    SubjectAccessReviewResponseAttributeRestrictionsNestedImpl(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectAccessReviewResponseBuilder(this);
    }
    SubjectAccessReviewResponseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl<N> extends DeploymentTriggerImageChangeParamsFluentImpl<PolicyRuleFluent.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentTriggerImageChangeParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalObjectReferenceAttributeRestrictionsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PolicyRuleFluent.LocalObjectReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.LocalObjectReferenceAttributeRestrictionsNested<N>,Nested<N>{
    LocalObjectReferenceAttributeRestrictionsNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class TagImageHookAttributeRestrictionsNestedImpl<N> extends TagImageHookFluentImpl<PolicyRuleFluent.TagImageHookAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagImageHookAttributeRestrictionsNested<N>,Nested<N>{
    TagImageHookAttributeRestrictionsNestedImpl(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookAttributeRestrictionsNestedImpl() {
      this.builder = new TagImageHookBuilder(this);
    }
    TagImageHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagImageHookAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteTargetReferenceAttributeRestrictionsNestedImpl<N> extends RouteTargetReferenceFluentImpl<PolicyRuleFluent.RouteTargetReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteTargetReferenceAttributeRestrictionsNested<N>,Nested<N>{
    RouteTargetReferenceAttributeRestrictionsNestedImpl(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteTargetReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class OpenshiftRawExtensionAttributeRestrictionsNestedImpl<N> extends io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl<PolicyRuleFluent.OpenshiftRawExtensionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OpenshiftRawExtensionAttributeRestrictionsNested<N>,Nested<N>{
    OpenshiftRawExtensionAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.runtime.RawExtension item) {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this, item);
    }
    OpenshiftRawExtensionAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this);
    }
    io.fabric8.openshift.api.model.runtime.RawExtensionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOpenshiftRawExtensionAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewSpecAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewSpecFluentImpl<PolicyRuleFluent.SubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SubjectRulesReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewSpecAttributeRestrictionsNestedImpl(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewSpecBuilder(this);
    }
    SubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class TagReferencePolicyAttributeRestrictionsNestedImpl<N> extends TagReferencePolicyFluentImpl<PolicyRuleFluent.TagReferencePolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagReferencePolicyAttributeRestrictionsNested<N>,Nested<N>{
    TagReferencePolicyAttributeRestrictionsNestedImpl(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyAttributeRestrictionsNestedImpl() {
      this.builder = new TagReferencePolicyBuilder(this);
    }
    TagReferencePolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagReferencePolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleListAttributeRestrictionsNestedImpl<N> extends RoleListFluentImpl<PolicyRuleFluent.RoleListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleListAttributeRestrictionsNested<N>,Nested<N>{
    RoleListAttributeRestrictionsNestedImpl(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleListBuilder(this);
    }
    RoleListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleListAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectAttributeRestrictionsNestedImpl<N> extends ProjectFluentImpl<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>,Nested<N>{
    ProjectAttributeRestrictionsNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeSourceAttributeRestrictionsNestedImpl<N> extends BuildVolumeSourceFluentImpl<PolicyRuleFluent.BuildVolumeSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildVolumeSourceAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeSourceAttributeRestrictionsNestedImpl(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeSourceBuilder(this);
    }
    BuildVolumeSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaListFluentImpl<PolicyRuleFluent.AppliedClusterResourceQuotaListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.AppliedClusterResourceQuotaListAttributeRestrictionsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListAttributeRestrictionsNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigListAttributeRestrictionsNestedImpl<N> extends DeploymentConfigListFluentImpl<PolicyRuleFluent.DeploymentConfigListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigListAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigListAttributeRestrictionsNestedImpl(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigListBuilder(this);
    }
    DeploymentConfigListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusOutputAttributeRestrictionsNestedImpl<N> extends BuildStatusOutputFluentImpl<PolicyRuleFluent.BuildStatusOutputAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildStatusOutputAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusOutputAttributeRestrictionsNestedImpl(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusOutputBuilder(this);
    }
    BuildStatusOutputBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusOutputAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigAttributeRestrictionsNestedImpl<N> extends BuildConfigFluentImpl<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigAttributeRestrictionsNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageImportStatusAttributeRestrictionsNestedImpl<N> extends ImageImportStatusFluentImpl<PolicyRuleFluent.ImageImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageImportStatusAttributeRestrictionsNestedImpl(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewFluentImpl<PolicyRuleFluent.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class GitLabWebHookCauseAttributeRestrictionsNestedImpl<N> extends GitLabWebHookCauseFluentImpl<PolicyRuleFluent.GitLabWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GitLabWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    GitLabWebHookCauseAttributeRestrictionsNestedImpl(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new GitLabWebHookCauseBuilder(this);
    }
    GitLabWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitLabWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigStatusAttributeRestrictionsNestedImpl<N> extends DeploymentConfigStatusFluentImpl<PolicyRuleFluent.DeploymentConfigStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigStatusAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigStatusAttributeRestrictionsNestedImpl(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigStatusBuilder(this);
    }
    DeploymentConfigStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretBuildSourceAttributeRestrictionsNestedImpl<N> extends SecretBuildSourceFluentImpl<PolicyRuleFluent.SecretBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecretBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    SecretBuildSourceAttributeRestrictionsNestedImpl(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new SecretBuildSourceBuilder(this);
    }
    SecretBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicySpecAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicySpecFluentImpl<PolicyRuleFluent.EgressNetworkPolicySpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicySpecAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicySpecAttributeRestrictionsNestedImpl(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicySpecBuilder(this);
    }
    EgressNetworkPolicySpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicySpecAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryFluentImpl<PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryAttributeRestrictionsNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  }
  class TagEventAttributeRestrictionsNestedImpl<N> extends TagEventFluentImpl<PolicyRuleFluent.TagEventAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagEventAttributeRestrictionsNested<N>,Nested<N>{
    TagEventAttributeRestrictionsNestedImpl(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventAttributeRestrictionsNestedImpl() {
      this.builder = new TagEventBuilder(this);
    }
    TagEventBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagEventAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagListAttributeRestrictionsNestedImpl<N> extends ImageStreamTagListFluentImpl<PolicyRuleFluent.ImageStreamTagListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamTagListAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagListAttributeRestrictionsNestedImpl(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagListBuilder(this);
    }
    ImageStreamTagListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagListAttributeRestrictions() {
      return and();
    }
    
  }
  class BitbucketWebHookCauseAttributeRestrictionsNestedImpl<N> extends BitbucketWebHookCauseFluentImpl<PolicyRuleFluent.BitbucketWebHookCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BitbucketWebHookCauseAttributeRestrictionsNested<N>,Nested<N>{
    BitbucketWebHookCauseAttributeRestrictionsNestedImpl(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseAttributeRestrictionsNestedImpl() {
      this.builder = new BitbucketWebHookCauseBuilder(this);
    }
    BitbucketWebHookCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBitbucketWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectListAttributeRestrictionsNestedImpl<N> extends ProjectListFluentImpl<PolicyRuleFluent.ProjectListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectListAttributeRestrictionsNested<N>,Nested<N>{
    ProjectListAttributeRestrictionsNestedImpl(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectListBuilder(this);
    }
    ProjectListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectListAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationAttributeRestrictionsNestedImpl<N> extends RangeAllocationFluentImpl<PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>,Nested<N>{
    RangeAllocationAttributeRestrictionsNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationAttributeRestrictionsNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<PolicyRuleFluent.ClusterRoleScopeRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleScopeRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteAttributeRestrictionsNestedImpl<N> extends RouteFluentImpl<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteAttributeRestrictionsNested<N>,Nested<N>{
    RouteAttributeRestrictionsNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteAttributeRestrictionsNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SourceStrategyOptionsFluentImpl<PolicyRuleFluent.SourceStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SourceStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SourceStrategyOptionsAttributeRestrictionsNestedImpl(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SourceStrategyOptionsBuilder(this);
    }
    SourceStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkAttributeRestrictionsNestedImpl<N> extends ClusterNetworkFluentImpl<PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkAttributeRestrictionsNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DockerBuildStrategyAttributeRestrictionsNestedImpl<N> extends DockerBuildStrategyFluentImpl<PolicyRuleFluent.DockerBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DockerBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    DockerBuildStrategyAttributeRestrictionsNestedImpl(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new DockerBuildStrategyBuilder(this);
    }
    DockerBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDockerBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureConditionAttributeRestrictionsNestedImpl<N> extends SignatureConditionFluentImpl<PolicyRuleFluent.SignatureConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SignatureConditionAttributeRestrictionsNested<N>,Nested<N>{
    SignatureConditionAttributeRestrictionsNestedImpl(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureConditionBuilder(this);
    }
    SignatureConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionListAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionListFluentImpl<PolicyRuleFluent.RoleBindingRestrictionListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingRestrictionListAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionListAttributeRestrictionsNestedImpl(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionListBuilder(this);
    }
    RoleBindingRestrictionListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionListAttributeRestrictions() {
      return and();
    }
    
  }
  class RawExtensionAttributeRestrictionsNestedImpl<N> extends RawExtensionFluentImpl<PolicyRuleFluent.RawExtensionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RawExtensionAttributeRestrictionsNested<N>,Nested<N>{
    RawExtensionAttributeRestrictionsNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionAttributeRestrictionsNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRawExtensionAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsListAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsListFluentImpl<PolicyRuleFluent.SecurityContextConstraintsListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecurityContextConstraintsListAttributeRestrictionsNested<N>,Nested<N>{
    SecurityContextConstraintsListAttributeRestrictionsNestedImpl(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListAttributeRestrictionsNestedImpl() {
      this.builder = new SecurityContextConstraintsListBuilder(this);
    }
    SecurityContextConstraintsListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsListAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityListAttributeRestrictionsNestedImpl<N> extends IdentityListFluentImpl<PolicyRuleFluent.IdentityListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.IdentityListAttributeRestrictionsNested<N>,Nested<N>{
    IdentityListAttributeRestrictionsNestedImpl(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListAttributeRestrictionsNestedImpl() {
      this.builder = new IdentityListBuilder(this);
    }
    IdentityListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigListAttributeRestrictionsNestedImpl<N> extends BuildConfigListFluentImpl<PolicyRuleFluent.BuildConfigListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigListAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigListAttributeRestrictionsNestedImpl(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigListBuilder(this);
    }
    BuildConfigListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkListAttributeRestrictionsNestedImpl<N> extends ClusterNetworkListFluentImpl<PolicyRuleFluent.ClusterNetworkListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterNetworkListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkListAttributeRestrictionsNestedImpl(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkListBuilder(this);
    }
    ClusterNetworkListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkListAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceConditionAttributeRestrictionsNestedImpl<N> extends TemplateInstanceConditionFluentImpl<PolicyRuleFluent.TemplateInstanceConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceConditionAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceConditionAttributeRestrictionsNestedImpl(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceConditionBuilder(this);
    }
    TemplateInstanceConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class RepositoryImportStatusAttributeRestrictionsNestedImpl<N> extends RepositoryImportStatusFluentImpl<PolicyRuleFluent.RepositoryImportStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RepositoryImportStatusAttributeRestrictionsNested<N>,Nested<N>{
    RepositoryImportStatusAttributeRestrictionsNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusAttributeRestrictionsNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRepositoryImportStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentCauseAttributeRestrictionsNestedImpl<N> extends DeploymentCauseFluentImpl<PolicyRuleFluent.DeploymentCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentCauseAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentCauseAttributeRestrictionsNestedImpl(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentCauseBuilder(this);
    }
    DeploymentCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupListAttributeRestrictionsNestedImpl<N> extends GroupListFluentImpl<PolicyRuleFluent.GroupListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GroupListAttributeRestrictionsNested<N>,Nested<N>{
    GroupListAttributeRestrictionsNestedImpl(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListAttributeRestrictionsNestedImpl() {
      this.builder = new GroupListBuilder(this);
    }
    GroupListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupListAttributeRestrictions() {
      return and();
    }
    
  }
  class RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<PolicyRuleFluent.RunAsUserStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RunAsUserStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRunAsUserStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class LifecycleHookAttributeRestrictionsNestedImpl<N> extends LifecycleHookFluentImpl<PolicyRuleFluent.LifecycleHookAttributeRestrictionsNested<N>> implements PolicyRuleFluent.LifecycleHookAttributeRestrictionsNested<N>,Nested<N>{
    LifecycleHookAttributeRestrictionsNestedImpl(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookAttributeRestrictionsNestedImpl() {
      this.builder = new LifecycleHookBuilder(this);
    }
    LifecycleHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLifecycleHookAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagReferenceAttributeRestrictionsNestedImpl<N> extends ImageStreamTagReferenceFluentImpl<PolicyRuleFluent.ImageStreamTagReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamTagReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagReferenceAttributeRestrictionsNestedImpl(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagReferenceBuilder(this);
    }
    ImageStreamTagReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceControlUserAttributeRestrictionsNestedImpl<N> extends SourceControlUserFluentImpl<PolicyRuleFluent.SourceControlUserAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SourceControlUserAttributeRestrictionsNested<N>,Nested<N>{
    SourceControlUserAttributeRestrictionsNestedImpl(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserAttributeRestrictionsNestedImpl() {
      this.builder = new SourceControlUserBuilder(this);
    }
    SourceControlUserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceControlUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ContainerAttributeRestrictionsNestedImpl<N> extends ContainerFluentImpl<PolicyRuleFluent.ContainerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ContainerAttributeRestrictionsNested<N>,Nested<N>{
    ContainerAttributeRestrictionsNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerAttributeRestrictionsNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endContainerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamListAttributeRestrictionsNestedImpl<N> extends ImageStreamListFluentImpl<PolicyRuleFluent.ImageStreamListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamListAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamListAttributeRestrictionsNestedImpl(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamListBuilder(this);
    }
    ImageStreamListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingFluentImpl<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleBindingAttributeRestrictionsNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceAccessReviewAttributeRestrictionsNestedImpl<N> extends ResourceAccessReviewFluentImpl<PolicyRuleFluent.ResourceAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ResourceAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    ResourceAccessReviewAttributeRestrictionsNestedImpl(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceAccessReviewBuilder(this);
    }
    ResourceAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewAttributeRestrictionsNestedImpl<N> extends SelfSubjectRulesReviewFluentImpl<PolicyRuleFluent.SelfSubjectRulesReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SelfSubjectRulesReviewAttributeRestrictionsNested<N>,Nested<N>{
    SelfSubjectRulesReviewAttributeRestrictionsNestedImpl(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SelfSubjectRulesReviewBuilder(this);
    }
    SelfSubjectRulesReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSelfSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenListAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenListFluentImpl<PolicyRuleFluent.UserOAuthAccessTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserOAuthAccessTokenListAttributeRestrictionsNested<N>,Nested<N>{
    UserOAuthAccessTokenListAttributeRestrictionsNestedImpl(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new UserOAuthAccessTokenListBuilder(this);
    }
    UserOAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeTriggerStatusAttributeRestrictionsNestedImpl<N> extends ImageChangeTriggerStatusFluentImpl<PolicyRuleFluent.ImageChangeTriggerStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageChangeTriggerStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeTriggerStatusAttributeRestrictionsNestedImpl(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeTriggerStatusBuilder(this);
    }
    ImageChangeTriggerStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeTriggerStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteStatusAttributeRestrictionsNestedImpl<N> extends RouteStatusFluentImpl<PolicyRuleFluent.RouteStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteStatusAttributeRestrictionsNested<N>,Nested<N>{
    RouteStatusAttributeRestrictionsNestedImpl(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusAttributeRestrictionsNestedImpl() {
      this.builder = new RouteStatusBuilder(this);
    }
    RouteStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaFluentImpl<PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaAttributeRestrictionsNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class NamedTagEventListAttributeRestrictionsNestedImpl<N> extends NamedTagEventListFluentImpl<PolicyRuleFluent.NamedTagEventListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.NamedTagEventListAttributeRestrictionsNested<N>,Nested<N>{
    NamedTagEventListAttributeRestrictionsNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListAttributeRestrictionsNestedImpl() {
      this.builder = new NamedTagEventListBuilder(this);
    }
    NamedTagEventListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNamedTagEventListAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaListAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaListFluentImpl<PolicyRuleFluent.ClusterResourceQuotaListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaListAttributeRestrictionsNestedImpl(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaListBuilder(this);
    }
    ClusterResourceQuotaListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteSpecAttributeRestrictionsNestedImpl<N> extends RouteSpecFluentImpl<PolicyRuleFluent.RouteSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteSpecAttributeRestrictionsNested<N>,Nested<N>{
    RouteSpecAttributeRestrictionsNestedImpl(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RouteSpecBuilder(this);
    }
    RouteSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectRequestAttributeRestrictionsNestedImpl<N> extends ProjectRequestFluentImpl<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>,Nested<N>{
    ProjectRequestAttributeRestrictionsNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateAttributeRestrictionsNestedImpl<N> extends TemplateFluentImpl<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>,Nested<N>{
    TemplateAttributeRestrictionsNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLookupPolicyAttributeRestrictionsNestedImpl<N> extends ImageLookupPolicyFluentImpl<PolicyRuleFluent.ImageLookupPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageLookupPolicyAttributeRestrictionsNested<N>,Nested<N>{
    ImageLookupPolicyAttributeRestrictionsNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLookupPolicyBuilder(this);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLookupPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeCauseAttributeRestrictionsNestedImpl<N> extends ImageChangeCauseFluentImpl<PolicyRuleFluent.ImageChangeCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageChangeCauseAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeCauseAttributeRestrictionsNestedImpl(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeCauseBuilder(this);
    }
    ImageChangeCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class AllowedFlexVolumeAttributeRestrictionsNestedImpl<N> extends AllowedFlexVolumeFluentImpl<PolicyRuleFluent.AllowedFlexVolumeAttributeRestrictionsNested<N>> implements PolicyRuleFluent.AllowedFlexVolumeAttributeRestrictionsNested<N>,Nested<N>{
    AllowedFlexVolumeAttributeRestrictionsNestedImpl(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeAttributeRestrictionsNestedImpl() {
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAllowedFlexVolumeAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectAccessReviewAttributeRestrictionsNestedImpl<N> extends SubjectAccessReviewFluentImpl<PolicyRuleFluent.SubjectAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SubjectAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    SubjectAccessReviewAttributeRestrictionsNestedImpl(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectAccessReviewBuilder(this);
    }
    SubjectAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalResourceAccessReviewAttributeRestrictionsNestedImpl<N> extends LocalResourceAccessReviewFluentImpl<PolicyRuleFluent.LocalResourceAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.LocalResourceAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    LocalResourceAccessReviewAttributeRestrictionsNestedImpl(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new LocalResourceAccessReviewBuilder(this);
    }
    LocalResourceAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleAttributeRestrictionsNestedImpl<N> extends ClusterRoleFluentImpl<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleAttributeRestrictionsNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class ConnectionConfigAttributeRestrictionsNestedImpl<N> extends ConnectionConfigFluentImpl<PolicyRuleFluent.ConnectionConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ConnectionConfigAttributeRestrictionsNested<N>,Nested<N>{
    ConnectionConfigAttributeRestrictionsNestedImpl(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigAttributeRestrictionsNestedImpl() {
      this.builder = new ConnectionConfigBuilder(this);
    }
    ConnectionConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endConnectionConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class TagEventConditionAttributeRestrictionsNestedImpl<N> extends TagEventConditionFluentImpl<PolicyRuleFluent.TagEventConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagEventConditionAttributeRestrictionsNested<N>,Nested<N>{
    TagEventConditionAttributeRestrictionsNestedImpl(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionAttributeRestrictionsNestedImpl() {
      this.builder = new TagEventConditionBuilder(this);
    }
    TagEventConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagEventConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class LabelSelectorAttributeRestrictionsNestedImpl<N> extends LabelSelectorFluentImpl<PolicyRuleFluent.LabelSelectorAttributeRestrictionsNested<N>> implements PolicyRuleFluent.LabelSelectorAttributeRestrictionsNested<N>,Nested<N>{
    LabelSelectorAttributeRestrictionsNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorAttributeRestrictionsNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLabelSelectorAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceListAttributeRestrictionsNestedImpl<N> extends NetNamespaceListFluentImpl<PolicyRuleFluent.NetNamespaceListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.NetNamespaceListAttributeRestrictionsNested<N>,Nested<N>{
    NetNamespaceListAttributeRestrictionsNestedImpl(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListAttributeRestrictionsNestedImpl() {
      this.builder = new NetNamespaceListBuilder(this);
    }
    NetNamespaceListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceListAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceSpecFluentImpl<PolicyRuleFluent.BrokerTemplateInstanceSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BrokerTemplateInstanceSpecAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BinaryBuildSourceAttributeRestrictionsNestedImpl<N> extends BinaryBuildSourceFluentImpl<PolicyRuleFluent.BinaryBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BinaryBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    BinaryBuildSourceAttributeRestrictionsNestedImpl(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BinaryBuildSourceBuilder(this);
    }
    BinaryBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBinaryBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationListAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationListFluentImpl<PolicyRuleFluent.OAuthClientAuthorizationListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAuthorizationListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAuthorizationListAttributeRestrictionsNestedImpl(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientAuthorizationListBuilder(this);
    }
    OAuthClientAuthorizationListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildSpecAttributeRestrictionsNestedImpl<N> extends BuildSpecFluentImpl<PolicyRuleFluent.BuildSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildSpecAttributeRestrictionsNestedImpl(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildSpecBuilder(this);
    }
    BuildSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectStatusAttributeRestrictionsNestedImpl<N> extends ProjectStatusFluentImpl<PolicyRuleFluent.ProjectStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectStatusAttributeRestrictionsNested<N>,Nested<N>{
    ProjectStatusAttributeRestrictionsNestedImpl(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectStatusBuilder(this);
    }
    ProjectStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class LocalSubjectAccessReviewAttributeRestrictionsNestedImpl<N> extends LocalSubjectAccessReviewFluentImpl<PolicyRuleFluent.LocalSubjectAccessReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.LocalSubjectAccessReviewAttributeRestrictionsNested<N>,Nested<N>{
    LocalSubjectAccessReviewAttributeRestrictionsNestedImpl(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewAttributeRestrictionsNestedImpl() {
      this.builder = new LocalSubjectAccessReviewBuilder(this);
    }
    LocalSubjectAccessReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endLocalSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends RollingDeploymentStrategyParamsFluentImpl<PolicyRuleFluent.RollingDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RollingDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRollingDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class GitSourceRevisionAttributeRestrictionsNestedImpl<N> extends GitSourceRevisionFluentImpl<PolicyRuleFluent.GitSourceRevisionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GitSourceRevisionAttributeRestrictionsNested<N>,Nested<N>{
    GitSourceRevisionAttributeRestrictionsNestedImpl(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionAttributeRestrictionsNestedImpl() {
      this.builder = new GitSourceRevisionBuilder(this);
    }
    GitSourceRevisionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLabelAttributeRestrictionsNestedImpl<N> extends ImageLabelFluentImpl<PolicyRuleFluent.ImageLabelAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageLabelAttributeRestrictionsNested<N>,Nested<N>{
    ImageLabelAttributeRestrictionsNestedImpl(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLabelAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageChangeTriggerAttributeRestrictionsNestedImpl<N> extends ImageChangeTriggerFluentImpl<PolicyRuleFluent.ImageChangeTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageChangeTriggerAttributeRestrictionsNested<N>,Nested<N>{
    ImageChangeTriggerAttributeRestrictionsNestedImpl(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new ImageChangeTriggerBuilder(this);
    }
    ImageChangeTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageChangeTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewSpecFluentImpl<PolicyRuleFluent.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagAttributeRestrictionsNestedImpl<N> extends ImageTagFluentImpl<PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageTagAttributeRestrictionsNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportSpecAttributeRestrictionsNestedImpl<N> extends ImageStreamImportSpecFluentImpl<PolicyRuleFluent.ImageStreamImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportSpecAttributeRestrictionsNestedImpl(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportSpecBuilder(this);
    }
    ImageStreamImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class FSGroupStrategyOptionsAttributeRestrictionsNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<PolicyRuleFluent.FSGroupStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.FSGroupStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    FSGroupStrategyOptionsAttributeRestrictionsNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endFSGroupStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicyReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicyReviewFluentImpl<PolicyRuleFluent.PodSecurityPolicyReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicyReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicyReviewAttributeRestrictionsNestedImpl(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicyReviewBuilder(this);
    }
    PodSecurityPolicyReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicyReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends RecreateDeploymentStrategyParamsFluentImpl<PolicyRuleFluent.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRecreateDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class DockerStrategyOptionsAttributeRestrictionsNestedImpl<N> extends DockerStrategyOptionsFluentImpl<PolicyRuleFluent.DockerStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DockerStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    DockerStrategyOptionsAttributeRestrictionsNestedImpl(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new DockerStrategyOptionsBuilder(this);
    }
    DockerStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDockerStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageListAttributeRestrictionsNestedImpl<N> extends ImageListFluentImpl<PolicyRuleFluent.ImageListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageListAttributeRestrictionsNested<N>,Nested<N>{
    ImageListAttributeRestrictionsNestedImpl(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageListBuilder(this);
    }
    ImageListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageListAttributeRestrictions() {
      return and();
    }
    
  }
  class ConfigMapBuildSourceAttributeRestrictionsNestedImpl<N> extends ConfigMapBuildSourceFluentImpl<PolicyRuleFluent.ConfigMapBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ConfigMapBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    ConfigMapBuildSourceAttributeRestrictionsNestedImpl(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new ConfigMapBuildSourceBuilder(this);
    }
    ConfigMapBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endConfigMapBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagListAttributeRestrictionsNestedImpl<N> extends ImageTagListFluentImpl<PolicyRuleFluent.ImageTagListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageTagListAttributeRestrictionsNested<N>,Nested<N>{
    ImageTagListAttributeRestrictionsNestedImpl(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListAttributeRestrictionsNestedImpl() {
      this.builder = new ImageTagListBuilder(this);
    }
    ImageTagListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagListAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenFluentImpl<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAccessTokenAttributeRestrictionsNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigAttributeRestrictionsNestedImpl<N> extends DeploymentConfigFluentImpl<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigAttributeRestrictionsNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingAttributeRestrictionsNestedImpl<N> extends RoleBindingFluentImpl<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingAttributeRestrictionsNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageAttributeRestrictionsNestedImpl<N> extends ImageFluentImpl<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageAttributeRestrictionsNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageAttributeRestrictions() {
      return and();
    }
    
  }
  class TLSConfigAttributeRestrictionsNestedImpl<N> extends TLSConfigFluentImpl<PolicyRuleFluent.TLSConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TLSConfigAttributeRestrictionsNested<N>,Nested<N>{
    TLSConfigAttributeRestrictionsNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigAttributeRestrictionsNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTLSConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeAttributeRestrictionsNestedImpl<N> extends BuildVolumeFluentImpl<PolicyRuleFluent.BuildVolumeAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildVolumeAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeAttributeRestrictionsNestedImpl(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeBuilder(this);
    }
    BuildVolumeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceSpecAttributeRestrictionsNestedImpl<N> extends TemplateInstanceSpecFluentImpl<PolicyRuleFluent.TemplateInstanceSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceSpecAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceSpecAttributeRestrictionsNestedImpl(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceSpecBuilder(this);
    }
    TemplateInstanceSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusAttributeRestrictionsNestedImpl<N> extends BuildStatusFluentImpl<PolicyRuleFluent.BuildStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildStatusAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusAttributeRestrictionsNestedImpl(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusBuilder(this);
    }
    BuildStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSourceAttributeRestrictionsNestedImpl<N> extends ImageSourceFluentImpl<PolicyRuleFluent.ImageSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageSourceAttributeRestrictionsNested<N>,Nested<N>{
    ImageSourceAttributeRestrictionsNestedImpl(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSourceBuilder(this);
    }
    ImageSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ObjectMetaAttributeRestrictionsNestedImpl<N> extends ObjectMetaFluentImpl<PolicyRuleFluent.ObjectMetaAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ObjectMetaAttributeRestrictionsNested<N>,Nested<N>{
    ObjectMetaAttributeRestrictionsNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaAttributeRestrictionsNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endObjectMetaAttributeRestrictions() {
      return and();
    }
    
  }
  class PersistentVolumeClaimAttributeRestrictionsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>,Nested<N>{
    PersistentVolumeClaimAttributeRestrictionsNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimAttributeRestrictionsNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPersistentVolumeClaimAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewFluentImpl<PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class TagReferenceAttributeRestrictionsNestedImpl<N> extends TagReferenceFluentImpl<PolicyRuleFluent.TagReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagReferenceAttributeRestrictionsNested<N>,Nested<N>{
    TagReferenceAttributeRestrictionsNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new TagReferenceBuilder(this);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyRuleFluentImpl<PolicyRuleFluent.EgressNetworkPolicyRuleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicyRuleAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyRuleBuilder(this);
    }
    EgressNetworkPolicyRuleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewStatusAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<PolicyRuleFluent.SubjectRulesReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SubjectRulesReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewStatusAttributeRestrictionsNestedImpl(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewStatusBuilder(this);
    }
    SubjectRulesReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildVolumeMountAttributeRestrictionsNestedImpl<N> extends BuildVolumeMountFluentImpl<PolicyRuleFluent.BuildVolumeMountAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildVolumeMountAttributeRestrictionsNested<N>,Nested<N>{
    BuildVolumeMountAttributeRestrictionsNestedImpl(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountAttributeRestrictionsNestedImpl() {
      this.builder = new BuildVolumeMountBuilder(this);
    }
    BuildVolumeMountBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildVolumeMountAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkEntryAttributeRestrictionsNestedImpl<N> extends ClusterNetworkEntryFluentImpl<PolicyRuleFluent.ClusterNetworkEntryAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterNetworkEntryAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkEntryAttributeRestrictionsNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkEntryAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceObjectAttributeRestrictionsNestedImpl<N> extends TemplateInstanceObjectFluentImpl<PolicyRuleFluent.TemplateInstanceObjectAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceObjectAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceObjectAttributeRestrictionsNestedImpl(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceObjectBuilder(this);
    }
    TemplateInstanceObjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceObjectAttributeRestrictions() {
      return and();
    }
    
  }
  class GenericKubernetesResourceAttributeRestrictionsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<PolicyRuleFluent.GenericKubernetesResourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GenericKubernetesResourceAttributeRestrictionsNested<N>,Nested<N>{
    GenericKubernetesResourceAttributeRestrictionsNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceAttributeRestrictionsNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGenericKubernetesResourceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildSourceAttributeRestrictionsNestedImpl<N> extends BuildSourceFluentImpl<PolicyRuleFluent.BuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    BuildSourceAttributeRestrictionsNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaStatusFluentImpl<PolicyRuleFluent.ClusterResourceQuotaStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaStatusAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaStatusBuilder(this);
    }
    ClusterResourceQuotaStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConditionAttributeRestrictionsNestedImpl<N> extends DeploymentConditionFluentImpl<PolicyRuleFluent.DeploymentConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConditionAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConditionAttributeRestrictionsNestedImpl(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConditionBuilder(this);
    }
    DeploymentConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositorySpecAttributeRestrictionsNestedImpl<N> extends HelmChartRepositorySpecFluentImpl<PolicyRuleFluent.HelmChartRepositorySpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HelmChartRepositorySpecAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositorySpecAttributeRestrictionsNestedImpl(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositorySpecBuilder(this);
    }
    HelmChartRepositorySpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositorySpecAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<PolicyRuleFluent.DeploymentCauseImageTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentCauseImageTriggerAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentCauseImageTriggerBuilder(this);
    }
    DeploymentCauseImageTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentCauseImageTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamMappingAttributeRestrictionsNestedImpl<N> extends ImageStreamMappingFluentImpl<PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamMappingAttributeRestrictionsNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class SubjectRulesReviewAttributeRestrictionsNestedImpl<N> extends SubjectRulesReviewFluentImpl<PolicyRuleFluent.SubjectRulesReviewAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SubjectRulesReviewAttributeRestrictionsNested<N>,Nested<N>{
    SubjectRulesReviewAttributeRestrictionsNestedImpl(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewAttributeRestrictionsNestedImpl() {
      this.builder = new SubjectRulesReviewBuilder(this);
    }
    SubjectRulesReviewBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleAttributeRestrictionsNestedImpl<N> extends RoleFluentImpl<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleAttributeRestrictionsNested<N>,Nested<N>{
    RoleAttributeRestrictionsNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class GitBuildSourceAttributeRestrictionsNestedImpl<N> extends GitBuildSourceFluentImpl<PolicyRuleFluent.GitBuildSourceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GitBuildSourceAttributeRestrictionsNested<N>,Nested<N>{
    GitBuildSourceAttributeRestrictionsNestedImpl(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceAttributeRestrictionsNestedImpl() {
      this.builder = new GitBuildSourceBuilder(this);
    }
    GitBuildSourceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGitBuildSourceAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyListAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyListFluentImpl<PolicyRuleFluent.EgressNetworkPolicyListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicyListAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyListAttributeRestrictionsNestedImpl(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyListBuilder(this);
    }
    EgressNetworkPolicyListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyListAttributeRestrictions() {
      return and();
    }
    
  }
  class SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<PolicyRuleFluent.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSelfSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSourcePathAttributeRestrictionsNestedImpl<N> extends ImageSourcePathFluentImpl<PolicyRuleFluent.ImageSourcePathAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageSourcePathAttributeRestrictionsNested<N>,Nested<N>{
    ImageSourcePathAttributeRestrictionsNestedImpl(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSourcePathBuilder(this);
    }
    ImageSourcePathBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSourcePathAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigStatusAttributeRestrictionsNestedImpl<N> extends BuildConfigStatusFluentImpl<PolicyRuleFluent.BuildConfigStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigStatusAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigStatusAttributeRestrictionsNestedImpl(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigStatusBuilder(this);
    }
    BuildConfigStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl<N> extends ResourceQuotaStatusByNamespaceFluentImpl<PolicyRuleFluent.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N>,Nested<N>{
    ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceQuotaStatusByNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceBuildStrategyAttributeRestrictionsNestedImpl<N> extends SourceBuildStrategyFluentImpl<PolicyRuleFluent.SourceBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SourceBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    SourceBuildStrategyAttributeRestrictionsNestedImpl(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new SourceBuildStrategyBuilder(this);
    }
    SourceBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class ParameterAttributeRestrictionsNestedImpl<N> extends ParameterFluentImpl<PolicyRuleFluent.ParameterAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ParameterAttributeRestrictionsNested<N>,Nested<N>{
    ParameterAttributeRestrictionsNestedImpl(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterAttributeRestrictionsNestedImpl() {
      this.builder = new ParameterBuilder(this);
    }
    ParameterBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endParameterAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingListAttributeRestrictionsNestedImpl<N> extends RoleBindingListFluentImpl<PolicyRuleFluent.RoleBindingListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingListAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingListAttributeRestrictionsNestedImpl(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingListBuilder(this);
    }
    RoleBindingListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySelfSubjectReviewSpecFluentImpl<PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildPostCommitSpecAttributeRestrictionsNestedImpl<N> extends BuildPostCommitSpecFluentImpl<PolicyRuleFluent.BuildPostCommitSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildPostCommitSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildPostCommitSpecAttributeRestrictionsNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildPostCommitSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenListFluentImpl<PolicyRuleFluent.OAuthAuthorizeTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAuthorizeTokenListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAuthorizeTokenListBuilder(this);
    }
    OAuthAuthorizeTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentStrategyAttributeRestrictionsNestedImpl<N> extends DeploymentStrategyFluentImpl<PolicyRuleFluent.DeploymentStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentStrategyAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentStrategyAttributeRestrictionsNestedImpl(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentStrategyBuilder(this);
    }
    DeploymentStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureSubjectAttributeRestrictionsNestedImpl<N> extends SignatureSubjectFluentImpl<PolicyRuleFluent.SignatureSubjectAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SignatureSubjectAttributeRestrictionsNested<N>,Nested<N>{
    SignatureSubjectAttributeRestrictionsNestedImpl(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureSubjectBuilder(this);
    }
    SignatureSubjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureSubjectAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetListAttributeRestrictionsNestedImpl<N> extends HostSubnetListFluentImpl<PolicyRuleFluent.HostSubnetListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HostSubnetListAttributeRestrictionsNested<N>,Nested<N>{
    HostSubnetListAttributeRestrictionsNestedImpl(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListAttributeRestrictionsNestedImpl() {
      this.builder = new HostSubnetListBuilder(this);
    }
    HostSubnetListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteIngressConditionAttributeRestrictionsNestedImpl<N> extends RouteIngressConditionFluentImpl<PolicyRuleFluent.RouteIngressConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteIngressConditionAttributeRestrictionsNested<N>,Nested<N>{
    RouteIngressConditionAttributeRestrictionsNestedImpl(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionAttributeRestrictionsNestedImpl() {
      this.builder = new RouteIngressConditionBuilder(this);
    }
    RouteIngressConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteIngressConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl<N> extends CustomDeploymentStrategyParamsFluentImpl<PolicyRuleFluent.CustomDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.CustomDeploymentStrategyParamsAttributeRestrictionsNested<N>,Nested<N>{
    CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsAttributeRestrictionsNestedImpl() {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endCustomDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageImportSpecAttributeRestrictionsNestedImpl<N> extends ImageImportSpecFluentImpl<PolicyRuleFluent.ImageImportSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageImportSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageImportSpecAttributeRestrictionsNestedImpl(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageImportSpecBuilder(this);
    }
    ImageImportSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageImportSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class StageInfoAttributeRestrictionsNestedImpl<N> extends StageInfoFluentImpl<PolicyRuleFluent.StageInfoAttributeRestrictionsNested<N>> implements PolicyRuleFluent.StageInfoAttributeRestrictionsNested<N>,Nested<N>{
    StageInfoAttributeRestrictionsNestedImpl(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoAttributeRestrictionsNestedImpl() {
      this.builder = new StageInfoBuilder(this);
    }
    StageInfoBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endStageInfoAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionSpecFluentImpl<PolicyRuleFluent.RoleBindingRestrictionSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingRestrictionSpecAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionSpecBuilder(this);
    }
    RoleBindingRestrictionSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class IDRangeAttributeRestrictionsNestedImpl<N> extends IDRangeFluentImpl<PolicyRuleFluent.IDRangeAttributeRestrictionsNested<N>> implements PolicyRuleFluent.IDRangeAttributeRestrictionsNested<N>,Nested<N>{
    IDRangeAttributeRestrictionsNestedImpl(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeAttributeRestrictionsNestedImpl() {
      this.builder = new IDRangeBuilder(this);
    }
    IDRangeBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIDRangeAttributeRestrictions() {
      return and();
    }
    
  }
  class UserListAttributeRestrictionsNestedImpl<N> extends UserListFluentImpl<PolicyRuleFluent.UserListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserListAttributeRestrictionsNested<N>,Nested<N>{
    UserListAttributeRestrictionsNestedImpl(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListAttributeRestrictionsNestedImpl() {
      this.builder = new UserListBuilder(this);
    }
    UserListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigSpecAttributeRestrictionsNestedImpl<N> extends BuildConfigSpecFluentImpl<PolicyRuleFluent.BuildConfigSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigSpecAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigSpecAttributeRestrictionsNestedImpl(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigSpecBuilder(this);
    }
    BuildConfigSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class UserAttributeRestrictionsNestedImpl<N> extends UserFluentImpl<PolicyRuleFluent.UserAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserAttributeRestrictionsNested<N>,Nested<N>{
    UserAttributeRestrictionsNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserAttributeRestrictionsNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImageAttributeRestrictionsNestedImpl<N> extends ImageStreamImageFluentImpl<PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImageAttributeRestrictionsNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImageAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildStatusOutputToAttributeRestrictionsNestedImpl<N> extends BuildStatusOutputToFluentImpl<PolicyRuleFluent.BuildStatusOutputToAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildStatusOutputToAttributeRestrictionsNested<N>,Nested<N>{
    BuildStatusOutputToAttributeRestrictionsNestedImpl(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToAttributeRestrictionsNestedImpl() {
      this.builder = new BuildStatusOutputToBuilder(this);
    }
    BuildStatusOutputToBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildStatusOutputToAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConditionAttributeRestrictionsNestedImpl<N> extends BuildConditionFluentImpl<PolicyRuleFluent.BuildConditionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConditionAttributeRestrictionsNested<N>,Nested<N>{
    BuildConditionAttributeRestrictionsNestedImpl(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConditionBuilder(this);
    }
    BuildConditionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConditionAttributeRestrictions() {
      return and();
    }
    
  }
  class ResourceAccessReviewResponseAttributeRestrictionsNestedImpl<N> extends ResourceAccessReviewResponseFluentImpl<PolicyRuleFluent.ResourceAccessReviewResponseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ResourceAccessReviewResponseAttributeRestrictionsNested<N>,Nested<N>{
    ResourceAccessReviewResponseAttributeRestrictionsNestedImpl(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseAttributeRestrictionsNestedImpl() {
      this.builder = new ResourceAccessReviewResponseBuilder(this);
    }
    ResourceAccessReviewResponseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endResourceAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  }
  class ExecNewPodHookAttributeRestrictionsNestedImpl<N> extends ExecNewPodHookFluentImpl<PolicyRuleFluent.ExecNewPodHookAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ExecNewPodHookAttributeRestrictionsNested<N>,Nested<N>{
    ExecNewPodHookAttributeRestrictionsNestedImpl(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookAttributeRestrictionsNestedImpl() {
      this.builder = new ExecNewPodHookBuilder(this);
    }
    ExecNewPodHookBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endExecNewPodHookAttributeRestrictions() {
      return and();
    }
    
  }
  class SecretSpecAttributeRestrictionsNestedImpl<N> extends SecretSpecFluentImpl<PolicyRuleFluent.SecretSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecretSpecAttributeRestrictionsNested<N>,Nested<N>{
    SecretSpecAttributeRestrictionsNestedImpl(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecAttributeRestrictionsNestedImpl() {
      this.builder = new SecretSpecBuilder(this);
    }
    SecretSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecretSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingListAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingListFluentImpl<PolicyRuleFluent.ClusterRoleBindingListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleBindingListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleBindingListAttributeRestrictionsNestedImpl(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBindingListBuilder(this);
    }
    ClusterRoleBindingListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyPeerFluentImpl<PolicyRuleFluent.EgressNetworkPolicyPeerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicyPeerAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyPeerBuilder(this);
    }
    EgressNetworkPolicyPeerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyPeerAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceAttributeRestrictionsNestedImpl<N> extends TemplateInstanceFluentImpl<PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceAttributeRestrictionsNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class WebHookTriggerAttributeRestrictionsNestedImpl<N> extends WebHookTriggerFluentImpl<PolicyRuleFluent.WebHookTriggerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.WebHookTriggerAttributeRestrictionsNested<N>,Nested<N>{
    WebHookTriggerAttributeRestrictionsNestedImpl(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerAttributeRestrictionsNestedImpl() {
      this.builder = new WebHookTriggerBuilder(this);
    }
    WebHookTriggerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endWebHookTriggerAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountReferenceAttributeRestrictionsNestedImpl<N> extends ServiceAccountReferenceFluentImpl<PolicyRuleFluent.ServiceAccountReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ServiceAccountReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountReferenceAttributeRestrictionsNestedImpl(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountReferenceBuilder(this);
    }
    ServiceAccountReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildAttributeRestrictionsNestedImpl<N> extends BuildFluentImpl<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildAttributeRestrictionsNested<N>,Nested<N>{
    BuildAttributeRestrictionsNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildAttributeRestrictionsNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionAttributeRestrictionsNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class TagImportPolicyAttributeRestrictionsNestedImpl<N> extends TagImportPolicyFluentImpl<PolicyRuleFluent.TagImportPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TagImportPolicyAttributeRestrictionsNested<N>,Nested<N>{
    TagImportPolicyAttributeRestrictionsNestedImpl(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new TagImportPolicyBuilder(this);
    }
    TagImportPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTagImportPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagAttributeRestrictionsNestedImpl<N> extends ImageStreamTagFluentImpl<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagAttributeRestrictionsNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildTriggerPolicyAttributeRestrictionsNestedImpl<N> extends BuildTriggerPolicyFluentImpl<PolicyRuleFluent.BuildTriggerPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildTriggerPolicyAttributeRestrictionsNested<N>,Nested<N>{
    BuildTriggerPolicyAttributeRestrictionsNestedImpl(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new BuildTriggerPolicyBuilder(this);
    }
    BuildTriggerPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class RoutePortAttributeRestrictionsNestedImpl<N> extends RoutePortFluentImpl<PolicyRuleFluent.RoutePortAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoutePortAttributeRestrictionsNested<N>,Nested<N>{
    RoutePortAttributeRestrictionsNestedImpl(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortAttributeRestrictionsNestedImpl() {
      this.builder = new RoutePortBuilder(this);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoutePortAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceRequesterAttributeRestrictionsNestedImpl<N> extends TemplateInstanceRequesterFluentImpl<PolicyRuleFluent.TemplateInstanceRequesterAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceRequesterAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceRequesterAttributeRestrictionsNestedImpl(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceRequesterBuilder(this);
    }
    TemplateInstanceRequesterBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceRequesterAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupAttributeRestrictionsNestedImpl<N> extends GroupFluentImpl<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GroupAttributeRestrictionsNested<N>,Nested<N>{
    GroupAttributeRestrictionsNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupAttributeRestrictionsNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildTriggerCauseAttributeRestrictionsNestedImpl<N> extends BuildTriggerCauseFluentImpl<PolicyRuleFluent.BuildTriggerCauseAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildTriggerCauseAttributeRestrictionsNested<N>,Nested<N>{
    BuildTriggerCauseAttributeRestrictionsNestedImpl(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseAttributeRestrictionsNestedImpl() {
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildTriggerCauseAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSignatureAttributeRestrictionsNestedImpl<N> extends ImageSignatureFluentImpl<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>,Nested<N>{
    ImageSignatureAttributeRestrictionsNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSignatureAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryStatusAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryStatusFluentImpl<PolicyRuleFluent.HelmChartRepositoryStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HelmChartRepositoryStatusAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryStatusAttributeRestrictionsNestedImpl(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryStatusBuilder(this);
    }
    HelmChartRepositoryStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigSpecAttributeRestrictionsNestedImpl<N> extends DeploymentConfigSpecFluentImpl<PolicyRuleFluent.DeploymentConfigSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigSpecAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigSpecAttributeRestrictionsNestedImpl(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigSpecBuilder(this);
    }
    DeploymentConfigSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetAttributeRestrictionsNestedImpl<N> extends HostSubnetFluentImpl<PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>,Nested<N>{
    HostSubnetAttributeRestrictionsNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetAttributeRestrictionsNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupRestrictionAttributeRestrictionsNestedImpl<N> extends GroupRestrictionFluentImpl<PolicyRuleFluent.GroupRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GroupRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    GroupRestrictionAttributeRestrictionsNestedImpl(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new GroupRestrictionBuilder(this);
    }
    GroupRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenListAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenListFluentImpl<PolicyRuleFluent.OAuthAccessTokenListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAccessTokenListAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAccessTokenListAttributeRestrictionsNestedImpl(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAccessTokenListBuilder(this);
    }
    OAuthAccessTokenListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  }
  class JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl<N> extends JenkinsPipelineBuildStrategyFluentImpl<PolicyRuleFluent.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N>,Nested<N>{
    JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyAttributeRestrictionsNestedImpl() {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endJenkinsPipelineBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>,Nested<N>{
    SecurityContextConstraintsAttributeRestrictionsNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsAttributeRestrictionsNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsAttributeRestrictions() {
      return and();
    }
    
  }
  class SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<PolicyRuleFluent.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSupplementalGroupsStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<PolicyRuleFluent.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildRequestAttributeRestrictionsNestedImpl<N> extends BuildRequestFluentImpl<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>,Nested<N>{
    BuildRequestAttributeRestrictionsNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestAttributeRestrictionsNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<PolicyRuleFluent.SELinuxContextStrategyOptionsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SELinuxContextStrategyOptionsAttributeRestrictionsNested<N>,Nested<N>{
    SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsAttributeRestrictionsNestedImpl() {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSELinuxContextStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleListAttributeRestrictionsNestedImpl<N> extends ClusterRoleListFluentImpl<PolicyRuleFluent.ClusterRoleListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleListAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleListAttributeRestrictionsNestedImpl(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleListBuilder(this);
    }
    ClusterRoleListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleListAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteListAttributeRestrictionsNestedImpl<N> extends RouteListFluentImpl<PolicyRuleFluent.RouteListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteListAttributeRestrictionsNested<N>,Nested<N>{
    RouteListAttributeRestrictionsNestedImpl(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListAttributeRestrictionsNestedImpl() {
      this.builder = new RouteListBuilder(this);
    }
    RouteListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteListAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamStatusAttributeRestrictionsNestedImpl<N> extends ImageStreamStatusFluentImpl<PolicyRuleFluent.ImageStreamStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamStatusAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamStatusAttributeRestrictionsNestedImpl(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamStatusBuilder(this);
    }
    ImageStreamStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyFluentImpl<PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyAttributeRestrictionsNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceAttributeRestrictionsNestedImpl<N> extends NetNamespaceFluentImpl<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>,Nested<N>{
    NetNamespaceAttributeRestrictionsNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class UserIdentityMappingAttributeRestrictionsNestedImpl<N> extends UserIdentityMappingFluentImpl<PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>,Nested<N>{
    UserIdentityMappingAttributeRestrictionsNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingAttributeRestrictionsNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserIdentityMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentDetailsAttributeRestrictionsNestedImpl<N> extends DeploymentDetailsFluentImpl<PolicyRuleFluent.DeploymentDetailsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentDetailsAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentDetailsAttributeRestrictionsNestedImpl(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentDetailsBuilder(this);
    }
    DeploymentDetailsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentDetailsAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewStatusFluentImpl<PolicyRuleFluent.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
      return and();
    }
    
  }
  class PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl<N> extends PodSecurityPolicySubjectReviewSpecFluentImpl<PolicyRuleFluent.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N>,Nested<N>{
    PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNestedImpl() {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamAttributeRestrictionsNestedImpl<N> extends ImageStreamFluentImpl<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamAttributeRestrictionsNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildListAttributeRestrictionsNestedImpl<N> extends BuildListFluentImpl<PolicyRuleFluent.BuildListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildListAttributeRestrictionsNested<N>,Nested<N>{
    BuildListAttributeRestrictionsNestedImpl(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListAttributeRestrictionsNestedImpl() {
      this.builder = new BuildListBuilder(this);
    }
    BuildListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildListAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateListAttributeRestrictionsNestedImpl<N> extends TemplateListFluentImpl<PolicyRuleFluent.TemplateListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateListAttributeRestrictionsNested<N>,Nested<N>{
    TemplateListAttributeRestrictionsNestedImpl(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateListBuilder(this);
    }
    TemplateListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateListAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildOutputAttributeRestrictionsNestedImpl<N> extends BuildOutputFluentImpl<PolicyRuleFluent.BuildOutputAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildOutputAttributeRestrictionsNested<N>,Nested<N>{
    BuildOutputAttributeRestrictionsNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputAttributeRestrictionsNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildOutputAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectSpecAttributeRestrictionsNestedImpl<N> extends ProjectSpecFluentImpl<PolicyRuleFluent.ProjectSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectSpecAttributeRestrictionsNested<N>,Nested<N>{
    ProjectSpecAttributeRestrictionsNestedImpl(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectSpecBuilder(this);
    }
    ProjectSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class SourceRevisionAttributeRestrictionsNestedImpl<N> extends SourceRevisionFluentImpl<PolicyRuleFluent.SourceRevisionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SourceRevisionAttributeRestrictionsNested<N>,Nested<N>{
    SourceRevisionAttributeRestrictionsNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionAttributeRestrictionsNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  }
  class ObjectReferenceAttributeRestrictionsNestedImpl<N> extends ObjectReferenceFluentImpl<PolicyRuleFluent.ObjectReferenceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ObjectReferenceAttributeRestrictionsNested<N>,Nested<N>{
    ObjectReferenceAttributeRestrictionsNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceAttributeRestrictionsNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  }
  class SignatureIssuerAttributeRestrictionsNestedImpl<N> extends SignatureIssuerFluentImpl<PolicyRuleFluent.SignatureIssuerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SignatureIssuerAttributeRestrictionsNested<N>,Nested<N>{
    SignatureIssuerAttributeRestrictionsNestedImpl(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerAttributeRestrictionsNestedImpl() {
      this.builder = new SignatureIssuerBuilder(this);
    }
    SignatureIssuerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSignatureIssuerAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageLayerAttributeRestrictionsNestedImpl<N> extends ImageLayerFluentImpl<PolicyRuleFluent.ImageLayerAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageLayerAttributeRestrictionsNested<N>,Nested<N>{
    ImageLayerAttributeRestrictionsNestedImpl(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerAttributeRestrictionsNestedImpl() {
      this.builder = new ImageLayerBuilder(this);
    }
    ImageLayerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageLayerAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaSpecFluentImpl<PolicyRuleFluent.ClusterResourceQuotaSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaSpecAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaSpecBuilder(this);
    }
    ClusterResourceQuotaSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamSpecAttributeRestrictionsNestedImpl<N> extends ImageStreamSpecFluentImpl<PolicyRuleFluent.ImageStreamSpecAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamSpecAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamSpecAttributeRestrictionsNestedImpl(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamSpecBuilder(this);
    }
    ImageStreamSpecBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamSpecAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteIngressAttributeRestrictionsNestedImpl<N> extends RouteIngressFluentImpl<PolicyRuleFluent.RouteIngressAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteIngressAttributeRestrictionsNested<N>,Nested<N>{
    RouteIngressAttributeRestrictionsNestedImpl(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressAttributeRestrictionsNestedImpl() {
      this.builder = new RouteIngressBuilder(this);
    }
    RouteIngressBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteIngressAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAttributeRestrictionsNestedImpl<N> extends OAuthClientFluentImpl<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAttributeRestrictionsNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityAttributeRestrictionsNestedImpl<N> extends IdentityFluentImpl<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> implements PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>,Nested<N>{
    IdentityAttributeRestrictionsNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityAttributeRestrictionsNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationListAttributeRestrictionsNestedImpl<N> extends RangeAllocationListFluentImpl<PolicyRuleFluent.RangeAllocationListAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RangeAllocationListAttributeRestrictionsNested<N>,Nested<N>{
    RangeAllocationListAttributeRestrictionsNestedImpl(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListAttributeRestrictionsNestedImpl() {
      this.builder = new RangeAllocationListBuilder(this);
    }
    RangeAllocationListBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationListAttributeRestrictions() {
      return and();
    }
    
  }
  
}