package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>> extends BaseFluent<A> implements BuildSpecFluent<A>{
  public BuildSpecFluentImpl() {
  }
  public BuildSpecFluentImpl(BuildSpec instance) {
    if (instance != null) {
      this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
      this.withMountTrustedCA(instance.getMountTrustedCA());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOutput(instance.getOutput());
      this.withPostCommit(instance.getPostCommit());
      this.withResources(instance.getResources());
      this.withRevision(instance.getRevision());
      this.withServiceAccount(instance.getServiceAccount());
      this.withSource(instance.getSource());
      this.withStrategy(instance.getStrategy());
      this.withTriggeredBy(instance.getTriggeredBy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Long completionDeadlineSeconds;
  private Boolean mountTrustedCA;
  private Map<String,String> nodeSelector;
  private BuildOutputBuilder output;
  private BuildPostCommitSpecBuilder postCommit;
  private ResourceRequirementsBuilder resources;
  private SourceRevisionBuilder revision;
  private String serviceAccount;
  private BuildSourceBuilder source;
  private BuildStrategyBuilder strategy;
  private ArrayList<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
  private Map<String,Object> additionalProperties;
  public Long getCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds;
  }
  public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
    this.completionDeadlineSeconds=completionDeadlineSeconds; return (A) this;
  }
  public Boolean hasCompletionDeadlineSeconds() {
    return this.completionDeadlineSeconds != null;
  }
  public Boolean getMountTrustedCA() {
    return this.mountTrustedCA;
  }
  public A withMountTrustedCA(Boolean mountTrustedCA) {
    this.mountTrustedCA=mountTrustedCA; return (A) this;
  }
  public Boolean hasMountTrustedCA() {
    return this.mountTrustedCA != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOutput instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildOutput getOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public BuildOutput buildOutput() {
    return this.output!=null ?this.output.build():null;
  }
  public A withOutput(BuildOutput output) {
    _visitables.get("output").remove(this.output);
    if (output!=null){ this.output= new BuildOutputBuilder(output); _visitables.get("output").add(this.output);} else { this.output = null; _visitables.get("output").remove(this.output); } return (A) this;
  }
  public Boolean hasOutput() {
    return this.output != null;
  }
  public BuildSpecFluentImpl.OutputNested<A> withNewOutput() {
    return new BuildSpecFluentImpl.OutputNestedImpl();
  }
  public BuildSpecFluentImpl.OutputNested<A> withNewOutputLike(BuildOutput item) {
    return new BuildSpecFluentImpl.OutputNestedImpl(item);
  }
  public BuildSpecFluentImpl.OutputNested<A> editOutput() {
    return withNewOutputLike(getOutput());
  }
  public BuildSpecFluentImpl.OutputNested<A> editOrNewOutput() {
    return withNewOutputLike(getOutput() != null ? getOutput(): new BuildOutputBuilder().build());
  }
  public BuildSpecFluentImpl.OutputNested<A> editOrNewOutputLike(BuildOutput item) {
    return withNewOutputLike(getOutput() != null ? getOutput(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPostCommit instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildPostCommitSpec getPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public BuildPostCommitSpec buildPostCommit() {
    return this.postCommit!=null ?this.postCommit.build():null;
  }
  public A withPostCommit(BuildPostCommitSpec postCommit) {
    _visitables.get("postCommit").remove(this.postCommit);
    if (postCommit!=null){ this.postCommit= new BuildPostCommitSpecBuilder(postCommit); _visitables.get("postCommit").add(this.postCommit);} else { this.postCommit = null; _visitables.get("postCommit").remove(this.postCommit); } return (A) this;
  }
  public Boolean hasPostCommit() {
    return this.postCommit != null;
  }
  public BuildSpecFluentImpl.PostCommitNested<A> withNewPostCommit() {
    return new BuildSpecFluentImpl.PostCommitNestedImpl();
  }
  public BuildSpecFluentImpl.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
    return new BuildSpecFluentImpl.PostCommitNestedImpl(item);
  }
  public BuildSpecFluentImpl.PostCommitNested<A> editPostCommit() {
    return withNewPostCommitLike(getPostCommit());
  }
  public BuildSpecFluentImpl.PostCommitNested<A> editOrNewPostCommit() {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): new BuildPostCommitSpecBuilder().build());
  }
  public BuildSpecFluentImpl.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
    return withNewPostCommitLike(getPostCommit() != null ? getPostCommit(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public BuildSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new BuildSpecFluentImpl.ResourcesNestedImpl();
  }
  public BuildSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new BuildSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public BuildSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public BuildSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public BuildSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRevision instead.
   * @return The buildable object.
   */
  @Deprecated
  public SourceRevision getRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public SourceRevision buildRevision() {
    return this.revision!=null ?this.revision.build():null;
  }
  public A withRevision(SourceRevision revision) {
    _visitables.get("revision").remove(this.revision);
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.get("revision").add(this.revision);} else { this.revision = null; _visitables.get("revision").remove(this.revision); } return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public BuildSpecFluentImpl.RevisionNested<A> withNewRevision() {
    return new BuildSpecFluentImpl.RevisionNestedImpl();
  }
  public BuildSpecFluentImpl.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
    return new BuildSpecFluentImpl.RevisionNestedImpl(item);
  }
  public BuildSpecFluentImpl.RevisionNested<A> editRevision() {
    return withNewRevisionLike(getRevision());
  }
  public BuildSpecFluentImpl.RevisionNested<A> editOrNewRevision() {
    return withNewRevisionLike(getRevision() != null ? getRevision(): new SourceRevisionBuilder().build());
  }
  public BuildSpecFluentImpl.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
    return withNewRevisionLike(getRevision() != null ? getRevision(): item);
  }
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildSource getSource() {
    return this.source!=null ?this.source.build():null;
  }
  public BuildSource buildSource() {
    return this.source!=null ?this.source.build():null;
  }
  public A withSource(BuildSource source) {
    _visitables.get("source").remove(this.source);
    if (source!=null){ this.source= new BuildSourceBuilder(source); _visitables.get("source").add(this.source);} else { this.source = null; _visitables.get("source").remove(this.source); } return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public BuildSpecFluentImpl.SourceNested<A> withNewSource() {
    return new BuildSpecFluentImpl.SourceNestedImpl();
  }
  public BuildSpecFluentImpl.SourceNested<A> withNewSourceLike(BuildSource item) {
    return new BuildSpecFluentImpl.SourceNestedImpl(item);
  }
  public BuildSpecFluentImpl.SourceNested<A> editSource() {
    return withNewSourceLike(getSource());
  }
  public BuildSpecFluentImpl.SourceNested<A> editOrNewSource() {
    return withNewSourceLike(getSource() != null ? getSource(): new BuildSourceBuilder().build());
  }
  public BuildSpecFluentImpl.SourceNested<A> editOrNewSourceLike(BuildSource item) {
    return withNewSourceLike(getSource() != null ? getSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public BuildStrategy getStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public BuildStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  public A withStrategy(BuildStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new BuildStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} else { this.strategy = null; _visitables.get("strategy").remove(this.strategy); } return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  public BuildSpecFluentImpl.StrategyNested<A> withNewStrategy() {
    return new BuildSpecFluentImpl.StrategyNestedImpl();
  }
  public BuildSpecFluentImpl.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
    return new BuildSpecFluentImpl.StrategyNestedImpl(item);
  }
  public BuildSpecFluentImpl.StrategyNested<A> editStrategy() {
    return withNewStrategyLike(getStrategy());
  }
  public BuildSpecFluentImpl.StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): new BuildStrategyBuilder().build());
  }
  public BuildSpecFluentImpl.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
    return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
  }
  public A addToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").add(index, builder); triggeredBy.add(index, builder);}
    return (A)this;
  }
  public A setToTriggeredBy(int index,BuildTriggerCause item) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
    if (index < 0 || index >= triggeredBy.size()) { _visitables.get("triggeredBy").add(builder); triggeredBy.add(builder); } else { _visitables.get("triggeredBy").set(index, builder); triggeredBy.set(index, builder);}
    return (A)this;
  }
  public A addToTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
    if (this.triggeredBy == null) {this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();}
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").add(builder);this.triggeredBy.add(builder);} return (A)this;
  }
  public A removeFromTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... items) {
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
    for (BuildTriggerCause item : items) {BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);_visitables.get("triggeredBy").remove(builder);if (this.triggeredBy != null) {this.triggeredBy.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    if (triggeredBy == null) return (A) this;
    final Iterator<BuildTriggerCauseBuilder> each = triggeredBy.iterator();
    final List visitables = _visitables.get("triggeredBy");
    while (each.hasNext()) {
      BuildTriggerCauseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggeredBy instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildTriggerCause> getTriggeredBy() {
    return triggeredBy != null ? build(triggeredBy) : null;
  }
  public List<BuildTriggerCause> buildTriggeredBy() {
    return triggeredBy != null ? build(triggeredBy) : null;
  }
  public BuildTriggerCause buildTriggeredBy(int index) {
    return this.triggeredBy.get(index).build();
  }
  public BuildTriggerCause buildFirstTriggeredBy() {
    return this.triggeredBy.get(0).build();
  }
  public BuildTriggerCause buildLastTriggeredBy() {
    return this.triggeredBy.get(triggeredBy.size() - 1).build();
  }
  public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    for (BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    for (BuildTriggerCauseBuilder item: triggeredBy) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
    if (this.triggeredBy != null) { _visitables.get("triggeredBy").clear();}
    if (triggeredBy != null) {this.triggeredBy = new ArrayList(); for (BuildTriggerCause item : triggeredBy){this.addToTriggeredBy(item);}} else { this.triggeredBy = null;} return (A) this;
  }
  public A withTriggeredBy(io.fabric8.openshift.api.model.BuildTriggerCause... triggeredBy) {
    if (this.triggeredBy != null) {this.triggeredBy.clear(); _visitables.remove("triggeredBy"); }
    if (triggeredBy != null) {for (BuildTriggerCause item :triggeredBy){ this.addToTriggeredBy(item);}} return (A) this;
  }
  public Boolean hasTriggeredBy() {
    return triggeredBy != null && !triggeredBy.isEmpty();
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> addNewTriggeredBy() {
    return new BuildSpecFluentImpl.TriggeredByNestedImpl();
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
    return new BuildSpecFluentImpl.TriggeredByNestedImpl(-1, item);
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> setNewTriggeredByLike(int index,BuildTriggerCause item) {
    return new BuildSpecFluentImpl.TriggeredByNestedImpl(index, item);
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> editTriggeredBy(int index) {
    if (triggeredBy.size() <= index) throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> editFirstTriggeredBy() {
    if (triggeredBy.size() == 0) throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
    return setNewTriggeredByLike(0, buildTriggeredBy(0));
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> editLastTriggeredBy() {
    int index = triggeredBy.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public BuildSpecFluentImpl.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggeredBy.size();i++) { 
    if (predicate.test(triggeredBy.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
    return setNewTriggeredByLike(index, buildTriggeredBy(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildSpecFluentImpl that = (BuildSpecFluentImpl) o;
    if (!java.util.Objects.equals(completionDeadlineSeconds, that.completionDeadlineSeconds)) return false;

    if (!java.util.Objects.equals(mountTrustedCA, that.mountTrustedCA)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(output, that.output)) return false;

    if (!java.util.Objects.equals(postCommit, that.postCommit)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(revision, that.revision)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(strategy, that.strategy)) return false;

    if (!java.util.Objects.equals(triggeredBy, that.triggeredBy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(completionDeadlineSeconds,  mountTrustedCA,  nodeSelector,  output,  postCommit,  resources,  revision,  serviceAccount,  source,  strategy,  triggeredBy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (completionDeadlineSeconds != null) { sb.append("completionDeadlineSeconds:"); sb.append(completionDeadlineSeconds + ","); }
    if (mountTrustedCA != null) { sb.append("mountTrustedCA:"); sb.append(mountTrustedCA + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (output != null) { sb.append("output:"); sb.append(output + ","); }
    if (postCommit != null) { sb.append("postCommit:"); sb.append(postCommit + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (triggeredBy != null && !triggeredBy.isEmpty()) { sb.append("triggeredBy:"); sb.append(triggeredBy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withMountTrustedCA() {
    return withMountTrustedCA(true);
  }
  class OutputNestedImpl<N> extends BuildOutputFluentImpl<BuildSpecFluentImpl.OutputNested<N>> implements BuildSpecFluentImpl.OutputNested<N>,Nested<N>{
    OutputNestedImpl(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    OutputNestedImpl() {
      this.builder = new BuildOutputBuilder(this);
    }
    BuildOutputBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withOutput(builder.build());
    }
    public N endOutput() {
      return and();
    }
    
  }
  class PostCommitNestedImpl<N> extends BuildPostCommitSpecFluentImpl<BuildSpecFluentImpl.PostCommitNested<N>> implements BuildSpecFluentImpl.PostCommitNested<N>,Nested<N>{
    PostCommitNestedImpl(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    PostCommitNestedImpl() {
      this.builder = new BuildPostCommitSpecBuilder(this);
    }
    BuildPostCommitSpecBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withPostCommit(builder.build());
    }
    public N endPostCommit() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<BuildSpecFluentImpl.ResourcesNested<N>> implements BuildSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RevisionNestedImpl<N> extends SourceRevisionFluentImpl<BuildSpecFluentImpl.RevisionNested<N>> implements BuildSpecFluentImpl.RevisionNested<N>,Nested<N>{
    RevisionNestedImpl(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    RevisionNestedImpl() {
      this.builder = new SourceRevisionBuilder(this);
    }
    SourceRevisionBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision() {
      return and();
    }
    
  }
  class SourceNestedImpl<N> extends BuildSourceFluentImpl<BuildSpecFluentImpl.SourceNested<N>> implements BuildSpecFluentImpl.SourceNested<N>,Nested<N>{
    SourceNestedImpl(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    SourceNestedImpl() {
      this.builder = new BuildSourceBuilder(this);
    }
    BuildSourceBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  class StrategyNestedImpl<N> extends BuildStrategyFluentImpl<BuildSpecFluentImpl.StrategyNested<N>> implements BuildSpecFluentImpl.StrategyNested<N>,Nested<N>{
    StrategyNestedImpl(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    StrategyNestedImpl() {
      this.builder = new BuildStrategyBuilder(this);
    }
    BuildStrategyBuilder builder;
    public N and() {
      return (N) BuildSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy() {
      return and();
    }
    
  }
  class TriggeredByNestedImpl<N> extends BuildTriggerCauseFluentImpl<BuildSpecFluentImpl.TriggeredByNested<N>> implements BuildSpecFluentImpl.TriggeredByNested<N>,Nested<N>{
    TriggeredByNestedImpl(int index,BuildTriggerCause item) {
      this.index = index;
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    TriggeredByNestedImpl() {
      this.index = -1;
      this.builder = new BuildTriggerCauseBuilder(this);
    }
    BuildTriggerCauseBuilder builder;
    int index;
    public N and() {
      return (N) BuildSpecFluentImpl.this.setToTriggeredBy(index,builder.build());
    }
    public N endTriggeredBy() {
      return and();
    }
    
  }
  
}