package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBuilder extends ClusterRoleFluentImpl<ClusterRoleBuilder> implements VisitableBuilder<ClusterRole,ClusterRoleBuilder>{
  public ClusterRoleBuilder() {
    this(false);
  }
  public ClusterRoleBuilder(Boolean validationEnabled) {
    this(new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAggregationRule(instance.getAggregationRule());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRules(instance.getRules());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBuilder(ClusterRole instance) {
    this(instance,false);
  }
  public ClusterRoleBuilder(ClusterRole instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAggregationRule(instance.getAggregationRule());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRules(instance.getRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRole build() {
    ClusterRole buildable = new ClusterRole(fluent.getAggregationRule(),fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}