package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageTagListBuilder extends ImageTagListFluentImpl<ImageTagListBuilder> implements VisitableBuilder<ImageTagList,ImageTagListBuilder>{
  public ImageTagListBuilder() {
    this(false);
  }
  public ImageTagListBuilder(Boolean validationEnabled) {
    this(new ImageTagList(), validationEnabled);
  }
  public ImageTagListBuilder(ImageTagListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageTagListBuilder(ImageTagListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageTagList(), validationEnabled);
  }
  public ImageTagListBuilder(ImageTagListFluent<?> fluent,ImageTagList instance) {
    this(fluent, instance, false);
  }
  public ImageTagListBuilder(ImageTagListFluent<?> fluent,ImageTagList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageTagListBuilder(ImageTagList instance) {
    this(instance,false);
  }
  public ImageTagListBuilder(ImageTagList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageTagListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageTagList build() {
    ImageTagList buildable = new ImageTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}