package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParameterBuilder extends ParameterFluentImpl<ParameterBuilder> implements VisitableBuilder<Parameter,ParameterBuilder>{
  public ParameterBuilder() {
    this(false);
  }
  public ParameterBuilder(Boolean validationEnabled) {
    this(new Parameter(), validationEnabled);
  }
  public ParameterBuilder(ParameterFluent<?> fluent) {
    this(fluent, false);
  }
  public ParameterBuilder(ParameterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Parameter(), validationEnabled);
  }
  public ParameterBuilder(ParameterFluent<?> fluent,Parameter instance) {
    this(fluent, instance, false);
  }
  public ParameterBuilder(ParameterFluent<?> fluent,Parameter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withFrom(instance.getFrom());
      fluent.withGenerate(instance.getGenerate());
      fluent.withName(instance.getName());
      fluent.withRequired(instance.getRequired());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParameterBuilder(Parameter instance) {
    this(instance,false);
  }
  public ParameterBuilder(Parameter instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withFrom(instance.getFrom());
      this.withGenerate(instance.getGenerate());
      this.withName(instance.getName());
      this.withRequired(instance.getRequired());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParameterFluent<?> fluent;
  Boolean validationEnabled;
  public Parameter build() {
    Parameter buildable = new Parameter(fluent.getDescription(),fluent.getDisplayName(),fluent.getFrom(),fluent.getGenerate(),fluent.getName(),fluent.getRequired(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}