package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectRulesReviewBuilder extends SelfSubjectRulesReviewFluentImpl<SelfSubjectRulesReviewBuilder> implements VisitableBuilder<SelfSubjectRulesReview,SelfSubjectRulesReviewBuilder>{
  public SelfSubjectRulesReviewBuilder() {
    this(false);
  }
  public SelfSubjectRulesReviewBuilder(Boolean validationEnabled) {
    this(new SelfSubjectRulesReview(), validationEnabled);
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectRulesReview(), validationEnabled);
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,SelfSubjectRulesReview instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,SelfSubjectRulesReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReview instance) {
    this(instance,false);
  }
  public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectRulesReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectRulesReview build() {
    SelfSubjectRulesReview buildable = new SelfSubjectRulesReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}