package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TemplateFluentImpl<A extends TemplateFluent<A>> extends BaseFluent<A> implements TemplateFluent<A>{
  public TemplateFluentImpl() {
  }
  public TemplateFluentImpl(Template instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withLabels(instance.getLabels());
      this.withMessage(instance.getMessage());
      this.withMetadata(instance.getMetadata());
      this.withObjects(instance.getObjects());
      this.withParameters(instance.getParameters());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private Map<String,String> labels;
  private String message;
  private ObjectMetaBuilder metadata;
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
  private ArrayList<ParameterBuilder> parameters = new ArrayList<ParameterBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public TemplateFluentImpl.MetadataNested<A> withNewMetadata() {
    return new TemplateFluentImpl.MetadataNestedImpl();
  }
  public TemplateFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new TemplateFluentImpl.MetadataNestedImpl(item);
  }
  public TemplateFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public TemplateFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public TemplateFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToObjects(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
  }
  public A addToObjects(int index,VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A addToObjects(int index,HasMetadata item) {
    if (item instanceof ImageStreamImport){addToImageStreamImportObjects(index, (ImageStreamImport)item);}
 else if (item instanceof Project){addToProjectObjects(index, (Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects(index, (BuildConfig)item);}
 else if (item instanceof HelmChartRepository){addToHelmChartRepositoryObjects(index, (HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){addToRangeAllocationObjects(index, (RangeAllocation)item);}
 else if (item instanceof Route){addToRouteObjects(index, (Route)item);}
 else if (item instanceof ClusterNetwork){addToClusterNetworkObjects(index, (ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){addToUserOAuthAccessTokenObjects(index, (UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects(index, (ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){addToClusterResourceQuotaObjects(index, (ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects(index, (ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects(index, (OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects(index, (ClusterRole)item);}
 else if (item instanceof ImageTag){addToImageTagObjects(index, (ImageTag)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects(index, (OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects(index, (DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects(index, (RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects(index, (Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects(index, (GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){addToImageStreamMappingObjects(index, (ImageStreamMapping)item);}
 else if (item instanceof Role){addToRoleObjects(index, (Role)item);}
 else if (item instanceof BrokerTemplateInstance){addToBrokerTemplateInstanceObjects(index, (BrokerTemplateInstance)item);}
 else if (item instanceof User){addToUserObjects(index, (User)item);}
 else if (item instanceof ImageStreamImage){addToImageStreamImageObjects(index, (ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){addToTemplateInstanceObjects(index, (TemplateInstance)item);}
 else if (item instanceof Build){addToBuildObjects(index, (Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects(index, (ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects(index, (Group)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects(index, (ImageSignature)item);}
 else if (item instanceof HostSubnet){addToHostSubnetObjects(index, (HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects(index, (AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects(index, (SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects(index, (BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){addToEgressNetworkPolicyObjects(index, (EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects(index, (NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){addToUserIdentityMappingObjects(index, (UserIdentityMapping)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects(index, (ImageStream)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects(index, (OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects(index, (Identity)item);}

    else { VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    } return (A)this;
  }
  public A setToObjects(int index,HasMetadata item) {
    if (item instanceof ImageStreamImport){setToImageStreamImportObjects(index, (ImageStreamImport)item);}
 else if (item instanceof Project){setToProjectObjects(index, (Project)item);}
 else if (item instanceof BuildConfig){setToBuildConfigObjects(index, (BuildConfig)item);}
 else if (item instanceof HelmChartRepository){setToHelmChartRepositoryObjects(index, (HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){setToRangeAllocationObjects(index, (RangeAllocation)item);}
 else if (item instanceof Route){setToRouteObjects(index, (Route)item);}
 else if (item instanceof ClusterNetwork){setToClusterNetworkObjects(index, (ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){setToOAuthAuthorizeTokenObjects(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){setToUserOAuthAccessTokenObjects(index, (UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){setToClusterRoleBindingObjects(index, (ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){setToClusterResourceQuotaObjects(index, (ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){setToProjectRequestObjects(index, (ProjectRequest)item);}
 else if (item instanceof Template){setToTemplateObjects(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){setToOAuthClientAuthorizationObjects(index, (OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){setToClusterRoleObjects(index, (ClusterRole)item);}
 else if (item instanceof ImageTag){setToImageTagObjects(index, (ImageTag)item);}
 else if (item instanceof OAuthAccessToken){setToOAuthAccessTokenObjects(index, (OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){setToDeploymentConfigObjects(index, (DeploymentConfig)item);}
 else if (item instanceof RoleBinding){setToRoleBindingObjects(index, (RoleBinding)item);}
 else if (item instanceof Image){setToImageObjects(index, (Image)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimObjects(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){setToGenericKubernetesResourceObjects(index, (GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){setToImageStreamMappingObjects(index, (ImageStreamMapping)item);}
 else if (item instanceof Role){setToRoleObjects(index, (Role)item);}
 else if (item instanceof BrokerTemplateInstance){setToBrokerTemplateInstanceObjects(index, (BrokerTemplateInstance)item);}
 else if (item instanceof User){setToUserObjects(index, (User)item);}
 else if (item instanceof ImageStreamImage){setToImageStreamImageObjects(index, (ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){setToTemplateInstanceObjects(index, (TemplateInstance)item);}
 else if (item instanceof Build){setToBuildObjects(index, (Build)item);}
 else if (item instanceof RoleBindingRestriction){setToRoleBindingRestrictionObjects(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){setToImageStreamTagObjects(index, (ImageStreamTag)item);}
 else if (item instanceof Group){setToGroupObjects(index, (Group)item);}
 else if (item instanceof ImageSignature){setToImageSignatureObjects(index, (ImageSignature)item);}
 else if (item instanceof HostSubnet){setToHostSubnetObjects(index, (HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){setToAppliedClusterResourceQuotaObjects(index, (AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){setToSecurityContextConstraintsObjects(index, (SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){setToBuildRequestObjects(index, (BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){setToEgressNetworkPolicyObjects(index, (EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){setToNetNamespaceObjects(index, (NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){setToUserIdentityMappingObjects(index, (UserIdentityMapping)item);}
 else if (item instanceof ImageStream){setToImageStreamObjects(index, (ImageStream)item);}
 else if (item instanceof OAuthClient){setToOAuthClientObjects(index, (OAuthClient)item);}
 else if (item instanceof Identity){setToIdentityObjects(index, (Identity)item);}

    else { VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    } return (A)this;
  }
  public A addToObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
     if (items != null && items.length > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof ImageStreamImport){addToImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof HelmChartRepository){addToHelmChartRepositoryObjects((HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){addToRangeAllocationObjects((RangeAllocation)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof ClusterNetwork){addToClusterNetworkObjects((ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){addToUserOAuthAccessTokenObjects((UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){addToClusterResourceQuotaObjects((ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof ImageTag){addToImageTagObjects((ImageTag)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){addToImageStreamMappingObjects((ImageStreamMapping)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof BrokerTemplateInstance){addToBrokerTemplateInstanceObjects((BrokerTemplateInstance)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof ImageStreamImage){addToImageStreamImageObjects((ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){addToTemplateInstanceObjects((TemplateInstance)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof HostSubnet){addToHostSubnetObjects((HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects((AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){addToEgressNetworkPolicyObjects((EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){addToUserIdentityMappingObjects((UserIdentityMapping)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A addAllToObjects(Collection<HasMetadata> items) {
     if (items != null && items.size() > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof ImageStreamImport){addToImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof Project){addToProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){addToBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof HelmChartRepository){addToHelmChartRepositoryObjects((HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){addToRangeAllocationObjects((RangeAllocation)item);}
 else if (item instanceof Route){addToRouteObjects((Route)item);}
 else if (item instanceof ClusterNetwork){addToClusterNetworkObjects((ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){addToUserOAuthAccessTokenObjects((UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){addToClusterResourceQuotaObjects((ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){addToClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof ImageTag){addToImageTagObjects((ImageTag)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){addToImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){addToImageStreamMappingObjects((ImageStreamMapping)item);}
 else if (item instanceof Role){addToRoleObjects((Role)item);}
 else if (item instanceof BrokerTemplateInstance){addToBrokerTemplateInstanceObjects((BrokerTemplateInstance)item);}
 else if (item instanceof User){addToUserObjects((User)item);}
 else if (item instanceof ImageStreamImage){addToImageStreamImageObjects((ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){addToTemplateInstanceObjects((TemplateInstance)item);}
 else if (item instanceof Build){addToBuildObjects((Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupObjects((Group)item);}
 else if (item instanceof ImageSignature){addToImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof HostSubnet){addToHostSubnetObjects((HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){addToAppliedClusterResourceQuotaObjects((AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){addToBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){addToEgressNetworkPolicyObjects((EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){addToNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){addToUserIdentityMappingObjects((UserIdentityMapping)item);}
 else if (item instanceof ImageStream){addToImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClient){addToOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){addToIdentityObjects((Identity)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
    } return (A)this;
  }
  public A removeFromObjects(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
  }
  public A removeFromObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    for (HasMetadata item : items) {if (item instanceof ImageStreamImport){removeFromImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof HelmChartRepository){removeFromHelmChartRepositoryObjects((HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){removeFromRangeAllocationObjects((RangeAllocation)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof ClusterNetwork){removeFromClusterNetworkObjects((ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){removeFromUserOAuthAccessTokenObjects((UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){removeFromClusterResourceQuotaObjects((ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof ImageTag){removeFromImageTagObjects((ImageTag)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){removeFromImageStreamMappingObjects((ImageStreamMapping)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof BrokerTemplateInstance){removeFromBrokerTemplateInstanceObjects((BrokerTemplateInstance)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof ImageStreamImage){removeFromImageStreamImageObjects((ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){removeFromTemplateInstanceObjects((TemplateInstance)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof HostSubnet){removeFromHostSubnetObjects((HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){removeFromAppliedClusterResourceQuotaObjects((AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){removeFromEgressNetworkPolicyObjects((EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){removeFromNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){removeFromUserIdentityMappingObjects((UserIdentityMapping)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromObjects(Collection<HasMetadata> items) {
    for (HasMetadata item : items) {if (item instanceof ImageStreamImport){removeFromImageStreamImportObjects((ImageStreamImport)item);}
 else if (item instanceof Project){removeFromProjectObjects((Project)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigObjects((BuildConfig)item);}
 else if (item instanceof HelmChartRepository){removeFromHelmChartRepositoryObjects((HelmChartRepository)item);}
 else if (item instanceof RangeAllocation){removeFromRangeAllocationObjects((RangeAllocation)item);}
 else if (item instanceof Route){removeFromRouteObjects((Route)item);}
 else if (item instanceof ClusterNetwork){removeFromClusterNetworkObjects((ClusterNetwork)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenObjects((OAuthAuthorizeToken)item);}
 else if (item instanceof UserOAuthAccessToken){removeFromUserOAuthAccessTokenObjects((UserOAuthAccessToken)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingObjects((ClusterRoleBinding)item);}
 else if (item instanceof ClusterResourceQuota){removeFromClusterResourceQuotaObjects((ClusterResourceQuota)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestObjects((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateObjects((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationObjects((OAuthClientAuthorization)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleObjects((ClusterRole)item);}
 else if (item instanceof ImageTag){removeFromImageTagObjects((ImageTag)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenObjects((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigObjects((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingObjects((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageObjects((Image)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceObjects((GenericKubernetesResource)item);}
 else if (item instanceof ImageStreamMapping){removeFromImageStreamMappingObjects((ImageStreamMapping)item);}
 else if (item instanceof Role){removeFromRoleObjects((Role)item);}
 else if (item instanceof BrokerTemplateInstance){removeFromBrokerTemplateInstanceObjects((BrokerTemplateInstance)item);}
 else if (item instanceof User){removeFromUserObjects((User)item);}
 else if (item instanceof ImageStreamImage){removeFromImageStreamImageObjects((ImageStreamImage)item);}
 else if (item instanceof TemplateInstance){removeFromTemplateInstanceObjects((TemplateInstance)item);}
 else if (item instanceof Build){removeFromBuildObjects((Build)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionObjects((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagObjects((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupObjects((Group)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureObjects((ImageSignature)item);}
 else if (item instanceof HostSubnet){removeFromHostSubnetObjects((HostSubnet)item);}
 else if (item instanceof AppliedClusterResourceQuota){removeFromAppliedClusterResourceQuotaObjects((AppliedClusterResourceQuota)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsObjects((SecurityContextConstraints)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestObjects((BuildRequest)item);}
 else if (item instanceof EgressNetworkPolicy){removeFromEgressNetworkPolicyObjects((EgressNetworkPolicy)item);}
 else if (item instanceof NetNamespace){removeFromNetNamespaceObjects((NetNamespace)item);}
 else if (item instanceof UserIdentityMapping){removeFromUserIdentityMappingObjects((UserIdentityMapping)item);}
 else if (item instanceof ImageStream){removeFromImageStreamObjects((ImageStream)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientObjects((OAuthClient)item);}
 else if (item instanceof Identity){removeFromIdentityObjects((Identity)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HasMetadata> getObjects() {
    return build(objects);
  }
  public List<HasMetadata> buildObjects() {
    return build(objects);
  }
  public HasMetadata buildObject(int index) {
    return this.objects.get(index).build();
  }
  public HasMetadata buildFirstObject() {
    return this.objects.get(0).build();
  }
  public HasMetadata buildLastObject() {
    return this.objects.get(objects.size() - 1).build();
  }
  public HasMetadata buildMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingObject(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: objects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withObjects(List<HasMetadata> objects) {
    if (objects != null) {this.objects = new ArrayList(); for (HasMetadata item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
  }
  public A withObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects) {
    if (this.objects != null) {this.objects.clear(); _visitables.remove("objects"); }
    if (objects != null) {for (HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
  }
  public Boolean hasObjects() {
    return objects != null && !objects.isEmpty();
  }
  public A addToImageStreamImportObjects(int index,ImageStreamImport item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageStreamImportObjects(int index,ImageStreamImport item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamImportObjects(Collection<ImageStreamImport> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamImportObjects(io.fabric8.openshift.api.model.ImageStreamImport... items) {
    for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamImportObjects(Collection<ImageStreamImport> items) {
    for (ImageStreamImport item : items) {ImageStreamImportBuilder builder = new ImageStreamImportBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamImportObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject() {
    return new TemplateFluentImpl.ImageStreamImportObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item) {
    return new TemplateFluentImpl.ImageStreamImportObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(int index,ImageStreamImport item) {
    return new TemplateFluentImpl.ImageStreamImportObjectsNestedImpl(index, item);
  }
  public A addToProjectObjects(int index,Project item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ProjectBuilder builder = new ProjectBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToProjectObjects(int index,Project item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ProjectBuilder builder = new ProjectBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToProjectObjects(io.fabric8.openshift.api.model.Project... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToProjectObjects(Collection<Project> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromProjectObjects(io.fabric8.openshift.api.model.Project... items) {
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromProjectObjects(Collection<Project> items) {
    for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProjectObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ProjectObjectsNested<A> addNewProjectObject() {
    return new TemplateFluentImpl.ProjectObjectsNestedImpl();
  }
  public TemplateFluentImpl.ProjectObjectsNested<A> addNewProjectObjectLike(Project item) {
    return new TemplateFluentImpl.ProjectObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ProjectObjectsNested<A> setNewProjectObjectLike(int index,Project item) {
    return new TemplateFluentImpl.ProjectObjectsNestedImpl(index, item);
  }
  public A addToBuildConfigObjects(int index,BuildConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildConfigBuilder builder = new BuildConfigBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToBuildConfigObjects(int index,BuildConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildConfigBuilder builder = new BuildConfigBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildConfigObjects(Collection<BuildConfig> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildConfigObjects(io.fabric8.openshift.api.model.BuildConfig... items) {
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildConfigObjects(Collection<BuildConfig> items) {
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildConfigObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.BuildConfigObjectsNested<A> addNewBuildConfigObject() {
    return new TemplateFluentImpl.BuildConfigObjectsNestedImpl();
  }
  public TemplateFluentImpl.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item) {
    return new TemplateFluentImpl.BuildConfigObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(int index,BuildConfig item) {
    return new TemplateFluentImpl.BuildConfigObjectsNestedImpl(index, item);
  }
  public A addToHelmChartRepositoryObjects(int index,HelmChartRepository item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToHelmChartRepositoryObjects(int index,HelmChartRepository item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HelmChartRepository item : items) {HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToHelmChartRepositoryObjects(Collection<HelmChartRepository> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HelmChartRepository item : items) {HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromHelmChartRepositoryObjects(io.fabric8.openshift.api.model.HelmChartRepository... items) {
    for (HelmChartRepository item : items) {HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromHelmChartRepositoryObjects(Collection<HelmChartRepository> items) {
    for (HelmChartRepository item : items) {HelmChartRepositoryBuilder builder = new HelmChartRepositoryBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHelmChartRepositoryObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObject() {
    return new TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl();
  }
  public TemplateFluentImpl.HelmChartRepositoryObjectsNested<A> addNewHelmChartRepositoryObjectLike(HelmChartRepository item) {
    return new TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.HelmChartRepositoryObjectsNested<A> setNewHelmChartRepositoryObjectLike(int index,HelmChartRepository item) {
    return new TemplateFluentImpl.HelmChartRepositoryObjectsNestedImpl(index, item);
  }
  public A addToRangeAllocationObjects(int index,RangeAllocation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RangeAllocationBuilder builder = new RangeAllocationBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToRangeAllocationObjects(int index,RangeAllocation item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RangeAllocationBuilder builder = new RangeAllocationBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RangeAllocation item : items) {RangeAllocationBuilder builder = new RangeAllocationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRangeAllocationObjects(Collection<RangeAllocation> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RangeAllocation item : items) {RangeAllocationBuilder builder = new RangeAllocationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRangeAllocationObjects(io.fabric8.openshift.api.model.RangeAllocation... items) {
    for (RangeAllocation item : items) {RangeAllocationBuilder builder = new RangeAllocationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRangeAllocationObjects(Collection<RangeAllocation> items) {
    for (RangeAllocation item : items) {RangeAllocationBuilder builder = new RangeAllocationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRangeAllocationObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.RangeAllocationObjectsNested<A> addNewRangeAllocationObject() {
    return new TemplateFluentImpl.RangeAllocationObjectsNestedImpl();
  }
  public TemplateFluentImpl.RangeAllocationObjectsNested<A> addNewRangeAllocationObjectLike(RangeAllocation item) {
    return new TemplateFluentImpl.RangeAllocationObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.RangeAllocationObjectsNested<A> setNewRangeAllocationObjectLike(int index,RangeAllocation item) {
    return new TemplateFluentImpl.RangeAllocationObjectsNestedImpl(index, item);
  }
  public A addToRouteObjects(int index,Route item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RouteBuilder builder = new RouteBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToRouteObjects(int index,Route item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RouteBuilder builder = new RouteBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToRouteObjects(io.fabric8.openshift.api.model.Route... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRouteObjects(Collection<Route> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRouteObjects(io.fabric8.openshift.api.model.Route... items) {
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRouteObjects(Collection<Route> items) {
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRouteObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.RouteObjectsNested<A> addNewRouteObject() {
    return new TemplateFluentImpl.RouteObjectsNestedImpl();
  }
  public TemplateFluentImpl.RouteObjectsNested<A> addNewRouteObjectLike(Route item) {
    return new TemplateFluentImpl.RouteObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.RouteObjectsNested<A> setNewRouteObjectLike(int index,Route item) {
    return new TemplateFluentImpl.RouteObjectsNestedImpl(index, item);
  }
  public A addToClusterNetworkObjects(int index,ClusterNetwork item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToClusterNetworkObjects(int index,ClusterNetwork item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterNetwork item : items) {ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterNetworkObjects(Collection<ClusterNetwork> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterNetwork item : items) {ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterNetworkObjects(io.fabric8.openshift.api.model.ClusterNetwork... items) {
    for (ClusterNetwork item : items) {ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetworkObjects(Collection<ClusterNetwork> items) {
    for (ClusterNetwork item : items) {ClusterNetworkBuilder builder = new ClusterNetworkBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetworkObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ClusterNetworkObjectsNested<A> addNewClusterNetworkObject() {
    return new TemplateFluentImpl.ClusterNetworkObjectsNestedImpl();
  }
  public TemplateFluentImpl.ClusterNetworkObjectsNested<A> addNewClusterNetworkObjectLike(ClusterNetwork item) {
    return new TemplateFluentImpl.ClusterNetworkObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ClusterNetworkObjectsNested<A> setNewClusterNetworkObjectLike(int index,ClusterNetwork item) {
    return new TemplateFluentImpl.ClusterNetworkObjectsNestedImpl(index, item);
  }
  public A addToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthAuthorizeTokenObjects(io.fabric8.openshift.api.model.OAuthAuthorizeToken... items) {
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items) {
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthAuthorizeTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject() {
    return new TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl();
  }
  public TemplateFluentImpl.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item) {
    return new TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(int index,OAuthAuthorizeToken item) {
    return new TemplateFluentImpl.OAuthAuthorizeTokenObjectsNestedImpl(index, item);
  }
  public A addToUserOAuthAccessTokenObjects(int index,UserOAuthAccessToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToUserOAuthAccessTokenObjects(int index,UserOAuthAccessToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (UserOAuthAccessToken item : items) {UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserOAuthAccessTokenObjects(Collection<UserOAuthAccessToken> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (UserOAuthAccessToken item : items) {UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserOAuthAccessTokenObjects(io.fabric8.openshift.api.model.UserOAuthAccessToken... items) {
    for (UserOAuthAccessToken item : items) {UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserOAuthAccessTokenObjects(Collection<UserOAuthAccessToken> items) {
    for (UserOAuthAccessToken item : items) {UserOAuthAccessTokenBuilder builder = new UserOAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserOAuthAccessTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObject() {
    return new TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl();
  }
  public TemplateFluentImpl.UserOAuthAccessTokenObjectsNested<A> addNewUserOAuthAccessTokenObjectLike(UserOAuthAccessToken item) {
    return new TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.UserOAuthAccessTokenObjectsNested<A> setNewUserOAuthAccessTokenObjectLike(int index,UserOAuthAccessToken item) {
    return new TemplateFluentImpl.UserOAuthAccessTokenObjectsNestedImpl(index, item);
  }
  public A addToClusterRoleBindingObjects(int index,ClusterRoleBinding item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToClusterRoleBindingObjects(int index,ClusterRoleBinding item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterRoleBindingObjects(Collection<ClusterRoleBinding> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterRoleBindingObjects(io.fabric8.openshift.api.model.ClusterRoleBinding... items) {
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterRoleBindingObjects(Collection<ClusterRoleBinding> items) {
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterRoleBindingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject() {
    return new TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl();
  }
  public TemplateFluentImpl.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item) {
    return new TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(int index,ClusterRoleBinding item) {
    return new TemplateFluentImpl.ClusterRoleBindingObjectsNestedImpl(index, item);
  }
  public A addToClusterResourceQuotaObjects(int index,ClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToClusterResourceQuotaObjects(int index,ClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterResourceQuota item : items) {ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterResourceQuota item : items) {ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterResourceQuotaObjects(io.fabric8.openshift.api.model.ClusterResourceQuota... items) {
    for (ClusterResourceQuota item : items) {ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterResourceQuotaObjects(Collection<ClusterResourceQuota> items) {
    for (ClusterResourceQuota item : items) {ClusterResourceQuotaBuilder builder = new ClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterResourceQuotaObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObject() {
    return new TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl();
  }
  public TemplateFluentImpl.ClusterResourceQuotaObjectsNested<A> addNewClusterResourceQuotaObjectLike(ClusterResourceQuota item) {
    return new TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ClusterResourceQuotaObjectsNested<A> setNewClusterResourceQuotaObjectLike(int index,ClusterResourceQuota item) {
    return new TemplateFluentImpl.ClusterResourceQuotaObjectsNestedImpl(index, item);
  }
  public A addToProjectRequestObjects(int index,ProjectRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ProjectRequestBuilder builder = new ProjectRequestBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToProjectRequestObjects(int index,ProjectRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ProjectRequestBuilder builder = new ProjectRequestBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToProjectRequestObjects(Collection<ProjectRequest> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromProjectRequestObjects(io.fabric8.openshift.api.model.ProjectRequest... items) {
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromProjectRequestObjects(Collection<ProjectRequest> items) {
    for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromProjectRequestObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ProjectRequestObjectsNested<A> addNewProjectRequestObject() {
    return new TemplateFluentImpl.ProjectRequestObjectsNestedImpl();
  }
  public TemplateFluentImpl.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item) {
    return new TemplateFluentImpl.ProjectRequestObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(int index,ProjectRequest item) {
    return new TemplateFluentImpl.ProjectRequestObjectsNestedImpl(index, item);
  }
  public A addToTemplateObjects(int index,Template item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    TemplateBuilder builder = new TemplateBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToTemplateObjects(int index,Template item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    TemplateBuilder builder = new TemplateBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToTemplateObjects(io.fabric8.openshift.api.model.Template... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToTemplateObjects(Collection<Template> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromTemplateObjects(io.fabric8.openshift.api.model.Template... items) {
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromTemplateObjects(Collection<Template> items) {
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTemplateObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.TemplateObjectsNested<A> addNewTemplateObject() {
    return new TemplateFluentImpl.TemplateObjectsNestedImpl();
  }
  public TemplateFluentImpl.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item) {
    return new TemplateFluentImpl.TemplateObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.TemplateObjectsNested<A> setNewTemplateObjectLike(int index,Template item) {
    return new TemplateFluentImpl.TemplateObjectsNestedImpl(index, item);
  }
  public A addToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthClientAuthorizationObjects(io.fabric8.openshift.api.model.OAuthClientAuthorization... items) {
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items) {
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthClientAuthorizationObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject() {
    return new TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl();
  }
  public TemplateFluentImpl.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item) {
    return new TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(int index,OAuthClientAuthorization item) {
    return new TemplateFluentImpl.OAuthClientAuthorizationObjectsNestedImpl(index, item);
  }
  public A addToClusterRoleObjects(int index,ClusterRole item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterRoleBuilder builder = new ClusterRoleBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToClusterRoleObjects(int index,ClusterRole item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ClusterRoleBuilder builder = new ClusterRoleBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToClusterRoleObjects(Collection<ClusterRole> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromClusterRoleObjects(io.fabric8.openshift.api.model.ClusterRole... items) {
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterRoleObjects(Collection<ClusterRole> items) {
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterRoleObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ClusterRoleObjectsNested<A> addNewClusterRoleObject() {
    return new TemplateFluentImpl.ClusterRoleObjectsNestedImpl();
  }
  public TemplateFluentImpl.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item) {
    return new TemplateFluentImpl.ClusterRoleObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(int index,ClusterRole item) {
    return new TemplateFluentImpl.ClusterRoleObjectsNestedImpl(index, item);
  }
  public A addToImageTagObjects(int index,ImageTag item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageTagBuilder builder = new ImageTagBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageTagObjects(int index,ImageTag item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageTagBuilder builder = new ImageTagBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageTag item : items) {ImageTagBuilder builder = new ImageTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageTagObjects(Collection<ImageTag> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageTag item : items) {ImageTagBuilder builder = new ImageTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageTagObjects(io.fabric8.openshift.api.model.ImageTag... items) {
    for (ImageTag item : items) {ImageTagBuilder builder = new ImageTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageTagObjects(Collection<ImageTag> items) {
    for (ImageTag item : items) {ImageTagBuilder builder = new ImageTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageTagObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageTagObjectsNested<A> addNewImageTagObject() {
    return new TemplateFluentImpl.ImageTagObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageTagObjectsNested<A> addNewImageTagObjectLike(ImageTag item) {
    return new TemplateFluentImpl.ImageTagObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageTagObjectsNested<A> setNewImageTagObjectLike(int index,ImageTag item) {
    return new TemplateFluentImpl.ImageTagObjectsNestedImpl(index, item);
  }
  public A addToOAuthAccessTokenObjects(int index,OAuthAccessToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToOAuthAccessTokenObjects(int index,OAuthAccessToken item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthAccessTokenObjects(Collection<OAuthAccessToken> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthAccessTokenObjects(io.fabric8.openshift.api.model.OAuthAccessToken... items) {
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthAccessTokenObjects(Collection<OAuthAccessToken> items) {
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthAccessTokenObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject() {
    return new TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl();
  }
  public TemplateFluentImpl.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item) {
    return new TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(int index,OAuthAccessToken item) {
    return new TemplateFluentImpl.OAuthAccessTokenObjectsNestedImpl(index, item);
  }
  public A addToDeploymentConfigObjects(int index,DeploymentConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToDeploymentConfigObjects(int index,DeploymentConfig item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToDeploymentConfigObjects(Collection<DeploymentConfig> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromDeploymentConfigObjects(io.fabric8.openshift.api.model.DeploymentConfig... items) {
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromDeploymentConfigObjects(Collection<DeploymentConfig> items) {
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDeploymentConfigObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject() {
    return new TemplateFluentImpl.DeploymentConfigObjectsNestedImpl();
  }
  public TemplateFluentImpl.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item) {
    return new TemplateFluentImpl.DeploymentConfigObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(int index,DeploymentConfig item) {
    return new TemplateFluentImpl.DeploymentConfigObjectsNestedImpl(index, item);
  }
  public A addToRoleBindingObjects(int index,RoleBinding item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBindingBuilder builder = new RoleBindingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToRoleBindingObjects(int index,RoleBinding item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBindingBuilder builder = new RoleBindingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleBindingObjects(Collection<RoleBinding> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleBindingObjects(io.fabric8.openshift.api.model.RoleBinding... items) {
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleBindingObjects(Collection<RoleBinding> items) {
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleBindingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.RoleBindingObjectsNested<A> addNewRoleBindingObject() {
    return new TemplateFluentImpl.RoleBindingObjectsNestedImpl();
  }
  public TemplateFluentImpl.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item) {
    return new TemplateFluentImpl.RoleBindingObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(int index,RoleBinding item) {
    return new TemplateFluentImpl.RoleBindingObjectsNestedImpl(index, item);
  }
  public A addToImageObjects(int index,Image item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageObjects(int index,Image item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageBuilder builder = new ImageBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageObjects(io.fabric8.openshift.api.model.Image... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageObjects(Collection<Image> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageObjects(io.fabric8.openshift.api.model.Image... items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageObjects(Collection<Image> items) {
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageObjectsNested<A> addNewImageObject() {
    return new TemplateFluentImpl.ImageObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageObjectsNested<A> addNewImageObjectLike(Image item) {
    return new TemplateFluentImpl.ImageObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageObjectsNested<A> setNewImageObjectLike(int index,Image item) {
    return new TemplateFluentImpl.ImageObjectsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject() {
    return new TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl();
  }
  public TemplateFluentImpl.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item) {
    return new TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,PersistentVolumeClaim item) {
    return new TemplateFluentImpl.PersistentVolumeClaimObjectsNestedImpl(index, item);
  }
  public A addToGenericKubernetesResourceObjects(int index,GenericKubernetesResource item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToGenericKubernetesResourceObjects(int index,GenericKubernetesResource item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToGenericKubernetesResourceObjects(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToGenericKubernetesResourceObjects(Collection<GenericKubernetesResource> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromGenericKubernetesResourceObjects(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenericKubernetesResourceObjects(Collection<GenericKubernetesResource> items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenericKubernetesResourceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObject() {
    return new TemplateFluentImpl.GenericKubernetesResourceObjectsNestedImpl();
  }
  public TemplateFluentImpl.GenericKubernetesResourceObjectsNested<A> addNewGenericKubernetesResourceObjectLike(GenericKubernetesResource item) {
    return new TemplateFluentImpl.GenericKubernetesResourceObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.GenericKubernetesResourceObjectsNested<A> setNewGenericKubernetesResourceObjectLike(int index,GenericKubernetesResource item) {
    return new TemplateFluentImpl.GenericKubernetesResourceObjectsNestedImpl(index, item);
  }
  public A addToImageStreamMappingObjects(int index,ImageStreamMapping item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageStreamMappingObjects(int index,ImageStreamMapping item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamMapping item : items) {ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamMappingObjects(Collection<ImageStreamMapping> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamMapping item : items) {ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamMappingObjects(io.fabric8.openshift.api.model.ImageStreamMapping... items) {
    for (ImageStreamMapping item : items) {ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamMappingObjects(Collection<ImageStreamMapping> items) {
    for (ImageStreamMapping item : items) {ImageStreamMappingBuilder builder = new ImageStreamMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamMappingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObject() {
    return new TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageStreamMappingObjectsNested<A> addNewImageStreamMappingObjectLike(ImageStreamMapping item) {
    return new TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageStreamMappingObjectsNested<A> setNewImageStreamMappingObjectLike(int index,ImageStreamMapping item) {
    return new TemplateFluentImpl.ImageStreamMappingObjectsNestedImpl(index, item);
  }
  public A addToRoleObjects(int index,Role item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBuilder builder = new RoleBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToRoleObjects(int index,Role item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBuilder builder = new RoleBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToRoleObjects(io.fabric8.openshift.api.model.Role... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleObjects(Collection<Role> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleObjects(io.fabric8.openshift.api.model.Role... items) {
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleObjects(Collection<Role> items) {
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.RoleObjectsNested<A> addNewRoleObject() {
    return new TemplateFluentImpl.RoleObjectsNestedImpl();
  }
  public TemplateFluentImpl.RoleObjectsNested<A> addNewRoleObjectLike(Role item) {
    return new TemplateFluentImpl.RoleObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.RoleObjectsNested<A> setNewRoleObjectLike(int index,Role item) {
    return new TemplateFluentImpl.RoleObjectsNestedImpl(index, item);
  }
  public A addToBrokerTemplateInstanceObjects(int index,BrokerTemplateInstance item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToBrokerTemplateInstanceObjects(int index,BrokerTemplateInstance item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BrokerTemplateInstance item : items) {BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBrokerTemplateInstanceObjects(Collection<BrokerTemplateInstance> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BrokerTemplateInstance item : items) {BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBrokerTemplateInstanceObjects(io.fabric8.openshift.api.model.BrokerTemplateInstance... items) {
    for (BrokerTemplateInstance item : items) {BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBrokerTemplateInstanceObjects(Collection<BrokerTemplateInstance> items) {
    for (BrokerTemplateInstance item : items) {BrokerTemplateInstanceBuilder builder = new BrokerTemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBrokerTemplateInstanceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObject() {
    return new TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl();
  }
  public TemplateFluentImpl.BrokerTemplateInstanceObjectsNested<A> addNewBrokerTemplateInstanceObjectLike(BrokerTemplateInstance item) {
    return new TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.BrokerTemplateInstanceObjectsNested<A> setNewBrokerTemplateInstanceObjectLike(int index,BrokerTemplateInstance item) {
    return new TemplateFluentImpl.BrokerTemplateInstanceObjectsNestedImpl(index, item);
  }
  public A addToUserObjects(int index,User item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserBuilder builder = new UserBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToUserObjects(int index,User item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserBuilder builder = new UserBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToUserObjects(io.fabric8.openshift.api.model.User... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserObjects(Collection<User> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserObjects(io.fabric8.openshift.api.model.User... items) {
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserObjects(Collection<User> items) {
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.UserObjectsNested<A> addNewUserObject() {
    return new TemplateFluentImpl.UserObjectsNestedImpl();
  }
  public TemplateFluentImpl.UserObjectsNested<A> addNewUserObjectLike(User item) {
    return new TemplateFluentImpl.UserObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.UserObjectsNested<A> setNewUserObjectLike(int index,User item) {
    return new TemplateFluentImpl.UserObjectsNestedImpl(index, item);
  }
  public A addToImageStreamImageObjects(int index,ImageStreamImage item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageStreamImageObjects(int index,ImageStreamImage item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamImage item : items) {ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamImageObjects(Collection<ImageStreamImage> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamImage item : items) {ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamImageObjects(io.fabric8.openshift.api.model.ImageStreamImage... items) {
    for (ImageStreamImage item : items) {ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamImageObjects(Collection<ImageStreamImage> items) {
    for (ImageStreamImage item : items) {ImageStreamImageBuilder builder = new ImageStreamImageBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamImageObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageStreamImageObjectsNested<A> addNewImageStreamImageObject() {
    return new TemplateFluentImpl.ImageStreamImageObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageStreamImageObjectsNested<A> addNewImageStreamImageObjectLike(ImageStreamImage item) {
    return new TemplateFluentImpl.ImageStreamImageObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageStreamImageObjectsNested<A> setNewImageStreamImageObjectLike(int index,ImageStreamImage item) {
    return new TemplateFluentImpl.ImageStreamImageObjectsNestedImpl(index, item);
  }
  public A addToTemplateInstanceObjects(int index,TemplateInstance item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToTemplateInstanceObjects(int index,TemplateInstance item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (TemplateInstance item : items) {TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToTemplateInstanceObjects(Collection<TemplateInstance> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (TemplateInstance item : items) {TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromTemplateInstanceObjects(io.fabric8.openshift.api.model.TemplateInstance... items) {
    for (TemplateInstance item : items) {TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromTemplateInstanceObjects(Collection<TemplateInstance> items) {
    for (TemplateInstance item : items) {TemplateInstanceBuilder builder = new TemplateInstanceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTemplateInstanceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObject() {
    return new TemplateFluentImpl.TemplateInstanceObjectsNestedImpl();
  }
  public TemplateFluentImpl.TemplateInstanceObjectsNested<A> addNewTemplateInstanceObjectLike(TemplateInstance item) {
    return new TemplateFluentImpl.TemplateInstanceObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.TemplateInstanceObjectsNested<A> setNewTemplateInstanceObjectLike(int index,TemplateInstance item) {
    return new TemplateFluentImpl.TemplateInstanceObjectsNestedImpl(index, item);
  }
  public A addToBuildObjects(int index,Build item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildBuilder builder = new BuildBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToBuildObjects(int index,Build item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildBuilder builder = new BuildBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToBuildObjects(io.fabric8.openshift.api.model.Build... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildObjects(Collection<Build> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildObjects(io.fabric8.openshift.api.model.Build... items) {
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildObjects(Collection<Build> items) {
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.BuildObjectsNested<A> addNewBuildObject() {
    return new TemplateFluentImpl.BuildObjectsNestedImpl();
  }
  public TemplateFluentImpl.BuildObjectsNested<A> addNewBuildObjectLike(Build item) {
    return new TemplateFluentImpl.BuildObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.BuildObjectsNested<A> setNewBuildObjectLike(int index,Build item) {
    return new TemplateFluentImpl.BuildObjectsNestedImpl(index, item);
  }
  public A addToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromRoleBindingRestrictionObjects(io.fabric8.openshift.api.model.RoleBindingRestriction... items) {
    for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items) {
    for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoleBindingRestrictionObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject() {
    return new TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl();
  }
  public TemplateFluentImpl.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item) {
    return new TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(int index,RoleBindingRestriction item) {
    return new TemplateFluentImpl.RoleBindingRestrictionObjectsNestedImpl(index, item);
  }
  public A addToImageStreamTagObjects(int index,ImageStreamTag item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageStreamTagObjects(int index,ImageStreamTag item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamTagObjects(Collection<ImageStreamTag> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamTagObjects(io.fabric8.openshift.api.model.ImageStreamTag... items) {
    for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamTagObjects(Collection<ImageStreamTag> items) {
    for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamTagObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject() {
    return new TemplateFluentImpl.ImageStreamTagObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item) {
    return new TemplateFluentImpl.ImageStreamTagObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(int index,ImageStreamTag item) {
    return new TemplateFluentImpl.ImageStreamTagObjectsNestedImpl(index, item);
  }
  public A addToGroupObjects(int index,Group item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GroupBuilder builder = new GroupBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToGroupObjects(int index,Group item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GroupBuilder builder = new GroupBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToGroupObjects(io.fabric8.openshift.api.model.Group... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToGroupObjects(Collection<Group> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromGroupObjects(io.fabric8.openshift.api.model.Group... items) {
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromGroupObjects(Collection<Group> items) {
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGroupObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.GroupObjectsNested<A> addNewGroupObject() {
    return new TemplateFluentImpl.GroupObjectsNestedImpl();
  }
  public TemplateFluentImpl.GroupObjectsNested<A> addNewGroupObjectLike(Group item) {
    return new TemplateFluentImpl.GroupObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.GroupObjectsNested<A> setNewGroupObjectLike(int index,Group item) {
    return new TemplateFluentImpl.GroupObjectsNestedImpl(index, item);
  }
  public A addToImageSignatureObjects(int index,ImageSignature item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageSignatureObjects(int index,ImageSignature item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageSignatureObjects(Collection<ImageSignature> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageSignatureObjects(io.fabric8.openshift.api.model.ImageSignature... items) {
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageSignatureObjects(Collection<ImageSignature> items) {
    for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageSignatureObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageSignatureObjectsNested<A> addNewImageSignatureObject() {
    return new TemplateFluentImpl.ImageSignatureObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item) {
    return new TemplateFluentImpl.ImageSignatureObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(int index,ImageSignature item) {
    return new TemplateFluentImpl.ImageSignatureObjectsNestedImpl(index, item);
  }
  public A addToHostSubnetObjects(int index,HostSubnet item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    HostSubnetBuilder builder = new HostSubnetBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToHostSubnetObjects(int index,HostSubnet item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    HostSubnetBuilder builder = new HostSubnetBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HostSubnet item : items) {HostSubnetBuilder builder = new HostSubnetBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToHostSubnetObjects(Collection<HostSubnet> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HostSubnet item : items) {HostSubnetBuilder builder = new HostSubnetBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromHostSubnetObjects(io.fabric8.openshift.api.model.HostSubnet... items) {
    for (HostSubnet item : items) {HostSubnetBuilder builder = new HostSubnetBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromHostSubnetObjects(Collection<HostSubnet> items) {
    for (HostSubnet item : items) {HostSubnetBuilder builder = new HostSubnetBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHostSubnetObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.HostSubnetObjectsNested<A> addNewHostSubnetObject() {
    return new TemplateFluentImpl.HostSubnetObjectsNestedImpl();
  }
  public TemplateFluentImpl.HostSubnetObjectsNested<A> addNewHostSubnetObjectLike(HostSubnet item) {
    return new TemplateFluentImpl.HostSubnetObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.HostSubnetObjectsNested<A> setNewHostSubnetObjectLike(int index,HostSubnet item) {
    return new TemplateFluentImpl.HostSubnetObjectsNestedImpl(index, item);
  }
  public A addToAppliedClusterResourceQuotaObjects(int index,AppliedClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToAppliedClusterResourceQuotaObjects(int index,AppliedClusterResourceQuota item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (AppliedClusterResourceQuota item : items) {AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (AppliedClusterResourceQuota item : items) {AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromAppliedClusterResourceQuotaObjects(io.fabric8.openshift.api.model.AppliedClusterResourceQuota... items) {
    for (AppliedClusterResourceQuota item : items) {AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromAppliedClusterResourceQuotaObjects(Collection<AppliedClusterResourceQuota> items) {
    for (AppliedClusterResourceQuota item : items) {AppliedClusterResourceQuotaBuilder builder = new AppliedClusterResourceQuotaBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAppliedClusterResourceQuotaObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObject() {
    return new TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl();
  }
  public TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNested<A> addNewAppliedClusterResourceQuotaObjectLike(AppliedClusterResourceQuota item) {
    return new TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNested<A> setNewAppliedClusterResourceQuotaObjectLike(int index,AppliedClusterResourceQuota item) {
    return new TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNestedImpl(index, item);
  }
  public A addToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromSecurityContextConstraintsObjects(io.fabric8.openshift.api.model.SecurityContextConstraints... items) {
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items) {
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecurityContextConstraintsObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject() {
    return new TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl();
  }
  public TemplateFluentImpl.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item) {
    return new TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(int index,SecurityContextConstraints item) {
    return new TemplateFluentImpl.SecurityContextConstraintsObjectsNestedImpl(index, item);
  }
  public A addToBuildRequestObjects(int index,BuildRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildRequestBuilder builder = new BuildRequestBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToBuildRequestObjects(int index,BuildRequest item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BuildRequestBuilder builder = new BuildRequestBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToBuildRequestObjects(Collection<BuildRequest> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromBuildRequestObjects(io.fabric8.openshift.api.model.BuildRequest... items) {
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildRequestObjects(Collection<BuildRequest> items) {
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildRequestObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.BuildRequestObjectsNested<A> addNewBuildRequestObject() {
    return new TemplateFluentImpl.BuildRequestObjectsNestedImpl();
  }
  public TemplateFluentImpl.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item) {
    return new TemplateFluentImpl.BuildRequestObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(int index,BuildRequest item) {
    return new TemplateFluentImpl.BuildRequestObjectsNestedImpl(index, item);
  }
  public A addToEgressNetworkPolicyObjects(int index,EgressNetworkPolicy item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToEgressNetworkPolicyObjects(int index,EgressNetworkPolicy item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (EgressNetworkPolicy item : items) {EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (EgressNetworkPolicy item : items) {EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromEgressNetworkPolicyObjects(io.fabric8.openshift.api.model.EgressNetworkPolicy... items) {
    for (EgressNetworkPolicy item : items) {EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromEgressNetworkPolicyObjects(Collection<EgressNetworkPolicy> items) {
    for (EgressNetworkPolicy item : items) {EgressNetworkPolicyBuilder builder = new EgressNetworkPolicyBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEgressNetworkPolicyObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObject() {
    return new TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl();
  }
  public TemplateFluentImpl.EgressNetworkPolicyObjectsNested<A> addNewEgressNetworkPolicyObjectLike(EgressNetworkPolicy item) {
    return new TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.EgressNetworkPolicyObjectsNested<A> setNewEgressNetworkPolicyObjectLike(int index,EgressNetworkPolicy item) {
    return new TemplateFluentImpl.EgressNetworkPolicyObjectsNestedImpl(index, item);
  }
  public A addToNetNamespaceObjects(int index,NetNamespace item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToNetNamespaceObjects(int index,NetNamespace item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NetNamespaceBuilder builder = new NetNamespaceBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToNetNamespaceObjects(Collection<NetNamespace> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromNetNamespaceObjects(io.fabric8.openshift.api.model.NetNamespace... items) {
    for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromNetNamespaceObjects(Collection<NetNamespace> items) {
    for (NetNamespace item : items) {NetNamespaceBuilder builder = new NetNamespaceBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNetNamespaceObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.NetNamespaceObjectsNested<A> addNewNetNamespaceObject() {
    return new TemplateFluentImpl.NetNamespaceObjectsNestedImpl();
  }
  public TemplateFluentImpl.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item) {
    return new TemplateFluentImpl.NetNamespaceObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(int index,NetNamespace item) {
    return new TemplateFluentImpl.NetNamespaceObjectsNestedImpl(index, item);
  }
  public A addToUserIdentityMappingObjects(int index,UserIdentityMapping item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToUserIdentityMappingObjects(int index,UserIdentityMapping item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (UserIdentityMapping item : items) {UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToUserIdentityMappingObjects(Collection<UserIdentityMapping> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (UserIdentityMapping item : items) {UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromUserIdentityMappingObjects(io.fabric8.openshift.api.model.UserIdentityMapping... items) {
    for (UserIdentityMapping item : items) {UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromUserIdentityMappingObjects(Collection<UserIdentityMapping> items) {
    for (UserIdentityMapping item : items) {UserIdentityMappingBuilder builder = new UserIdentityMappingBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUserIdentityMappingObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObject() {
    return new TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl();
  }
  public TemplateFluentImpl.UserIdentityMappingObjectsNested<A> addNewUserIdentityMappingObjectLike(UserIdentityMapping item) {
    return new TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.UserIdentityMappingObjectsNested<A> setNewUserIdentityMappingObjectLike(int index,UserIdentityMapping item) {
    return new TemplateFluentImpl.UserIdentityMappingObjectsNestedImpl(index, item);
  }
  public A addToImageStreamObjects(int index,ImageStream item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamBuilder builder = new ImageStreamBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToImageStreamObjects(int index,ImageStream item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ImageStreamBuilder builder = new ImageStreamBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToImageStreamObjects(Collection<ImageStream> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromImageStreamObjects(io.fabric8.openshift.api.model.ImageStream... items) {
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageStreamObjects(Collection<ImageStream> items) {
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageStreamObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.ImageStreamObjectsNested<A> addNewImageStreamObject() {
    return new TemplateFluentImpl.ImageStreamObjectsNestedImpl();
  }
  public TemplateFluentImpl.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item) {
    return new TemplateFluentImpl.ImageStreamObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(int index,ImageStream item) {
    return new TemplateFluentImpl.ImageStreamObjectsNestedImpl(index, item);
  }
  public A addToOAuthClientObjects(int index,OAuthClient item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthClientBuilder builder = new OAuthClientBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToOAuthClientObjects(int index,OAuthClient item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    OAuthClientBuilder builder = new OAuthClientBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToOAuthClientObjects(Collection<OAuthClient> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromOAuthClientObjects(io.fabric8.openshift.api.model.OAuthClient... items) {
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromOAuthClientObjects(Collection<OAuthClient> items) {
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOAuthClientObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.OAuthClientObjectsNested<A> addNewOAuthClientObject() {
    return new TemplateFluentImpl.OAuthClientObjectsNestedImpl();
  }
  public TemplateFluentImpl.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item) {
    return new TemplateFluentImpl.OAuthClientObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(int index,OAuthClient item) {
    return new TemplateFluentImpl.OAuthClientObjectsNestedImpl(index, item);
  }
  public A addToIdentityObjects(int index,Identity item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    IdentityBuilder builder = new IdentityBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").add(index, builder); objects.add(index, builder);}
    return (A)this;
  }
  public A setToIdentityObjects(int index,Identity item) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    IdentityBuilder builder = new IdentityBuilder(item);
    if (index < 0 || index >= objects.size()) { _visitables.get("objects").add(builder); objects.add(builder); } else { _visitables.get("objects").set(index, builder); objects.set(index, builder);}
    return (A)this;
  }
  public A addToIdentityObjects(io.fabric8.openshift.api.model.Identity... items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A addAllToIdentityObjects(Collection<Identity> items) {
    if (this.objects == null) {this.objects = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
  }
  public A removeFromIdentityObjects(io.fabric8.openshift.api.model.Identity... items) {
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeAllFromIdentityObjects(Collection<Identity> items) {
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIdentityObjects(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (objects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = objects.iterator();
    final List visitables = _visitables.get("objects");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public TemplateFluentImpl.IdentityObjectsNested<A> addNewIdentityObject() {
    return new TemplateFluentImpl.IdentityObjectsNestedImpl();
  }
  public TemplateFluentImpl.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item) {
    return new TemplateFluentImpl.IdentityObjectsNestedImpl(-1, item);
  }
  public TemplateFluentImpl.IdentityObjectsNested<A> setNewIdentityObjectLike(int index,Identity item) {
    return new TemplateFluentImpl.IdentityObjectsNestedImpl(index, item);
  }
  public A addToParameters(int index,Parameter item) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    ParameterBuilder builder = new ParameterBuilder(item);
    if (index < 0 || index >= parameters.size()) { _visitables.get("parameters").add(builder); parameters.add(builder); } else { _visitables.get("parameters").add(index, builder); parameters.add(index, builder);}
    return (A)this;
  }
  public A setToParameters(int index,Parameter item) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    ParameterBuilder builder = new ParameterBuilder(item);
    if (index < 0 || index >= parameters.size()) { _visitables.get("parameters").add(builder); parameters.add(builder); } else { _visitables.get("parameters").set(index, builder); parameters.set(index, builder);}
    return (A)this;
  }
  public A addToParameters(io.fabric8.openshift.api.model.Parameter... items) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A addAllToParameters(Collection<Parameter> items) {
    if (this.parameters == null) {this.parameters = new ArrayList<ParameterBuilder>();}
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
  }
  public A removeFromParameters(io.fabric8.openshift.api.model.Parameter... items) {
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
  }
  public A removeAllFromParameters(Collection<Parameter> items) {
    for (Parameter item : items) {ParameterBuilder builder = new ParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate) {
    if (parameters == null) return (A) this;
    final Iterator<ParameterBuilder> each = parameters.iterator();
    final List visitables = _visitables.get("parameters");
    while (each.hasNext()) {
      ParameterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParameters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Parameter> getParameters() {
    return parameters != null ? build(parameters) : null;
  }
  public List<Parameter> buildParameters() {
    return parameters != null ? build(parameters) : null;
  }
  public Parameter buildParameter(int index) {
    return this.parameters.get(index).build();
  }
  public Parameter buildFirstParameter() {
    return this.parameters.get(0).build();
  }
  public Parameter buildLastParameter() {
    return this.parameters.get(parameters.size() - 1).build();
  }
  public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate) {
    for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate) {
    for (ParameterBuilder item: parameters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParameters(List<Parameter> parameters) {
    if (this.parameters != null) { _visitables.get("parameters").clear();}
    if (parameters != null) {this.parameters = new ArrayList(); for (Parameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
  }
  public A withParameters(io.fabric8.openshift.api.model.Parameter... parameters) {
    if (this.parameters != null) {this.parameters.clear(); _visitables.remove("parameters"); }
    if (parameters != null) {for (Parameter item :parameters){ this.addToParameters(item);}} return (A) this;
  }
  public Boolean hasParameters() {
    return parameters != null && !parameters.isEmpty();
  }
  public TemplateFluentImpl.ParametersNested<A> addNewParameter() {
    return new TemplateFluentImpl.ParametersNestedImpl();
  }
  public TemplateFluentImpl.ParametersNested<A> addNewParameterLike(Parameter item) {
    return new TemplateFluentImpl.ParametersNestedImpl(-1, item);
  }
  public TemplateFluentImpl.ParametersNested<A> setNewParameterLike(int index,Parameter item) {
    return new TemplateFluentImpl.ParametersNestedImpl(index, item);
  }
  public TemplateFluentImpl.ParametersNested<A> editParameter(int index) {
    if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public TemplateFluentImpl.ParametersNested<A> editFirstParameter() {
    if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
    return setNewParameterLike(0, buildParameter(0));
  }
  public TemplateFluentImpl.ParametersNested<A> editLastParameter() {
    int index = parameters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public TemplateFluentImpl.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parameters.size();i++) { 
    if (predicate.test(parameters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
    return setNewParameterLike(index, buildParameter(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateFluentImpl that = (TemplateFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(objects, that.objects)) return false;

    if (!java.util.Objects.equals(parameters, that.parameters)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  labels,  message,  metadata,  objects,  parameters,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (objects != null && !objects.isEmpty()) { sb.append("objects:"); sb.append(objects + ","); }
    if (parameters != null && !parameters.isEmpty()) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<TemplateFluentImpl.MetadataNested<N>> implements TemplateFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) TemplateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class ImageStreamImportObjectsNestedImpl<N> extends ImageStreamImportFluentImpl<TemplateFluentImpl.ImageStreamImportObjectsNested<N>> implements TemplateFluentImpl.ImageStreamImportObjectsNested<N>,Nested<N>{
    ImageStreamImportObjectsNestedImpl(int index,ImageStreamImport item) {
      this.index = index;
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImportObject() {
      return and();
    }
    
  }
  class ProjectObjectsNestedImpl<N> extends ProjectFluentImpl<TemplateFluentImpl.ProjectObjectsNested<N>> implements TemplateFluentImpl.ProjectObjectsNested<N>,Nested<N>{
    ProjectObjectsNestedImpl(int index,Project item) {
      this.index = index;
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectObject() {
      return and();
    }
    
  }
  class BuildConfigObjectsNestedImpl<N> extends BuildConfigFluentImpl<TemplateFluentImpl.BuildConfigObjectsNested<N>> implements TemplateFluentImpl.BuildConfigObjectsNested<N>,Nested<N>{
    BuildConfigObjectsNestedImpl(int index,BuildConfig item) {
      this.index = index;
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildConfigObject() {
      return and();
    }
    
  }
  class HelmChartRepositoryObjectsNestedImpl<N> extends HelmChartRepositoryFluentImpl<TemplateFluentImpl.HelmChartRepositoryObjectsNested<N>> implements TemplateFluentImpl.HelmChartRepositoryObjectsNested<N>,Nested<N>{
    HelmChartRepositoryObjectsNestedImpl(int index,HelmChartRepository item) {
      this.index = index;
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryObjectsNestedImpl() {
      this.index = -1;
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endHelmChartRepositoryObject() {
      return and();
    }
    
  }
  class RangeAllocationObjectsNestedImpl<N> extends RangeAllocationFluentImpl<TemplateFluentImpl.RangeAllocationObjectsNested<N>> implements TemplateFluentImpl.RangeAllocationObjectsNested<N>,Nested<N>{
    RangeAllocationObjectsNestedImpl(int index,RangeAllocation item) {
      this.index = index;
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRangeAllocationObject() {
      return and();
    }
    
  }
  class RouteObjectsNestedImpl<N> extends RouteFluentImpl<TemplateFluentImpl.RouteObjectsNested<N>> implements TemplateFluentImpl.RouteObjectsNested<N>,Nested<N>{
    RouteObjectsNestedImpl(int index,Route item) {
      this.index = index;
      this.builder = new RouteBuilder(this, item);
    }
    RouteObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRouteObject() {
      return and();
    }
    
  }
  class ClusterNetworkObjectsNestedImpl<N> extends ClusterNetworkFluentImpl<TemplateFluentImpl.ClusterNetworkObjectsNested<N>> implements TemplateFluentImpl.ClusterNetworkObjectsNested<N>,Nested<N>{
    ClusterNetworkObjectsNestedImpl(int index,ClusterNetwork item) {
      this.index = index;
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterNetworkObject() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenObjectsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<TemplateFluentImpl.OAuthAuthorizeTokenObjectsNested<N>> implements TemplateFluentImpl.OAuthAuthorizeTokenObjectsNested<N>,Nested<N>{
    OAuthAuthorizeTokenObjectsNestedImpl(int index,OAuthAuthorizeToken item) {
      this.index = index;
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAuthorizeTokenObject() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenObjectsNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<TemplateFluentImpl.UserOAuthAccessTokenObjectsNested<N>> implements TemplateFluentImpl.UserOAuthAccessTokenObjectsNested<N>,Nested<N>{
    UserOAuthAccessTokenObjectsNestedImpl(int index,UserOAuthAccessToken item) {
      this.index = index;
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserOAuthAccessTokenObject() {
      return and();
    }
    
  }
  class ClusterRoleBindingObjectsNestedImpl<N> extends ClusterRoleBindingFluentImpl<TemplateFluentImpl.ClusterRoleBindingObjectsNested<N>> implements TemplateFluentImpl.ClusterRoleBindingObjectsNested<N>,Nested<N>{
    ClusterRoleBindingObjectsNestedImpl(int index,ClusterRoleBinding item) {
      this.index = index;
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleBindingObject() {
      return and();
    }
    
  }
  class ClusterResourceQuotaObjectsNestedImpl<N> extends ClusterResourceQuotaFluentImpl<TemplateFluentImpl.ClusterResourceQuotaObjectsNested<N>> implements TemplateFluentImpl.ClusterResourceQuotaObjectsNested<N>,Nested<N>{
    ClusterResourceQuotaObjectsNestedImpl(int index,ClusterResourceQuota item) {
      this.index = index;
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterResourceQuotaObject() {
      return and();
    }
    
  }
  class ProjectRequestObjectsNestedImpl<N> extends ProjectRequestFluentImpl<TemplateFluentImpl.ProjectRequestObjectsNested<N>> implements TemplateFluentImpl.ProjectRequestObjectsNested<N>,Nested<N>{
    ProjectRequestObjectsNestedImpl(int index,ProjectRequest item) {
      this.index = index;
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endProjectRequestObject() {
      return and();
    }
    
  }
  class TemplateObjectsNestedImpl<N> extends TemplateFluentImpl<TemplateFluentImpl.TemplateObjectsNested<N>> implements TemplateFluentImpl.TemplateObjectsNested<N>,Nested<N>{
    TemplateObjectsNestedImpl(int index,Template item) {
      this.index = index;
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateObjectsNestedImpl() {
      this.index = -1;
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTemplateObject() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationObjectsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<TemplateFluentImpl.OAuthClientAuthorizationObjectsNested<N>> implements TemplateFluentImpl.OAuthClientAuthorizationObjectsNested<N>,Nested<N>{
    OAuthClientAuthorizationObjectsNestedImpl(int index,OAuthClientAuthorization item) {
      this.index = index;
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationObjectsNestedImpl() {
      this.index = -1;
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientAuthorizationObject() {
      return and();
    }
    
  }
  class ClusterRoleObjectsNestedImpl<N> extends ClusterRoleFluentImpl<TemplateFluentImpl.ClusterRoleObjectsNested<N>> implements TemplateFluentImpl.ClusterRoleObjectsNested<N>,Nested<N>{
    ClusterRoleObjectsNestedImpl(int index,ClusterRole item) {
      this.index = index;
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endClusterRoleObject() {
      return and();
    }
    
  }
  class ImageTagObjectsNestedImpl<N> extends ImageTagFluentImpl<TemplateFluentImpl.ImageTagObjectsNested<N>> implements TemplateFluentImpl.ImageTagObjectsNested<N>,Nested<N>{
    ImageTagObjectsNestedImpl(int index,ImageTag item) {
      this.index = index;
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageTagObject() {
      return and();
    }
    
  }
  class OAuthAccessTokenObjectsNestedImpl<N> extends OAuthAccessTokenFluentImpl<TemplateFluentImpl.OAuthAccessTokenObjectsNested<N>> implements TemplateFluentImpl.OAuthAccessTokenObjectsNested<N>,Nested<N>{
    OAuthAccessTokenObjectsNestedImpl(int index,OAuthAccessToken item) {
      this.index = index;
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenObjectsNestedImpl() {
      this.index = -1;
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthAccessTokenObject() {
      return and();
    }
    
  }
  class DeploymentConfigObjectsNestedImpl<N> extends DeploymentConfigFluentImpl<TemplateFluentImpl.DeploymentConfigObjectsNested<N>> implements TemplateFluentImpl.DeploymentConfigObjectsNested<N>,Nested<N>{
    DeploymentConfigObjectsNestedImpl(int index,DeploymentConfig item) {
      this.index = index;
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigObjectsNestedImpl() {
      this.index = -1;
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endDeploymentConfigObject() {
      return and();
    }
    
  }
  class RoleBindingObjectsNestedImpl<N> extends RoleBindingFluentImpl<TemplateFluentImpl.RoleBindingObjectsNested<N>> implements TemplateFluentImpl.RoleBindingObjectsNested<N>,Nested<N>{
    RoleBindingObjectsNestedImpl(int index,RoleBinding item) {
      this.index = index;
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingObject() {
      return and();
    }
    
  }
  class ImageObjectsNestedImpl<N> extends ImageFluentImpl<TemplateFluentImpl.ImageObjectsNested<N>> implements TemplateFluentImpl.ImageObjectsNested<N>,Nested<N>{
    ImageObjectsNestedImpl(int index,Image item) {
      this.index = index;
      this.builder = new ImageBuilder(this, item);
    }
    ImageObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageObject() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObjectsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<TemplateFluentImpl.PersistentVolumeClaimObjectsNested<N>> implements TemplateFluentImpl.PersistentVolumeClaimObjectsNested<N>,Nested<N>{
    PersistentVolumeClaimObjectsNestedImpl(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObjectsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endPersistentVolumeClaimObject() {
      return and();
    }
    
  }
  class GenericKubernetesResourceObjectsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<TemplateFluentImpl.GenericKubernetesResourceObjectsNested<N>> implements TemplateFluentImpl.GenericKubernetesResourceObjectsNested<N>,Nested<N>{
    GenericKubernetesResourceObjectsNestedImpl(int index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endGenericKubernetesResourceObject() {
      return and();
    }
    
  }
  class ImageStreamMappingObjectsNestedImpl<N> extends ImageStreamMappingFluentImpl<TemplateFluentImpl.ImageStreamMappingObjectsNested<N>> implements TemplateFluentImpl.ImageStreamMappingObjectsNested<N>,Nested<N>{
    ImageStreamMappingObjectsNestedImpl(int index,ImageStreamMapping item) {
      this.index = index;
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamMappingObject() {
      return and();
    }
    
  }
  class RoleObjectsNestedImpl<N> extends RoleFluentImpl<TemplateFluentImpl.RoleObjectsNested<N>> implements TemplateFluentImpl.RoleObjectsNested<N>,Nested<N>{
    RoleObjectsNestedImpl(int index,Role item) {
      this.index = index;
      this.builder = new RoleBuilder(this, item);
    }
    RoleObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleObject() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceObjectsNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<TemplateFluentImpl.BrokerTemplateInstanceObjectsNested<N>> implements TemplateFluentImpl.BrokerTemplateInstanceObjectsNested<N>,Nested<N>{
    BrokerTemplateInstanceObjectsNestedImpl(int index,BrokerTemplateInstance item) {
      this.index = index;
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBrokerTemplateInstanceObject() {
      return and();
    }
    
  }
  class UserObjectsNestedImpl<N> extends UserFluentImpl<TemplateFluentImpl.UserObjectsNested<N>> implements TemplateFluentImpl.UserObjectsNested<N>,Nested<N>{
    UserObjectsNestedImpl(int index,User item) {
      this.index = index;
      this.builder = new UserBuilder(this, item);
    }
    UserObjectsNestedImpl() {
      this.index = -1;
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserObject() {
      return and();
    }
    
  }
  class ImageStreamImageObjectsNestedImpl<N> extends ImageStreamImageFluentImpl<TemplateFluentImpl.ImageStreamImageObjectsNested<N>> implements TemplateFluentImpl.ImageStreamImageObjectsNested<N>,Nested<N>{
    ImageStreamImageObjectsNestedImpl(int index,ImageStreamImage item) {
      this.index = index;
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamImageObject() {
      return and();
    }
    
  }
  class TemplateInstanceObjectsNestedImpl<N> extends TemplateInstanceFluentImpl<TemplateFluentImpl.TemplateInstanceObjectsNested<N>> implements TemplateFluentImpl.TemplateInstanceObjectsNested<N>,Nested<N>{
    TemplateInstanceObjectsNestedImpl(int index,TemplateInstance item) {
      this.index = index;
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endTemplateInstanceObject() {
      return and();
    }
    
  }
  class BuildObjectsNestedImpl<N> extends BuildFluentImpl<TemplateFluentImpl.BuildObjectsNested<N>> implements TemplateFluentImpl.BuildObjectsNested<N>,Nested<N>{
    BuildObjectsNestedImpl(int index,Build item) {
      this.index = index;
      this.builder = new BuildBuilder(this, item);
    }
    BuildObjectsNestedImpl() {
      this.index = -1;
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildObject() {
      return and();
    }
    
  }
  class RoleBindingRestrictionObjectsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<TemplateFluentImpl.RoleBindingRestrictionObjectsNested<N>> implements TemplateFluentImpl.RoleBindingRestrictionObjectsNested<N>,Nested<N>{
    RoleBindingRestrictionObjectsNestedImpl(int index,RoleBindingRestriction item) {
      this.index = index;
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionObjectsNestedImpl() {
      this.index = -1;
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endRoleBindingRestrictionObject() {
      return and();
    }
    
  }
  class ImageStreamTagObjectsNestedImpl<N> extends ImageStreamTagFluentImpl<TemplateFluentImpl.ImageStreamTagObjectsNested<N>> implements TemplateFluentImpl.ImageStreamTagObjectsNested<N>,Nested<N>{
    ImageStreamTagObjectsNestedImpl(int index,ImageStreamTag item) {
      this.index = index;
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamTagObject() {
      return and();
    }
    
  }
  class GroupObjectsNestedImpl<N> extends GroupFluentImpl<TemplateFluentImpl.GroupObjectsNested<N>> implements TemplateFluentImpl.GroupObjectsNested<N>,Nested<N>{
    GroupObjectsNestedImpl(int index,Group item) {
      this.index = index;
      this.builder = new GroupBuilder(this, item);
    }
    GroupObjectsNestedImpl() {
      this.index = -1;
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endGroupObject() {
      return and();
    }
    
  }
  class ImageSignatureObjectsNestedImpl<N> extends ImageSignatureFluentImpl<TemplateFluentImpl.ImageSignatureObjectsNested<N>> implements TemplateFluentImpl.ImageSignatureObjectsNested<N>,Nested<N>{
    ImageSignatureObjectsNestedImpl(int index,ImageSignature item) {
      this.index = index;
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageSignatureObject() {
      return and();
    }
    
  }
  class HostSubnetObjectsNestedImpl<N> extends HostSubnetFluentImpl<TemplateFluentImpl.HostSubnetObjectsNested<N>> implements TemplateFluentImpl.HostSubnetObjectsNested<N>,Nested<N>{
    HostSubnetObjectsNestedImpl(int index,HostSubnet item) {
      this.index = index;
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetObjectsNestedImpl() {
      this.index = -1;
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endHostSubnetObject() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaObjectsNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNested<N>> implements TemplateFluentImpl.AppliedClusterResourceQuotaObjectsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaObjectsNestedImpl(int index,AppliedClusterResourceQuota item) {
      this.index = index;
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaObjectsNestedImpl() {
      this.index = -1;
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endAppliedClusterResourceQuotaObject() {
      return and();
    }
    
  }
  class SecurityContextConstraintsObjectsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<TemplateFluentImpl.SecurityContextConstraintsObjectsNested<N>> implements TemplateFluentImpl.SecurityContextConstraintsObjectsNested<N>,Nested<N>{
    SecurityContextConstraintsObjectsNestedImpl(int index,SecurityContextConstraints item) {
      this.index = index;
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsObjectsNestedImpl() {
      this.index = -1;
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endSecurityContextConstraintsObject() {
      return and();
    }
    
  }
  class BuildRequestObjectsNestedImpl<N> extends BuildRequestFluentImpl<TemplateFluentImpl.BuildRequestObjectsNested<N>> implements TemplateFluentImpl.BuildRequestObjectsNested<N>,Nested<N>{
    BuildRequestObjectsNestedImpl(int index,BuildRequest item) {
      this.index = index;
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestObjectsNestedImpl() {
      this.index = -1;
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endBuildRequestObject() {
      return and();
    }
    
  }
  class EgressNetworkPolicyObjectsNestedImpl<N> extends EgressNetworkPolicyFluentImpl<TemplateFluentImpl.EgressNetworkPolicyObjectsNested<N>> implements TemplateFluentImpl.EgressNetworkPolicyObjectsNested<N>,Nested<N>{
    EgressNetworkPolicyObjectsNestedImpl(int index,EgressNetworkPolicy item) {
      this.index = index;
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyObjectsNestedImpl() {
      this.index = -1;
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endEgressNetworkPolicyObject() {
      return and();
    }
    
  }
  class NetNamespaceObjectsNestedImpl<N> extends NetNamespaceFluentImpl<TemplateFluentImpl.NetNamespaceObjectsNested<N>> implements TemplateFluentImpl.NetNamespaceObjectsNested<N>,Nested<N>{
    NetNamespaceObjectsNestedImpl(int index,NetNamespace item) {
      this.index = index;
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceObjectsNestedImpl() {
      this.index = -1;
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endNetNamespaceObject() {
      return and();
    }
    
  }
  class UserIdentityMappingObjectsNestedImpl<N> extends UserIdentityMappingFluentImpl<TemplateFluentImpl.UserIdentityMappingObjectsNested<N>> implements TemplateFluentImpl.UserIdentityMappingObjectsNested<N>,Nested<N>{
    UserIdentityMappingObjectsNestedImpl(int index,UserIdentityMapping item) {
      this.index = index;
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingObjectsNestedImpl() {
      this.index = -1;
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endUserIdentityMappingObject() {
      return and();
    }
    
  }
  class ImageStreamObjectsNestedImpl<N> extends ImageStreamFluentImpl<TemplateFluentImpl.ImageStreamObjectsNested<N>> implements TemplateFluentImpl.ImageStreamObjectsNested<N>,Nested<N>{
    ImageStreamObjectsNestedImpl(int index,ImageStream item) {
      this.index = index;
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endImageStreamObject() {
      return and();
    }
    
  }
  class OAuthClientObjectsNestedImpl<N> extends OAuthClientFluentImpl<TemplateFluentImpl.OAuthClientObjectsNested<N>> implements TemplateFluentImpl.OAuthClientObjectsNested<N>,Nested<N>{
    OAuthClientObjectsNestedImpl(int index,OAuthClient item) {
      this.index = index;
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientObjectsNestedImpl() {
      this.index = -1;
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endOAuthClientObject() {
      return and();
    }
    
  }
  class IdentityObjectsNestedImpl<N> extends IdentityFluentImpl<TemplateFluentImpl.IdentityObjectsNested<N>> implements TemplateFluentImpl.IdentityObjectsNested<N>,Nested<N>{
    IdentityObjectsNestedImpl(int index,Identity item) {
      this.index = index;
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityObjectsNestedImpl() {
      this.index = -1;
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToObjects(index,builder.build());
    }
    public N endIdentityObject() {
      return and();
    }
    
  }
  class ParametersNestedImpl<N> extends ParameterFluentImpl<TemplateFluentImpl.ParametersNested<N>> implements TemplateFluentImpl.ParametersNested<N>,Nested<N>{
    ParametersNestedImpl(int index,Parameter item) {
      this.index = index;
      this.builder = new ParameterBuilder(this, item);
    }
    ParametersNestedImpl() {
      this.index = -1;
      this.builder = new ParameterBuilder(this);
    }
    ParameterBuilder builder;
    int index;
    public N and() {
      return (N) TemplateFluentImpl.this.setToParameters(index,builder.build());
    }
    public N endParameter() {
      return and();
    }
    
  }
  
}