package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UserIdentityMappingFluentImpl<A extends UserIdentityMappingFluent<A>> extends BaseFluent<A> implements UserIdentityMappingFluent<A>{
  public UserIdentityMappingFluentImpl() {
  }
  public UserIdentityMappingFluentImpl(UserIdentityMapping instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withIdentity(instance.getIdentity());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ObjectReferenceBuilder identity;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ObjectReferenceBuilder user;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIdentity instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIdentity() {
    return this.identity!=null ?this.identity.build():null;
  }
  public ObjectReference buildIdentity() {
    return this.identity!=null ?this.identity.build():null;
  }
  public A withIdentity(ObjectReference identity) {
    _visitables.get("identity").remove(this.identity);
    if (identity!=null){ this.identity= new ObjectReferenceBuilder(identity); _visitables.get("identity").add(this.identity);} else { this.identity = null; _visitables.get("identity").remove(this.identity); } return (A) this;
  }
  public Boolean hasIdentity() {
    return this.identity != null;
  }
  public UserIdentityMappingFluentImpl.IdentityNested<A> withNewIdentity() {
    return new UserIdentityMappingFluentImpl.IdentityNestedImpl();
  }
  public UserIdentityMappingFluentImpl.IdentityNested<A> withNewIdentityLike(ObjectReference item) {
    return new UserIdentityMappingFluentImpl.IdentityNestedImpl(item);
  }
  public UserIdentityMappingFluentImpl.IdentityNested<A> editIdentity() {
    return withNewIdentityLike(getIdentity());
  }
  public UserIdentityMappingFluentImpl.IdentityNested<A> editOrNewIdentity() {
    return withNewIdentityLike(getIdentity() != null ? getIdentity(): new ObjectReferenceBuilder().build());
  }
  public UserIdentityMappingFluentImpl.IdentityNested<A> editOrNewIdentityLike(ObjectReference item) {
    return withNewIdentityLike(getIdentity() != null ? getIdentity(): item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public UserIdentityMappingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new UserIdentityMappingFluentImpl.MetadataNestedImpl();
  }
  public UserIdentityMappingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new UserIdentityMappingFluentImpl.MetadataNestedImpl(item);
  }
  public UserIdentityMappingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public UserIdentityMappingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public UserIdentityMappingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getUser() {
    return this.user!=null ?this.user.build():null;
  }
  public ObjectReference buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(ObjectReference user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new ObjectReferenceBuilder(user); _visitables.get("user").add(this.user);} else { this.user = null; _visitables.get("user").remove(this.user); } return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public UserIdentityMappingFluentImpl.UserNested<A> withNewUser() {
    return new UserIdentityMappingFluentImpl.UserNestedImpl();
  }
  public UserIdentityMappingFluentImpl.UserNested<A> withNewUserLike(ObjectReference item) {
    return new UserIdentityMappingFluentImpl.UserNestedImpl(item);
  }
  public UserIdentityMappingFluentImpl.UserNested<A> editUser() {
    return withNewUserLike(getUser());
  }
  public UserIdentityMappingFluentImpl.UserNested<A> editOrNewUser() {
    return withNewUserLike(getUser() != null ? getUser(): new ObjectReferenceBuilder().build());
  }
  public UserIdentityMappingFluentImpl.UserNested<A> editOrNewUserLike(ObjectReference item) {
    return withNewUserLike(getUser() != null ? getUser(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    UserIdentityMappingFluentImpl that = (UserIdentityMappingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(identity, that.identity)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  identity,  kind,  metadata,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (identity != null) { sb.append("identity:"); sb.append(identity + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class IdentityNestedImpl<N> extends ObjectReferenceFluentImpl<UserIdentityMappingFluentImpl.IdentityNested<N>> implements UserIdentityMappingFluentImpl.IdentityNested<N>,Nested<N>{
    IdentityNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IdentityNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluentImpl.this.withIdentity(builder.build());
    }
    public N endIdentity() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<UserIdentityMappingFluentImpl.MetadataNested<N>> implements UserIdentityMappingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class UserNestedImpl<N> extends ObjectReferenceFluentImpl<UserIdentityMappingFluentImpl.UserNested<N>> implements UserIdentityMappingFluentImpl.UserNested<N>,Nested<N>{
    UserNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    UserNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluentImpl.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}