package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface DeploymentConfigStatusFluent<A extends DeploymentConfigStatusFluent<A>> extends Fluent<A>{
  public Integer getAvailableReplicas();
  public A withAvailableReplicas(Integer availableReplicas);
  public Boolean hasAvailableReplicas();
  public A addToConditions(int index,DeploymentCondition item);
  public A setToConditions(int index,DeploymentCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.DeploymentCondition... items);
  public A addAllToConditions(Collection<DeploymentCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.DeploymentCondition... items);
  public A removeAllFromConditions(Collection<DeploymentCondition> items);
  public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DeploymentCondition> getConditions();
  public List<DeploymentCondition> buildConditions();
  public DeploymentCondition buildCondition(int index);
  public DeploymentCondition buildFirstCondition();
  public DeploymentCondition buildLastCondition();
  public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
  public A withConditions(List<DeploymentCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.DeploymentCondition... conditions);
  public Boolean hasConditions();
  public DeploymentConfigStatusFluent.ConditionsNested<A> addNewCondition();
  public DeploymentConfigStatusFluent.ConditionsNested<A> addNewConditionLike(DeploymentCondition item);
  public DeploymentConfigStatusFluent.ConditionsNested<A> setNewConditionLike(int index,DeploymentCondition item);
  public DeploymentConfigStatusFluent.ConditionsNested<A> editCondition(int index);
  public DeploymentConfigStatusFluent.ConditionsNested<A> editFirstCondition();
  public DeploymentConfigStatusFluent.ConditionsNested<A> editLastCondition();
  public DeploymentConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeploymentDetails getDetails();
  public DeploymentDetails buildDetails();
  public A withDetails(DeploymentDetails details);
  public Boolean hasDetails();
  public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetails();
  public DeploymentConfigStatusFluent.DetailsNested<A> withNewDetailsLike(DeploymentDetails item);
  public DeploymentConfigStatusFluent.DetailsNested<A> editDetails();
  public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetails();
  public DeploymentConfigStatusFluent.DetailsNested<A> editOrNewDetailsLike(DeploymentDetails item);
  public Long getLatestVersion();
  public A withLatestVersion(Long latestVersion);
  public Boolean hasLatestVersion();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyReplicas();
  public A withReadyReplicas(Integer readyReplicas);
  public Boolean hasReadyReplicas();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public Integer getUnavailableReplicas();
  public A withUnavailableReplicas(Integer unavailableReplicas);
  public Boolean hasUnavailableReplicas();
  public Integer getUpdatedReplicas();
  public A withUpdatedReplicas(Integer updatedReplicas);
  public Boolean hasUpdatedReplicas();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,DeploymentConditionFluent<DeploymentConfigStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface DetailsNested<N> extends Nested<N>,DeploymentDetailsFluent<DeploymentConfigStatusFluent.DetailsNested<N>>{
    public N and();
    public N endDetails();
    
  }
  
}