package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretBuildSourceBuilder extends SecretBuildSourceFluentImpl<SecretBuildSourceBuilder> implements VisitableBuilder<SecretBuildSource,SecretBuildSourceBuilder>{
  public SecretBuildSourceBuilder() {
    this(false);
  }
  public SecretBuildSourceBuilder(Boolean validationEnabled) {
    this(new SecretBuildSource(), validationEnabled);
  }
  public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretBuildSource(), validationEnabled);
  }
  public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent,SecretBuildSource instance) {
    this(fluent, instance, false);
  }
  public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent,SecretBuildSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDestinationDir(instance.getDestinationDir());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretBuildSourceBuilder(SecretBuildSource instance) {
    this(instance,false);
  }
  public SecretBuildSourceBuilder(SecretBuildSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDestinationDir(instance.getDestinationDir());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretBuildSourceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretBuildSource build() {
    SecretBuildSource buildable = new SecretBuildSource(fluent.getDestinationDir(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}