package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectRulesReviewSpecBuilder extends SubjectRulesReviewSpecFluentImpl<SubjectRulesReviewSpecBuilder> implements VisitableBuilder<SubjectRulesReviewSpec,SubjectRulesReviewSpecBuilder>{
  public SubjectRulesReviewSpecBuilder() {
    this(false);
  }
  public SubjectRulesReviewSpecBuilder(Boolean validationEnabled) {
    this(new SubjectRulesReviewSpec(), validationEnabled);
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectRulesReviewSpec(), validationEnabled);
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,SubjectRulesReviewSpec instance) {
    this(fluent, instance, false);
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpecFluent<?> fluent,SubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGroups(instance.getGroups());
      fluent.withScopes(instance.getScopes());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpec instance) {
    this(instance,false);
  }
  public SubjectRulesReviewSpecBuilder(SubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGroups(instance.getGroups());
      this.withScopes(instance.getScopes());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectRulesReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectRulesReviewSpec build() {
    SubjectRulesReviewSpec buildable = new SubjectRulesReviewSpec(fluent.getGroups(),fluent.getScopes(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}