package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterNetworkFluent<A extends ClusterNetworkFluent<A>> extends BaseFluent<A>{
  public ClusterNetworkFluent() {
  }
  public ClusterNetworkFluent(ClusterNetwork instance) {
    instance = (instance != null ? instance : new ClusterNetwork());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withClusterNetworks(instance.getClusterNetworks());
      this.withHostsubnetlength(instance.getHostsubnetlength());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withMtu(instance.getMtu());
      this.withNetwork(instance.getNetwork());
      this.withPluginName(instance.getPluginName());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withVxlanPort(instance.getVxlanPort());
      this.withApiVersion(instance.getApiVersion());
      this.withClusterNetworks(instance.getClusterNetworks());
      this.withHostsubnetlength(instance.getHostsubnetlength());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withMtu(instance.getMtu());
      this.withNetwork(instance.getNetwork());
      this.withPluginName(instance.getPluginName());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withVxlanPort(instance.getVxlanPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
  private Integer hostsubnetlength;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Integer mtu;
  private String network;
  private String pluginName;
  private String serviceNetwork;
  private Integer vxlanPort;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToClusterNetworks(int index,ClusterNetworkEntry item) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetworks.size()) { _visitables.get("clusterNetworks").add(builder); clusterNetworks.add(builder); } else { _visitables.get("clusterNetworks").add(index, builder); clusterNetworks.add(index, builder);}
    return (A)this;
  }
  public A setToClusterNetworks(int index,ClusterNetworkEntry item) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetworks.size()) { _visitables.get("clusterNetworks").add(builder); clusterNetworks.add(builder); } else { _visitables.get("clusterNetworks").set(index, builder); clusterNetworks.set(index, builder);}
    return (A)this;
  }
  public A addToClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
  }
  public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
  }
  public A removeFromClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    if (this.clusterNetworks == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder); this.clusterNetworks.remove(builder);} return (A)this;
  }
  public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetworks == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder); this.clusterNetworks.remove(builder);} return (A)this;
  }
  public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetworks == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetworks.iterator();
    final List visitables = _visitables.get("clusterNetworks");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ClusterNetworkEntry> buildClusterNetworks() {
    return clusterNetworks != null ? build(clusterNetworks) : null;
  }
  public ClusterNetworkEntry buildClusterNetwork(int index) {
    return this.clusterNetworks.get(index).build();
  }
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetworks.get(0).build();
  }
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetworks.get(clusterNetworks.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks) {
    if (this.clusterNetworks != null) { _visitables.get("clusterNetworks").clear();}
    if (clusterNetworks != null) {this.clusterNetworks = new ArrayList(); for (ClusterNetworkEntry item : clusterNetworks){this.addToClusterNetworks(item);}} else { this.clusterNetworks = null;} return (A) this;
  }
  public A withClusterNetworks(io.fabric8.openshift.api.model.ClusterNetworkEntry... clusterNetworks) {
    if (this.clusterNetworks != null) {this.clusterNetworks.clear(); _visitables.remove("clusterNetworks"); }
    if (clusterNetworks != null) {for (ClusterNetworkEntry item :clusterNetworks){ this.addToClusterNetworks(item);}} return (A) this;
  }
  public boolean hasClusterNetworks() {
    return clusterNetworks != null && !clusterNetworks.isEmpty();
  }
  public A addNewClusterNetwork(String cidr,Integer hostSubnetLength) {
    return (A)addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public ClusterNetworksNested<A> addNewClusterNetwork() {
    return new ClusterNetworksNested(-1, null);
  }
  public ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new ClusterNetworksNested(-1, item);
  }
  public ClusterNetworksNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new ClusterNetworksNested(index, item);
  }
  public ClusterNetworksNested<A> editClusterNetwork(int index) {
    if (clusterNetworks.size() <= index) throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public ClusterNetworksNested<A> editFirstClusterNetwork() {
    if (clusterNetworks.size() == 0) throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public ClusterNetworksNested<A> editLastClusterNetwork() {
    int index = clusterNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetworks.size();i++) { 
    if (predicate.test(clusterNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public Integer getHostsubnetlength() {
    return this.hostsubnetlength;
  }
  public A withHostsubnetlength(Integer hostsubnetlength) {
    this.hostsubnetlength=hostsubnetlength; return (A) this;
  }
  public boolean hasHostsubnetlength() {
    return this.hostsubnetlength != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public Integer getMtu() {
    return this.mtu;
  }
  public A withMtu(Integer mtu) {
    this.mtu=mtu; return (A) this;
  }
  public boolean hasMtu() {
    return this.mtu != null;
  }
  public String getNetwork() {
    return this.network;
  }
  public A withNetwork(String network) {
    this.network=network; return (A) this;
  }
  public boolean hasNetwork() {
    return this.network != null;
  }
  public String getPluginName() {
    return this.pluginName;
  }
  public A withPluginName(String pluginName) {
    this.pluginName=pluginName; return (A) this;
  }
  public boolean hasPluginName() {
    return this.pluginName != null;
  }
  public String getServiceNetwork() {
    return this.serviceNetwork;
  }
  public A withServiceNetwork(String serviceNetwork) {
    this.serviceNetwork=serviceNetwork; return (A) this;
  }
  public boolean hasServiceNetwork() {
    return this.serviceNetwork != null;
  }
  public Integer getVxlanPort() {
    return this.vxlanPort;
  }
  public A withVxlanPort(Integer vxlanPort) {
    this.vxlanPort=vxlanPort; return (A) this;
  }
  public boolean hasVxlanPort() {
    return this.vxlanPort != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterNetworkFluent that = (ClusterNetworkFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(clusterNetworks, that.clusterNetworks)) return false;

    if (!java.util.Objects.equals(hostsubnetlength, that.hostsubnetlength)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(mtu, that.mtu)) return false;

    if (!java.util.Objects.equals(network, that.network)) return false;

    if (!java.util.Objects.equals(pluginName, that.pluginName)) return false;

    if (!java.util.Objects.equals(serviceNetwork, that.serviceNetwork)) return false;

    if (!java.util.Objects.equals(vxlanPort, that.vxlanPort)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clusterNetworks,  hostsubnetlength,  kind,  metadata,  mtu,  network,  pluginName,  serviceNetwork,  vxlanPort,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clusterNetworks != null && !clusterNetworks.isEmpty()) { sb.append("clusterNetworks:"); sb.append(clusterNetworks + ","); }
    if (hostsubnetlength != null) { sb.append("hostsubnetlength:"); sb.append(hostsubnetlength + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (pluginName != null) { sb.append("pluginName:"); sb.append(pluginName + ","); }
    if (serviceNetwork != null) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (vxlanPort != null) { sb.append("vxlanPort:"); sb.append(vxlanPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterNetworksNested<N> extends ClusterNetworkEntryFluent<ClusterNetworksNested<N>> implements Nested<N>{
    ClusterNetworksNested(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    public N and() {
      return (N) ClusterNetworkFluent.this.setToClusterNetworks(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterNetworkFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}