package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaListBuilder extends ClusterResourceQuotaListFluent<ClusterResourceQuotaListBuilder> implements VisitableBuilder<ClusterResourceQuotaList,ClusterResourceQuotaListBuilder>{
  public ClusterResourceQuotaListBuilder() {
    this(false);
  }
  public ClusterResourceQuotaListBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaList(), validationEnabled);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaList(), validationEnabled);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,ClusterResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaListFluent<?> fluent,ClusterResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterResourceQuotaList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaList instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaListBuilder(ClusterResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterResourceQuotaList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterResourceQuotaListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterResourceQuotaList build() {
    ClusterResourceQuotaList buildable = new ClusterResourceQuotaList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}